/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.io.File;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractRawFileOperationSupport
implements RawFileOperationSupport {
    private final boolean useNativeByteOrder;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected AbstractRawFileOperationSupport(boolean useNativeByteOrder) {
        this.useNativeByteOrder = useNativeByteOrder;
    }

    @Override
    public RawFileOperationSupport.RawFileDescriptor create(String filename, RawFileOperationSupport.FileCreationMode creationMode, RawFileOperationSupport.FileAccessMode accessMode) {
        return this.create(new File(filename), creationMode, accessMode);
    }

    @Override
    public RawFileOperationSupport.RawFileDescriptor open(String filename, RawFileOperationSupport.FileAccessMode accessMode) {
        return this.open(new File(filename), accessMode);
    }

    @Override
    @Uninterruptible(reason="Array must not move.")
    public boolean write(RawFileOperationSupport.RawFileDescriptor fd, byte[] data) {
        DynamicHub hub = KnownIntrinsics.readHub(data);
        UnsignedWord baseOffset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
        Word dataPtr = Word.objectToUntrackedPointer((Object)data).add(baseOffset);
        return this.write(fd, (Pointer)dataPtr, WordFactory.unsigned((int)data.length));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeBoolean(RawFileOperationSupport.RawFileDescriptor fd, boolean data) {
        return this.writeByte(fd, (byte)(data ? 1 : 0));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeByte(RawFileOperationSupport.RawFileDescriptor fd, byte data) {
        int sizeInBytes = 1;
        Pointer dataPtr = (Pointer)StackValue.get((int)sizeInBytes);
        dataPtr.writeByte(0, data);
        return this.write(fd, dataPtr, WordFactory.unsigned((int)sizeInBytes));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeShort(RawFileOperationSupport.RawFileDescriptor fd, short data) {
        int sizeInBytes = 2;
        Pointer dataPtr = (Pointer)StackValue.get((int)sizeInBytes);
        dataPtr.writeShort(0, this.useNativeByteOrder ? data : Short.reverseBytes(data));
        return this.write(fd, dataPtr, WordFactory.unsigned((int)sizeInBytes));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeChar(RawFileOperationSupport.RawFileDescriptor fd, char data) {
        int sizeInBytes = 2;
        Pointer dataPtr = (Pointer)StackValue.get((int)sizeInBytes);
        dataPtr.writeChar(0, this.useNativeByteOrder ? data : Character.reverseBytes(data));
        return this.write(fd, dataPtr, WordFactory.unsigned((int)sizeInBytes));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeInt(RawFileOperationSupport.RawFileDescriptor fd, int data) {
        int sizeInBytes = 4;
        Pointer dataPtr = (Pointer)StackValue.get((int)sizeInBytes);
        dataPtr.writeInt(0, this.useNativeByteOrder ? data : Integer.reverseBytes(data));
        return this.write(fd, dataPtr, WordFactory.unsigned((int)sizeInBytes));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeLong(RawFileOperationSupport.RawFileDescriptor fd, long data) {
        int sizeInBytes = 8;
        Pointer dataPtr = (Pointer)StackValue.get((int)sizeInBytes);
        dataPtr.writeLong(0, this.useNativeByteOrder ? data : Long.reverseBytes(data));
        return this.write(fd, dataPtr, WordFactory.unsigned((int)sizeInBytes));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeFloat(RawFileOperationSupport.RawFileDescriptor fd, float data) {
        return this.writeInt(fd, Float.floatToIntBits(data));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeDouble(RawFileOperationSupport.RawFileDescriptor fd, double data) {
        return this.writeLong(fd, Double.doubleToLongBits(data));
    }

    public static class RawFileOperationSupportHolder {
        private final RawFileOperationSupport littleEndian;
        private final RawFileOperationSupport bigEndian;
        private final RawFileOperationSupport nativeOrder;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public RawFileOperationSupportHolder(RawFileOperationSupport littleEndian, RawFileOperationSupport bigEndian, RawFileOperationSupport nativeOrder) {
            this.littleEndian = littleEndian;
            this.bigEndian = bigEndian;
            this.nativeOrder = nativeOrder;
        }

        @Fold
        static RawFileOperationSupportHolder singleton() {
            return (RawFileOperationSupportHolder)ImageSingletons.lookup(RawFileOperationSupportHolder.class);
        }

        @Fold
        public static RawFileOperationSupport getLittleEndian() {
            return RawFileOperationSupportHolder.singleton().littleEndian;
        }

        @Fold
        public static RawFileOperationSupport getBigEndian() {
            return RawFileOperationSupportHolder.singleton().bigEndian;
        }

        @Fold
        public static RawFileOperationSupport getNativeByteOrder() {
            return RawFileOperationSupportHolder.singleton().nativeOrder;
        }
    }
}

