/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.layeredimagesingleton;

import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.util.VMError;
import java.util.function.Function;

public interface MultiLayeredImageSingleton
extends LayeredImageSingleton {
    public static <T extends MultiLayeredImageSingleton> T[] getAllLayers(Class<T> key) {
        throw VMError.shouldNotReachHere("This can only be called during runtime");
    }

    public static <T extends MultiLayeredImageSingleton> T getForLayer(Class<T> key, int index) {
        throw VMError.shouldNotReachHere("This can only be called during runtime");
    }

    default public <T extends MultiLayeredImageSingleton, U> U getSingletonData(T singleton, T[] singletons, Function<T, U> getSingletonDataFunction) {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            for (T layerSingleton : singletons) {
                U result = getSingletonDataFunction.apply(layerSingleton);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return getSingletonDataFunction.apply(singleton);
    }
}

