/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.throttling;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.throttling.JfrSamplerParams;
import com.oracle.svm.core.util.BasedOnJDKFile;

class JfrSamplerWindow {
    private final JfrSamplerParams params = new JfrSamplerParams();
    private final UninterruptibleUtils.AtomicLong endTicks = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong measuredPopulationSize = new UninterruptibleUtils.AtomicLong(0L);
    private long samplingInterval = 1L;
    private long projectedPopulationSize;

    JfrSamplerWindow() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isExpired(long timestampNs) {
        return timestampNs >= this.endTicks.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initialize(long windowDurationMs) {
        assert (this.samplingInterval >= 1L);
        if (windowDurationMs == 0L) {
            this.endTicks.set(0L);
            return;
        }
        this.measuredPopulationSize.set(0L);
        this.endTicks.set(JfrTicks.now() + JfrTicks.millisToTicks(windowDurationMs));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void copyParams(JfrSamplerParams other) {
        this.params.initializeFrom(other);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L104-L108")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean sample() {
        long ordinal = this.measuredPopulationSize.incrementAndGet();
        return ordinal <= this.projectedPopulationSize && ordinal % this.samplingInterval == 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getSamplingInterval() {
        return this.samplingInterval;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setSamplingInterval(long value) {
        this.samplingInterval = value;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPopulationSize() {
        return this.measuredPopulationSize.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getProjectedPopulationSize() {
        return this.projectedPopulationSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setProjectedPopulationSize(long value) {
        this.projectedPopulationSize = value;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L285-L287")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getAccumulatedDebt() {
        return this.projectedPopulationSize == 0L ? 0L : this.params.samplePointsPerWindow - this.getMaxSampleSize() + this.getDebt();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L289-L291")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long getDebt() {
        return this.projectedPopulationSize == 0L ? 0L : this.getSampleSize() - this.params.samplePointsPerWindow;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L271-L273")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long getMaxSampleSize() {
        return this.projectedPopulationSize / this.samplingInterval;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L276-L279")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long getSampleSize() {
        long size = this.getPopulationSize();
        return size > this.projectedPopulationSize ? this.getMaxSampleSize() : size / this.samplingInterval;
    }

    static class TestingBackdoor {
        TestingBackdoor() {
        }

        public static void expire(JfrSamplerWindow window) {
            window.endTicks.set(0L);
        }
    }
}

