/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.Target_sun_nio_fs_UnixFileSystem;
import com.oracle.svm.core.jdk.Target_sun_nio_fs_UnixPath;
import com.oracle.svm.core.util.BasedOnJDKFile;
import jdk.internal.util.StaticProperty;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
class UnixFileSystemAccessors {
    UnixFileSystemAccessors() {
    }

    static byte[] getDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 0) {
            UnixFileSystemAccessors.reinitialize(that);
        }
        return that.injectedDefaultDirectory;
    }

    static boolean getNeedToResolveAgainstDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 0) {
            UnixFileSystemAccessors.reinitialize(that);
        }
        return that.injectedNeedToResolveAgainstDefaultDirectory;
    }

    static Target_sun_nio_fs_UnixPath getRootDirectory(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 0) {
            UnixFileSystemAccessors.reinitialize(that);
        }
        return that.injectedRootDirectory;
    }

    static void setDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that, byte[] value) {
        that.injectedDefaultDirectory = value;
    }

    static void setNeedToResolveAgainstDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that, boolean value) {
        that.injectedNeedToResolveAgainstDefaultDirectory = value;
    }

    static void setRootDirectory(Target_sun_nio_fs_UnixFileSystem that, Target_sun_nio_fs_UnixPath value) {
        that.injectedRootDirectory = value;
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+20/src/java.base/linux/classes/sun/nio/fs/LinuxFileSystem.java#L44-L46"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+20/src/java.base/linux/classes/sun/nio/fs/LinuxFileSystemProvider.java#L45-L47"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+20/src/java.base/unix/classes/sun/nio/fs/UnixFileSystemProvider.java#L75-L77"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+20/src/java.base/unix/classes/sun/nio/fs/UnixFileSystem.java#L78-L108")})
    private static synchronized void reinitialize(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 2) {
            return;
        }
        that.needsReinitialization = 1;
        that.originalConstructor(that.provider, StaticProperty.userDir());
        that.needsReinitialization = 0;
    }
}

