/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.ReservedRegisters;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.nativeimage.IsolateThread;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class WriteCurrentVMThreadNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<WriteCurrentVMThreadNode> TYPE = NodeClass.create(WriteCurrentVMThreadNode.class);
    @Node.Input
    protected ValueNode value;

    protected WriteCurrentVMThreadNode(ValueNode value) {
        super(TYPE, StampFactory.forVoid());
        this.value = value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        gen.getLIRGeneratorTool().emitWriteRegister(ReservedRegisters.singleton().getThreadRegister(), gen.operand((Node)this.value), (ValueKind)tool.getLIRKind(FrameAccess.getWordStamp()));
    }

    @Node.NodeIntrinsic
    public static native void writeCurrentVMThread(IsolateThread var0);
}

