/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.HostedWrapper;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.code.SubstrateSuitesCreatorProvider;
import com.oracle.svm.core.util.VMError;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import jdk.graal.compiler.core.aarch64.AArch64NodeMatchRules;
import jdk.graal.compiler.core.amd64.AMD64NodeMatchRules;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.core.gen.NodeMatchRules;
import jdk.graal.compiler.core.match.MatchRuleRegistry;
import jdk.graal.compiler.core.match.MatchStatement;
import jdk.graal.compiler.core.riscv64.RISCV64NodeMatchRules;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.loop.LoopsDataProviderImpl;
import jdk.graal.compiler.nodes.spi.LoopsDataProvider;
import jdk.graal.compiler.nodes.spi.LoweringProvider;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.riscv64.RISCV64;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public class GraalConfiguration {
    private static final String COMPILER_CONFIGURATION_NAME = "community";

    public static GraalConfiguration hostedInstance() {
        return ((HostedWrapper)ImageSingletons.lookup(HostedWrapper.class)).config;
    }

    public static void setHostedInstanceIfEmpty(GraalConfiguration config) {
        if (!ImageSingletons.contains(HostedWrapper.class)) {
            ImageSingletons.add(HostedWrapper.class, (Object)new HostedWrapper(config));
        }
    }

    public static GraalConfiguration runtimeInstance() {
        return (GraalConfiguration)ImageSingletons.lookup(GraalConfiguration.class);
    }

    public static void setRuntimeInstance(GraalConfiguration config) {
        ImageSingletons.add(GraalConfiguration.class, (Object)config);
    }

    public static void setDefaultIfEmpty() {
        if (!ImageSingletons.contains(GraalConfiguration.class) || !ImageSingletons.contains(HostedWrapper.class)) {
            GraalConfiguration instance = new GraalConfiguration();
            if (!ImageSingletons.contains(GraalConfiguration.class)) {
                ImageSingletons.add(GraalConfiguration.class, (Object)instance);
            }
            if (!ImageSingletons.contains(HostedWrapper.class)) {
                ImageSingletons.add(HostedWrapper.class, (Object)new HostedWrapper(instance));
            }
        }
    }

    public LoweringProvider createLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider) {
        return ((SubstrateLoweringProviderFactory)ImageSingletons.lookup(SubstrateLoweringProviderFactory.class)).newLoweringProvider(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, ConfigurationValues.getTarget());
    }

    public Suites createSuites(OptionValues options, boolean hosted, Architecture arch) {
        return ((SubstrateSuitesCreatorProvider)ImageSingletons.lookup(SubstrateSuitesCreatorProvider.class)).getSuitesCreator().createSuites(options, arch);
    }

    public Suites createFirstTierSuites(OptionValues options, boolean hosted, Architecture arch) {
        return ((SubstrateSuitesCreatorProvider)ImageSingletons.lookup(SubstrateSuitesCreatorProvider.class)).getFirstTierSuitesCreator().createSuites(options, arch);
    }

    public LIRSuites createLIRSuites(OptionValues options) {
        return ((SubstrateSuitesCreatorProvider)ImageSingletons.lookup(SubstrateSuitesCreatorProvider.class)).getSuitesCreator().createLIRSuites(options);
    }

    public LIRSuites createFirstTierLIRSuites(OptionValues options) {
        return ((SubstrateSuitesCreatorProvider)ImageSingletons.lookup(SubstrateSuitesCreatorProvider.class)).getFirstTierSuitesCreator().createLIRSuites(options);
    }

    public String getCompilerConfigurationName() {
        return COMPILER_CONFIGURATION_NAME;
    }

    public void populateMatchRuleRegistry(HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry) {
        Class<AMD64NodeMatchRules> matchRuleClass;
        Architecture hostedArchitecture = ConfigurationValues.getTarget().arch;
        if (hostedArchitecture instanceof AMD64) {
            matchRuleClass = AMD64NodeMatchRules.class;
        } else if (hostedArchitecture instanceof AArch64) {
            matchRuleClass = AArch64NodeMatchRules.class;
        } else if (hostedArchitecture instanceof RISCV64) {
            matchRuleClass = RISCV64NodeMatchRules.class;
        } else {
            throw VMError.shouldNotReachHere("Can not instantiate NodeMatchRules for architecture " + hostedArchitecture.getName());
        }
        matchRuleRegistry.put(matchRuleClass, (EconomicMap<Class<? extends Node>, List<MatchStatement>>)MatchRuleRegistry.createRules(matchRuleClass));
    }

    public SubstrateBackend createBackend(Providers newProviders) {
        return SubstrateBackendFactory.get().newBackend(newProviders);
    }

    public void removeDeoptTargetOptimizations(Suites suites) {
    }

    public ListIterator<BasePhase<? super HighTierContext>> createHostedInliners(PhaseSuite<HighTierContext> highTier) {
        return null;
    }

    public LoopsDataProvider createLoopsDataProvider() {
        return new LoopsDataProviderImpl();
    }
}

