/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.gc.NoBarrierSet;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class NoRememberedSet
implements RememberedSet {
    @Override
    public BarrierSet createBarrierSet(MetaAccessProvider metaAccess) {
        return new NoBarrierSet();
    }

    @Override
    public UnsignedWord getHeaderSizeOfAlignedChunk() {
        UnsignedWord headerSize = WordFactory.unsigned((int)SizeOf.get(AlignedHeapChunk.AlignedHeader.class));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Override
    public UnsignedWord getHeaderSizeOfUnalignedChunk() {
        UnsignedWord headerSize = WordFactory.unsigned((int)SizeOf.get(UnalignedHeapChunk.UnalignedHeader.class));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void enableRememberedSetForAlignedChunk(HostedByteBufferPointer chunk, int chunkPosition, List<ImageHeapObject> objects) {
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void enableRememberedSetForUnalignedChunk(HostedByteBufferPointer chunk) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForChunk(AlignedHeapChunk.AlignedHeader chunk) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForObject(AlignedHeapChunk.AlignedHeader chunk, Object obj, UnsignedWord objSize) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearRememberedSet(AlignedHeapChunk.AlignedHeader chunk) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearRememberedSet(UnalignedHeapChunk.UnalignedHeader chunk) {
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasRememberedSet(UnsignedWord header) {
        return false;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardForAlignedObject(Object object, boolean verifyOnly) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardForUnalignedObject(Object object, boolean verifyOnly) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardIfNecessary(Object holderObject, Object object) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkDirtyObjects(AlignedHeapChunk.AlignedHeader chunk, GreyToBlackObjectVisitor visitor, boolean clean) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkDirtyObjects(UnalignedHeapChunk.UnalignedHeader chunk, GreyToBlackObjectVisitor visitor, boolean clean) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkDirtyObjects(Space space, GreyToBlackObjectVisitor visitor, boolean clean) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    public boolean verify(AlignedHeapChunk.AlignedHeader firstAlignedHeapChunk) {
        return true;
    }

    @Override
    public boolean verify(UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk) {
        return true;
    }

    @Override
    public boolean verify(UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk, UnalignedHeapChunk.UnalignedHeader lastUnalignedHeapChunk) {
        return true;
    }
}

