/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.StringBuilderLog;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.monitor.MonitorSupport;
import java.lang.ref.WeakReference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class DeoptimizedFrame {
    private final long sourceEncodedFrameSize;
    private final WeakReference<SubstrateInstalledCode> sourceInstalledCode;
    private final VirtualFrame topFrame;
    private final Deoptimizer.TargetContent targetContent;
    private final RelockObjectData[] relockedObjects;
    private final PinnedObject pin;
    private final CodePointer sourcePC;
    private final char[] completedMessage;
    private final boolean rethrowException;

    protected static DeoptimizedFrame factory(int targetContentSize, long sourceEncodedFrameSize, SubstrateInstalledCode sourceInstalledCode, VirtualFrame topFrame, RelockObjectData[] relockedObjects, CodePointer sourcePC, boolean rethrowException) {
        Deoptimizer.TargetContent targetContentBuffer = new Deoptimizer.TargetContent(targetContentSize, ConfigurationValues.getTarget().arch.getByteOrder());
        return new DeoptimizedFrame(sourceEncodedFrameSize, sourceInstalledCode, topFrame, targetContentBuffer, relockedObjects, sourcePC, rethrowException);
    }

    private DeoptimizedFrame(long sourceEncodedFrameSize, SubstrateInstalledCode sourceInstalledCode, VirtualFrame topFrame, Deoptimizer.TargetContent targetContent, RelockObjectData[] relockedObjects, CodePointer sourcePC, boolean rethrowException) {
        this.sourceEncodedFrameSize = sourceEncodedFrameSize;
        this.topFrame = topFrame;
        this.targetContent = targetContent;
        this.relockedObjects = relockedObjects;
        this.sourceInstalledCode = sourceInstalledCode == null ? null : new WeakReference<SubstrateInstalledCode>(sourceInstalledCode);
        this.sourcePC = sourcePC;
        this.pin = PinnedObject.create((Object)this);
        StringBuilderLog sbl = new StringBuilderLog();
        sbl.string("deoptStub: completed for DeoptimizedFrame at ").hex((WordBase)this.pin.addressOfObject()).newline();
        this.completedMessage = sbl.getResult().toCharArray();
        this.rethrowException = rethrowException;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getSourceEncodedFrameSize() {
        return this.sourceEncodedFrameSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getSourceTotalFrameSize() {
        return CodeInfoQueryResult.getTotalFrameSize(this.sourceEncodedFrameSize);
    }

    public SubstrateInstalledCode getSourceInstalledCode() {
        return this.sourceInstalledCode == null ? null : (SubstrateInstalledCode)this.sourceInstalledCode.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VirtualFrame getTopFrame() {
        return this.topFrame;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Deoptimizer.TargetContent getTargetContent() {
        return this.targetContent;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PinnedObject getPin() {
        return this.pin;
    }

    public CodePointer getSourcePC() {
        return this.sourcePC;
    }

    @Uninterruptible(reason="Called from Deoptimizer.deoptStub.")
    char[] getCompletedMessage() {
        return this.completedMessage;
    }

    @Uninterruptible(reason="Reads pointer values from the stack frame to unmanaged storage.")
    protected void buildContent(Pointer newSp) {
        VirtualFrame cur = this.topFrame;
        do {
            cur.returnAddress.write(this.targetContent);
            if (cur.savedBasePointer != null) {
                cur.savedBasePointer.write(this.targetContent, newSp);
            }
            for (int i = 0; i < cur.values.length; ++i) {
                if (cur.values[i] == null) continue;
                cur.values[i].write(this.targetContent);
            }
        } while ((cur = cur.caller) != null);
        if (this.relockedObjects != null) {
            for (RelockObjectData relockedObject : this.relockedObjects) {
                MonitorSupport.singleton().doRelockObject(relockedObject.object, relockedObject.lockData);
            }
        }
    }

    public void takeException() {
        if (this.rethrowException) {
            return;
        }
        ReturnAddress firstAddressEntry = this.topFrame.returnAddress;
        CodePointer ip = (CodePointer)WordFactory.pointer((long)firstAddressEntry.returnAddress);
        CodeInfo info = CodeInfoTable.getImageCodeInfo(ip);
        SimpleCodeInfoQueryResult codeInfoQueryResult = UnsafeStackValue.get(SimpleCodeInfoQueryResult.class);
        CodeInfoAccess.lookupCodeInfo(info, ip, codeInfoQueryResult);
        long handler = codeInfoQueryResult.getExceptionOffset();
        if (handler == 0L) {
            DeoptimizedFrame.throwMissingExceptionHandler(info, firstAddressEntry);
        }
        firstAddressEntry.returnAddress += handler;
    }

    @NeverInline(value="Has more relaxed heap access requirements than caller.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Printing out error and then crashing.")
    private static void throwMissingExceptionHandler(CodeInfo info, ReturnAddress firstAddressEntry) {
        CodeInfoQueryResult detailedQueryResult = new CodeInfoQueryResult();
        CodeInfoAccess.lookupCodeInfo(info, (CodePointer)WordFactory.pointer((long)firstAddressEntry.returnAddress), detailedQueryResult);
        FrameInfoQueryResult frameInfo = detailedQueryResult.getFrameInfo();
        throw Deoptimizer.fatalDeoptimizationError("No exception handler registered for deopt target", frameInfo);
    }

    public static class VirtualFrame {
        protected final FrameInfoQueryResult frameInfo;
        protected VirtualFrame caller;
        protected ReturnAddress returnAddress;
        protected SavedBasePointer savedBasePointer;
        protected final ConstantEntry[] values;

        protected VirtualFrame(FrameInfoQueryResult frameInfo) {
            this.frameInfo = frameInfo;
            this.values = new ConstantEntry[frameInfo.getValueInfos().length];
        }

        public VirtualFrame getCaller() {
            return this.caller;
        }

        public FrameInfoQueryResult getFrameInfo() {
            return this.frameInfo;
        }

        public JavaConstant getConstant(int index) {
            if (index >= this.values.length || this.values[index] == null) {
                return JavaConstant.forIllegal();
            }
            return this.values[index].constant;
        }
    }

    static class RelockObjectData {
        final Object object;
        final Object lockData;

        RelockObjectData(Object object, Object lockData) {
            this.object = object;
            this.lockData = lockData;
        }
    }

    static class ReturnAddress
    extends Entry {
        protected long returnAddress;

        protected ReturnAddress(int offset, long returnAddress) {
            super(offset);
            this.returnAddress = returnAddress;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeLong(this.offset, this.returnAddress);
        }
    }

    static class SavedBasePointer {
        private final int offset;
        private final long valueRelativeToNewSp;

        protected SavedBasePointer(int offset, long valueRelativeToNewSp) {
            this.offset = offset;
            this.valueRelativeToNewSp = valueRelativeToNewSp;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void write(Deoptimizer.TargetContent targetContent, Pointer newSp) {
            targetContent.writeWord(this.offset, (WordBase)newSp.add(WordFactory.unsigned((long)this.valueRelativeToNewSp)));
        }
    }

    static abstract class ConstantEntry
    extends Entry {
        protected final JavaConstant constant;

        protected static ConstantEntry factory(int offset, JavaConstant constant, FrameInfoQueryResult frameInfo) {
            switch (constant.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Short: 
                case Int: {
                    return new FourByteConstantEntry(offset, constant, constant.asInt());
                }
                case Float: {
                    return new FourByteConstantEntry(offset, constant, Float.floatToIntBits(constant.asFloat()));
                }
                case Long: {
                    return new EightByteConstantEntry(offset, constant, constant.asLong());
                }
                case Double: {
                    return new EightByteConstantEntry(offset, constant, Double.doubleToLongBits(constant.asDouble()));
                }
                case Object: {
                    return new ObjectConstantEntry(offset, constant, SubstrateObjectConstant.asObject((Constant)constant), SubstrateObjectConstant.isCompressed(constant));
                }
            }
            throw Deoptimizer.fatalDeoptimizationError("Unexpected constant type: " + String.valueOf(constant), frameInfo);
        }

        protected ConstantEntry(int offset, JavaConstant constant) {
            super(offset);
            this.constant = constant;
        }
    }

    static class ObjectConstantEntry
    extends ConstantEntry {
        protected final Object value;
        protected final boolean compressed;

        protected ObjectConstantEntry(int offset, JavaConstant constant, Object value, boolean compressed) {
            super(offset, constant);
            this.value = value;
            this.compressed = compressed;
        }

        @Override
        @Uninterruptible(reason="Writes pointers to unmanaged storage.")
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeObject(this.offset, this.value, this.compressed);
        }
    }

    static class EightByteConstantEntry
    extends ConstantEntry {
        protected final long value;

        protected EightByteConstantEntry(int offset, JavaConstant constant, long value) {
            super(offset, constant);
            this.value = value;
        }

        @Override
        @Uninterruptible(reason="Writes pointers to unmanaged storage.")
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeLong(this.offset, this.value);
        }
    }

    static class FourByteConstantEntry
    extends ConstantEntry {
        protected final int value;

        protected FourByteConstantEntry(int offset, JavaConstant constant, int value) {
            super(offset, constant);
            this.value = value;
        }

        @Override
        @Uninterruptible(reason="Writes pointers to unmanaged storage.")
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeInt(this.offset, this.value);
        }
    }

    static abstract class Entry {
        protected final int offset;

        protected Entry(int offset) {
            this.offset = offset;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected abstract void write(Deoptimizer.TargetContent var1);
    }
}

