/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.handles.PrimitiveArrayView;
import java.util.Arrays;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

final class CCharPointerHolderImpl
implements CTypeConversion.CCharPointerHolder {
    private final PrimitiveArrayView cstring;

    CCharPointerHolderImpl(CharSequence javaString) {
        byte[] bytes = javaString.toString().getBytes();
        bytes = Arrays.copyOf(bytes, bytes.length + 1);
        this.cstring = PrimitiveArrayView.createForReading(bytes);
    }

    CCharPointerHolderImpl(byte[] bytes) {
        this.cstring = PrimitiveArrayView.createForReading(bytes);
    }

    public CCharPointer get() {
        return (CCharPointer)this.cstring.addressOfArrayElement(0);
    }

    public void close() {
        this.cstring.close();
    }
}

