/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.fieldaccessor;

import com.oracle.svm.core.reflect.fieldaccessor.UnsafeBooleanFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeByteFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeCharacterFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeDoubleFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeFloatFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeIntegerFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeLongFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeObjectFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedBooleanFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedByteFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedCharacterFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedDoubleFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedFloatFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedIntegerFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedLongFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedObjectFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedShortFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticBooleanFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticByteFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticCharacterFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticDoubleFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticFloatFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticIntegerFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticLongFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticObjectFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedStaticShortFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeShortFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticBooleanFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticByteFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticCharacterFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticDoubleFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticFloatFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticIntegerFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticLongFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticObjectFieldAccessorImpl;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeStaticShortFieldAccessorImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.internal.reflect.FieldAccessor;

public class UnsafeFieldAccessorFactory {
    public static FieldAccessor newFieldAccessor(Field field, boolean isReadOnly) {
        boolean isQualified;
        Class<?> type = field.getType();
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        boolean isFinal = Modifier.isFinal(field.getModifiers());
        boolean isVolatile = Modifier.isVolatile(field.getModifiers());
        boolean bl = isQualified = isFinal || isVolatile;
        if (isStatic) {
            UnsafeFieldAccessorImpl.unsafe.ensureClassInitialized(field.getDeclaringClass());
            if (!isQualified) {
                if (type == Boolean.TYPE) {
                    return new UnsafeStaticBooleanFieldAccessorImpl(field);
                }
                if (type == Byte.TYPE) {
                    return new UnsafeStaticByteFieldAccessorImpl(field);
                }
                if (type == Short.TYPE) {
                    return new UnsafeStaticShortFieldAccessorImpl(field);
                }
                if (type == Character.TYPE) {
                    return new UnsafeStaticCharacterFieldAccessorImpl(field);
                }
                if (type == Integer.TYPE) {
                    return new UnsafeStaticIntegerFieldAccessorImpl(field);
                }
                if (type == Long.TYPE) {
                    return new UnsafeStaticLongFieldAccessorImpl(field);
                }
                if (type == Float.TYPE) {
                    return new UnsafeStaticFloatFieldAccessorImpl(field);
                }
                if (type == Double.TYPE) {
                    return new UnsafeStaticDoubleFieldAccessorImpl(field);
                }
                return new UnsafeStaticObjectFieldAccessorImpl(field);
            }
            if (type == Boolean.TYPE) {
                return new UnsafeQualifiedStaticBooleanFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Byte.TYPE) {
                return new UnsafeQualifiedStaticByteFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Short.TYPE) {
                return new UnsafeQualifiedStaticShortFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Character.TYPE) {
                return new UnsafeQualifiedStaticCharacterFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Integer.TYPE) {
                return new UnsafeQualifiedStaticIntegerFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Long.TYPE) {
                return new UnsafeQualifiedStaticLongFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Float.TYPE) {
                return new UnsafeQualifiedStaticFloatFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Double.TYPE) {
                return new UnsafeQualifiedStaticDoubleFieldAccessorImpl(field, isReadOnly);
            }
            return new UnsafeQualifiedStaticObjectFieldAccessorImpl(field, isReadOnly);
        }
        if (!isQualified) {
            if (type == Boolean.TYPE) {
                return new UnsafeBooleanFieldAccessorImpl(field);
            }
            if (type == Byte.TYPE) {
                return new UnsafeByteFieldAccessorImpl(field);
            }
            if (type == Short.TYPE) {
                return new UnsafeShortFieldAccessorImpl(field);
            }
            if (type == Character.TYPE) {
                return new UnsafeCharacterFieldAccessorImpl(field);
            }
            if (type == Integer.TYPE) {
                return new UnsafeIntegerFieldAccessorImpl(field);
            }
            if (type == Long.TYPE) {
                return new UnsafeLongFieldAccessorImpl(field);
            }
            if (type == Float.TYPE) {
                return new UnsafeFloatFieldAccessorImpl(field);
            }
            if (type == Double.TYPE) {
                return new UnsafeDoubleFieldAccessorImpl(field);
            }
            return new UnsafeObjectFieldAccessorImpl(field);
        }
        if (type == Boolean.TYPE) {
            return new UnsafeQualifiedBooleanFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Byte.TYPE) {
            return new UnsafeQualifiedByteFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Short.TYPE) {
            return new UnsafeQualifiedShortFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Character.TYPE) {
            return new UnsafeQualifiedCharacterFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Integer.TYPE) {
            return new UnsafeQualifiedIntegerFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Long.TYPE) {
            return new UnsafeQualifiedLongFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Float.TYPE) {
            return new UnsafeQualifiedFloatFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Double.TYPE) {
            return new UnsafeQualifiedDoubleFieldAccessorImpl(field, isReadOnly);
        }
        return new UnsafeQualifiedObjectFieldAccessorImpl(field, isReadOnly);
    }
}

