/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.word.PointerBase;

public interface MemoryProtectionProvider {
    @Fold
    public static MemoryProtectionProvider singleton() {
        return (MemoryProtectionProvider)ImageSingletons.lookup(MemoryProtectionProvider.class);
    }

    @Fold
    public static boolean isAvailable() {
        return ImageSingletons.contains(MemoryProtectionProvider.class);
    }

    public void unlockCurrentIsolate();

    public void handleSegfault(PointerBase var1);

    public void printSignalInfo(PointerBase var1);

    public Isolates.ProtectionDomain getProtectionDomain();

    public int asProtectionKey(Isolates.ProtectionDomain var1) throws UnsupportedDomainException;

    public static class UnsupportedDomainException
    extends Exception {
        private static final long serialVersionUID = 1L;

        @Override
        public String getMessage() {
            return "Protection domain unrecognized.";
        }
    }
}

