/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.graalvm.nativeimage.ImageSingletons;
import sun.util.resources.Bundles;

@TargetClass(value=ResourceBundle.class, innerClass={"Control"})
final class Target_java_util_ResourceBundle_Control {
    Target_java_util_ResourceBundle_Control() {
    }

    @Substitute
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        return false;
    }

    @Substitute
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String otherBundleName;
        String bundleName = this.toBundleName(baseName, locale);
        if (format.equals("java.class") && ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).isNotIncluded(bundleName)) {
            return null;
        }
        ResourceBundle bundle = this.newBundle0(bundleName, format, loader, reload);
        if (bundle == null && !bundleName.equals(otherBundleName = Bundles.toOtherBundleName(baseName, bundleName, locale))) {
            bundle = this.newBundle0(otherBundleName, format, loader, reload);
        }
        return bundle;
    }

    @Alias
    public native String toBundleName(String var1, Locale var2);

    @Alias
    private native ResourceBundle newBundle0(String var1, String var2, ClassLoader var3, boolean var4) throws IllegalAccessException, InstantiationException, IOException;
}

