/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface ExplicitCallingConvention {
    public SubstrateCallingConventionKind value();

    public static class Util {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static SubstrateCallingConventionKind getCallingConventionKind(ResolvedJavaMethod method, boolean isEntryPoint) {
            ExplicitCallingConvention explicitCallingConvention = (ExplicitCallingConvention)AnnotationAccess.getAnnotation((AnnotatedElement)method, ExplicitCallingConvention.class);
            if (explicitCallingConvention != null) {
                return explicitCallingConvention.value();
            }
            if (isEntryPoint) {
                return SubstrateCallingConventionKind.Native;
            }
            return SubstrateCallingConventionKind.Java;
        }
    }
}

