/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.GreyObjectsWalker;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public final class OldGeneration
extends Generation {
    private final Space fromSpace;
    private final Space toSpace;
    private final GreyObjectsWalker toGreyObjectsWalker = new GreyObjectsWalker();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    OldGeneration(String name) {
        super(name);
        int age = HeapParameters.getMaxSurvivorSpaces() + 1;
        this.fromSpace = new Space("Old", "O", true, age);
        this.toSpace = new Space("Old To", "O", false, age);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        this.fromSpace.tearDown();
        this.toSpace.tearDown();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        return this.getFromSpace().walkObjects(visitor) && this.getToSpace().walkObjects(visitor);
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object promoteAlignedObject(Object original, AlignedHeapChunk.AlignedHeader originalChunk, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        return this.getToSpace().promoteAlignedObject(original, originalSpace);
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Object promoteUnalignedObject(Object original, UnalignedHeapChunk.UnalignedHeader originalChunk, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        this.getToSpace().promoteUnalignedHeapChunk(originalChunk, originalSpace);
        return original;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean promoteChunk(HeapChunk.Header<?> originalChunk, boolean isAligned, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        if (isAligned) {
            this.getToSpace().promoteAlignedHeapChunk((AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace);
        } else {
            this.getToSpace().promoteUnalignedHeapChunk((UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace);
        }
        return true;
    }

    void releaseSpaces(GCImpl.ChunkReleaser chunkReleaser) {
        this.getFromSpace().releaseChunks(chunkReleaser);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void prepareForPromotion() {
        this.toGreyObjectsWalker.setScanStart(this.getToSpace());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean scanGreyObjects() {
        if (!this.toGreyObjectsWalker.haveGreyObjects()) {
            return false;
        }
        this.toGreyObjectsWalker.walkGreyObjects();
        return true;
    }

    @Override
    public void logUsage(Log log) {
        this.getFromSpace().logUsage(log, true);
        this.getToSpace().logUsage(log, false);
    }

    @Override
    public void logChunks(Log log) {
        this.getFromSpace().logChunks(log);
        this.getToSpace().logChunks(log);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getFromSpace() {
        return this.fromSpace;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getToSpace() {
        return this.toSpace;
    }

    void swapSpaces() {
        assert (this.getFromSpace().isEmpty()) : "fromSpace should be empty.";
        this.getFromSpace().absorb(this.getToSpace());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void emptyFromSpaceIntoToSpace() {
        this.getToSpace().absorb(this.getFromSpace());
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        return this.getFromSpace().walkHeapChunks(visitor) && this.getToSpace().walkHeapChunks(visitor);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getChunkBytes() {
        return this.fromSpace.getChunkBytes().add(this.toSpace.getChunkBytes());
    }

    UnsignedWord computeObjectBytes() {
        return this.fromSpace.computeObjectBytes().add(this.toSpace.computeObjectBytes());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader requestAlignedChunk() {
        assert (VMOperation.isGCInProgress()) : "Should only be called from the collector.";
        AlignedHeapChunk.AlignedHeader chunk = HeapImpl.getChunkProvider().produceAlignedChunk();
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)chunk.isNull())) {
            throw VMError.shouldNotReachHere("OldGeneration.requestAlignedChunk: failure to allocate aligned chunk");
        }
        RememberedSet.get().enableRememberedSetForChunk(chunk);
        return chunk;
    }
}

