/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.util.LogUtils;
import java.util.Collection;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.ImageInfo;

public interface ConfigurationTypeDescriptor
extends Comparable<ConfigurationTypeDescriptor>,
JsonPrintable {
    public static String canonicalizeTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        String name = typeName;
        if (name.indexOf(91) != -1) {
            name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
        }
        return name;
    }

    public Kind getDescriptorType();

    public String toString();

    public Collection<String> getAllQualifiedJavaNames();

    public static String checkQualifiedJavaName(String javaName) {
        if (ImageInfo.inImageBuildtimeCode() && javaName.indexOf(47) != -1 && javaName.indexOf(47) <= javaName.lastIndexOf(46)) {
            LogUtils.warning((String)"Type descriptor requires qualified Java name, not internal representation: %s", (Object[])new Object[]{javaName});
        }
        return ConfigurationTypeDescriptor.canonicalizeTypeName(javaName);
    }

    public static enum Kind {
        NAMED,
        PROXY;

    }
}

