/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaField;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedElement;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;

public class HostedField
extends HostedElement
implements OriginalFieldProvider,
SharedField,
WrappedJavaField {
    private final HostedUniverse universe;
    private final HostedMetaAccess metaAccess;
    public final AnalysisField wrapped;
    private final HostedType holder;
    private final HostedType type;
    protected int location;
    private final JavaTypeProfile typeProfile;
    static final int LOC_UNMATERIALIZED_STATIC_CONSTANT = -10;

    public HostedField(HostedUniverse universe, HostedMetaAccess metaAccess, AnalysisField wrapped, HostedType holder, HostedType type, JavaTypeProfile typeProfile) {
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.wrapped = wrapped;
        this.holder = holder;
        this.type = type;
        this.typeProfile = typeProfile;
        this.location = -1;
    }

    public AnalysisField getWrapped() {
        return this.wrapped;
    }

    public JavaTypeProfile getFieldTypeProfile() {
        return this.typeProfile;
    }

    protected void setLocation(int location) {
        assert (this.location == -1);
        assert (location >= 0);
        this.location = location;
    }

    protected void setUnmaterializedStaticConstant() {
        assert (this.location == -1 && this.isStatic());
        this.location = -10;
    }

    public boolean hasLocation() {
        return this.location >= 0;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public boolean isAccessed() {
        return this.wrapped.isAccessed();
    }

    @Override
    public boolean isReachable() {
        return this.wrapped.isReachable();
    }

    public boolean isRead() {
        return this.wrapped.isRead();
    }

    @Override
    public boolean isWritten() {
        return this.wrapped.isWritten();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public HostedType getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public JavaConstant readValue(JavaConstant receiver) {
        JavaConstant wrappedReceiver;
        if (this.metaAccess.isInstanceOf(receiver, Class.class)) {
            Object classObject = SubstrateObjectConstant.asObject((Constant)receiver);
            if (classObject instanceof Class) {
                throw VMError.shouldNotReachHere("Receiver " + receiver + " of field " + this + " read should not be java.lang.Class. Expecting to see DynamicHub here.");
            }
            VMError.guarantee(classObject instanceof DynamicHub);
            wrappedReceiver = receiver;
        } else {
            wrappedReceiver = receiver;
        }
        return this.universe.lookup(this.universe.getConstantReflectionProvider().readValue(this.metaAccess, this.wrapped, wrappedReceiver));
    }

    public JavaConstant readStorageValue(JavaConstant receiver) {
        JavaConstant result = this.readValue(receiver);
        assert (result != null) : "Cannot read value for field " + this.format("%H.%n");
        assert (result.getJavaKind() == this.getType().getStorageKind()) : this;
        return result;
    }

    public HostedType getDeclaringClass() {
        return this.holder;
    }

    public boolean isInternal() {
        return this.wrapped.isInternal();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public String toString() {
        return "HostedField<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", location: " + this.location + ">";
    }

    @Override
    public JavaKind getStorageKind() {
        return this.getType().getStorageKind();
    }

    public Field getJavaField() {
        return this.wrapped.getJavaField();
    }
}

