/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.ImageHeapList;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class ImageHeapCollectionFeature
implements InternalFeature {
    private final Set<ImageHeapMap.HostedImageHeapMap<?, ?>> allMaps = ConcurrentHashMap.newKeySet();
    private final Set<ImageHeapList.HostedImageHeapList<?>> allLists = ConcurrentHashMap.newKeySet();

    ImageHeapCollectionFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        config.registerObjectReplacer(this::replaceHostedWithRuntime);
    }

    private Object replaceHostedWithRuntime(Object obj) {
        if (obj instanceof ImageHeapMap.HostedImageHeapMap) {
            ImageHeapMap.HostedImageHeapMap hostedImageHeapMap = (ImageHeapMap.HostedImageHeapMap)((Object)obj);
            if (BuildPhaseProvider.isAnalysisFinished()) {
                VMError.guarantee(this.allMaps.contains((Object)hostedImageHeapMap), "ImageHeapMap reachable after analysis that was not seen during analysis");
            } else {
                this.allMaps.add(hostedImageHeapMap);
            }
            return hostedImageHeapMap.runtimeMap;
        }
        if (obj instanceof ImageHeapList.HostedImageHeapList) {
            ImageHeapList.HostedImageHeapList hostedImageHeapList = (ImageHeapList.HostedImageHeapList)obj;
            if (BuildPhaseProvider.isAnalysisFinished()) {
                VMError.guarantee(this.allLists.contains(hostedImageHeapList), "ImageHeapList reachable after analysis that was not seen during analysis");
            } else {
                this.allLists.add(hostedImageHeapList);
            }
            return hostedImageHeapList.runtimeList;
        }
        return obj;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        for (ImageHeapMap.HostedImageHeapMap<?, ?> hostedImageHeapMap : this.allMaps) {
            if (!ImageHeapCollectionFeature.needsUpdate(hostedImageHeapMap)) continue;
            ImageHeapCollectionFeature.update(hostedImageHeapMap);
            access.rescanObject(hostedImageHeapMap.runtimeMap);
            access.requireAnalysisIteration();
        }
        for (ImageHeapList.HostedImageHeapList hostedImageHeapList : this.allLists) {
            if (!hostedImageHeapList.needsUpdate()) continue;
            hostedImageHeapList.update();
            access.rescanObject(hostedImageHeapList.runtimeList);
            access.requireAnalysisIteration();
        }
    }

    public boolean needsUpdate() {
        for (ImageHeapMap.HostedImageHeapMap<?, ?> hostedImageHeapMap : this.allMaps) {
            if (!ImageHeapCollectionFeature.needsUpdate(hostedImageHeapMap)) continue;
            return true;
        }
        for (ImageHeapList.HostedImageHeapList hostedImageHeapList : this.allLists) {
            if (!hostedImageHeapList.needsUpdate()) continue;
            return true;
        }
        return false;
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        for (ImageHeapMap.HostedImageHeapMap<?, ?> hostedImageHeapMap : this.allMaps) {
            if (!ImageHeapCollectionFeature.needsUpdate(hostedImageHeapMap)) continue;
            throw VMError.shouldNotReachHere("ImageHeapMap modified after static analysis: " + hostedImageHeapMap + System.lineSeparator() + hostedImageHeapMap.runtimeMap);
        }
        for (ImageHeapList.HostedImageHeapList hostedImageHeapList : this.allLists) {
            if (!hostedImageHeapList.needsUpdate()) continue;
            throw VMError.shouldNotReachHere("ImageHeapList modified after static analysis:%n%s%n%s", hostedImageHeapList, hostedImageHeapList.runtimeList);
        }
    }

    private static boolean needsUpdate(ImageHeapMap.HostedImageHeapMap<?, ?> hostedMap) {
        EconomicMap<Object, Object> runtimeMap = hostedMap.runtimeMap;
        if (hostedMap.size() != runtimeMap.size()) {
            return true;
        }
        MapCursor hostedEntry = hostedMap.getEntries();
        while (hostedEntry.advance()) {
            Object runtimeValue;
            Object hostedValue = hostedEntry.getValue();
            if (hostedValue == (runtimeValue = runtimeMap.get(hostedEntry.getKey()))) continue;
            return true;
        }
        return false;
    }

    private static void update(ImageHeapMap.HostedImageHeapMap<?, ?> hostedMap) {
        hostedMap.runtimeMap.clear();
        hostedMap.runtimeMap.putAll(hostedMap);
    }
}

