/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap.dump;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.collections.GrowableWordArray;
import com.oracle.svm.core.collections.GrowableWordArrayAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.dump.HProfSubRecord;
import com.oracle.svm.core.heap.dump.HProfTopLevelRecord;
import com.oracle.svm.core.heap.dump.HProfType;
import com.oracle.svm.core.heap.dump.HeapDumpMetadata;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.BufferedFileOperationSupport;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalMTSupport;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class HeapDumpWriter {
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final int DUMMY_STACK_TRACE_ID = 1;
    private static final int LARGE_OBJECT_THRESHOLD = 0x100000;
    private static final int HEAP_DUMP_SEGMENT_TARGET_SIZE = 0x100000;
    private final NoAllocationVerifier noAllocationVerifier = NoAllocationVerifier.factory("HeapDumpWriter", false);
    private final UninterruptibleUtils.ReplaceDotWithSlash dotWithSlashReplacer = new UninterruptibleUtils.ReplaceDotWithSlash();
    private final DumpStackFrameVisitor dumpStackFrameVisitor = new DumpStackFrameVisitor();
    private final DumpObjectsVisitor dumpObjectsVisitor = new DumpObjectsVisitor();
    private final CodeMetadataVisitor codeMetadataVisitor = new CodeMetadataVisitor();
    private final ThreadLocalsVisitor threadLocalsVisitor = new ThreadLocalsVisitor();
    private final HeapDumpMetadata metadata;
    private BufferedFileOperationSupport.BufferedFile f;
    private long topLevelRecordBegin = -1L;
    private long subRecordBegin = -1L;
    private boolean error;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapDumpWriter(HeapDumpMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean dumpHeap(RawFileOperationSupport.RawFileDescriptor fd) {
        assert (VMOperation.isInProgressAtSafepoint());
        assert (ThreadingSupportImpl.isRecurringCallbackPaused());
        this.noAllocationVerifier.open();
        try {
            Heap.getHeap().suspendAllocation();
            boolean bl = this.dumpHeap0(fd);
            return bl;
        }
        finally {
            this.noAllocationVerifier.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dumpHeap0(RawFileOperationSupport.RawFileDescriptor fd) {
        boolean initialized = this.initialize(fd);
        try {
            if (initialized) {
                boolean bl = this.writeHeapDump();
                return bl;
            }
            Log.log().string("An error occurred while initializing the heap dump infrastructure. No heap data will be dumped.").newline();
            boolean bl = false;
            return bl;
        }
        finally {
            this.teardown();
        }
    }

    private boolean initialize(RawFileOperationSupport.RawFileDescriptor fd) {
        assert (this.topLevelRecordBegin == -1L && this.subRecordBegin == -1L && !this.error);
        this.f = HeapDumpWriter.file().allocate(fd);
        if (this.f.isNull()) {
            return false;
        }
        return this.metadata.initialize();
    }

    private void teardown() {
        this.metadata.teardown();
        assert (this.f.isNull() || this.error || HeapDumpWriter.file().getUnflushedDataSize(this.f) == 0);
        HeapDumpWriter.file().free(this.f);
        this.f = (BufferedFileOperationSupport.BufferedFile)WordFactory.nullPointer();
        this.topLevelRecordBegin = -1L;
        this.subRecordBegin = -1L;
        this.error = false;
    }

    @NeverInline(value="Starting a stack walk in the caller frame.")
    private boolean writeHeapDump() {
        Pointer currentThreadSp = KnownIntrinsics.readCallerStackPointer();
        this.writeHeader();
        this.writeClassNames();
        this.writeFieldNames();
        this.writeLoadedClasses();
        this.writeStackTraces(currentThreadSp);
        this.startTopLevelRecord(HProfTopLevelRecord.HEAP_DUMP_SEGMENT);
        this.writeClasses();
        this.writeThreads(currentThreadSp);
        this.writeJNIGlobals();
        this.writeStickyClasses();
        this.writeObjects();
        this.endTopLevelRecord();
        this.startTopLevelRecord(HProfTopLevelRecord.HEAP_DUMP_END);
        this.endTopLevelRecord();
        this.flush();
        if (this.error) {
            Log.log().string("An error occurred while writing the heap dump data. The data in the heap dump file may be corrupt.").newline();
            return false;
        }
        return true;
    }

    private void writeHeader() {
        this.writeUTF8("JAVA PROFILE 1.0.2");
        this.writeByte((byte)0);
        this.writeInt(HeapDumpWriter.wordSize());
        this.writeLong(System.currentTimeMillis());
    }

    private void startTopLevelRecord(HProfTopLevelRecord tag) {
        assert (this.topLevelRecordBegin == -1L);
        this.writeByte(tag.getValue());
        this.writeInt(0);
        this.writeInt(0);
        this.topLevelRecordBegin = this.getPosition();
    }

    private void endTopLevelRecord() {
        assert (this.topLevelRecordBegin > 0L);
        long currentPosition = this.getPosition();
        this.setPosition(this.topLevelRecordBegin - 4L);
        this.writeInt(NumUtil.safeToUInt((long)(currentPosition - this.topLevelRecordBegin)));
        this.setPosition(currentPosition);
        this.topLevelRecordBegin = -1L;
    }

    private void startSubRecord(HProfSubRecord tag, long size) {
        assert (this.topLevelRecordBegin > 0L) : "must be within a HEAP_DUMP_SEGMENT";
        long heapDumpSegmentSize = this.getPosition() - this.topLevelRecordBegin;
        if (heapDumpSegmentSize > 0L && heapDumpSegmentSize + size > 0x100000L) {
            this.endTopLevelRecord();
            this.startTopLevelRecord(HProfTopLevelRecord.HEAP_DUMP_SEGMENT);
        }
        this.subRecordBegin = this.getPosition();
        this.writeByte(tag.getValue());
    }

    private void endSubRecord(long recordSize) {
        assert (this.subRecordBegin > 0L);
        assert (this.subRecordBegin + recordSize == this.getPosition());
        this.subRecordBegin = -1L;
    }

    private void writeClassNames() {
        for (int i = 0; i < this.metadata.getClassInfoCount(); ++i) {
            HeapDumpMetadata.ClassInfo classInfo = this.metadata.getClassInfo(i);
            if (!HeapDumpMetadata.ClassInfoAccess.isValid(classInfo)) continue;
            this.writeSymbol(classInfo.getHub().getName(), this.dotWithSlashReplacer);
        }
    }

    private void writeSymbol(String value) {
        this.writeSymbol(value, null);
    }

    private void writeSymbol(String value, UninterruptibleUtils.CharReplacer replacer) {
        this.startTopLevelRecord(HProfTopLevelRecord.UTF8);
        this.writeObjectId(value);
        this.writeUTF8(value, replacer);
        this.endTopLevelRecord();
    }

    private void writeSymbol(HeapDumpMetadata.FieldName fieldName) {
        this.startTopLevelRecord(HProfTopLevelRecord.UTF8);
        this.writeFieldNameId(fieldName);
        this.write((Pointer)HeapDumpMetadata.FieldNameAccess.getChars(fieldName), WordFactory.unsigned((int)HeapDumpMetadata.FieldNameAccess.getLength(fieldName)));
        this.endTopLevelRecord();
    }

    private void writeFieldNames() {
        for (int i = 0; i < this.metadata.getFieldNameCount(); ++i) {
            HeapDumpMetadata.FieldName fieldName = this.metadata.getFieldName(i);
            this.writeSymbol(fieldName);
        }
    }

    private void writeLoadedClasses() {
        for (int i = 0; i < this.metadata.getClassInfoCount(); ++i) {
            DynamicHub hub;
            HeapDumpMetadata.ClassInfo classInfo = this.metadata.getClassInfo(i);
            if (!HeapDumpMetadata.ClassInfoAccess.isValid(classInfo) || !(hub = classInfo.getHub()).isLoaded()) continue;
            this.startTopLevelRecord(HProfTopLevelRecord.LOAD_CLASS);
            this.writeInt(classInfo.getSerialNum());
            this.writeClassId(hub);
            this.writeInt(1);
            this.writeObjectId(hub.getName());
            this.endTopLevelRecord();
        }
    }

    private void writeStackTraces(Pointer currentThreadSp) {
        this.writeDummyStackTrace();
        long nextFrameId = 1L;
        int threadSerialNum = 1;
        IsolateThread isolateThread = VMThreads.firstThread();
        while (isolateThread.isNonNull()) {
            int writtenFrames = this.dumpStackData(isolateThread, currentThreadSp, threadSerialNum, nextFrameId, false);
            this.startTopLevelRecord(HProfTopLevelRecord.TRACE);
            int stackSerialNum = threadSerialNum + 1;
            this.writeInt(stackSerialNum);
            this.writeInt(threadSerialNum);
            this.writeInt(writtenFrames);
            for (int i = 0; i < writtenFrames; ++i) {
                this.writeFrameId(nextFrameId++);
            }
            this.endTopLevelRecord();
            ++threadSerialNum;
            isolateThread = VMThreads.nextThread(isolateThread);
        }
    }

    private int dumpStackData(IsolateThread isolateThread, Pointer currentThreadSp, int threadSerialNum, long nextFrameId, boolean markGCRoots) {
        this.dumpStackFrameVisitor.initialize(threadSerialNum, nextFrameId, markGCRoots);
        if (isolateThread == CurrentIsolate.getCurrentThread()) {
            JavaStackWalker.walkCurrentThread(currentThreadSp, this.dumpStackFrameVisitor);
        } else {
            JavaStackWalker.walkThread(isolateThread, this.dumpStackFrameVisitor);
        }
        return this.dumpStackFrameVisitor.getWrittenFrames();
    }

    private void writeDummyStackTrace() {
        this.startTopLevelRecord(HProfTopLevelRecord.TRACE);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(0);
        this.endTopLevelRecord();
    }

    private void writeClasses() {
        for (int i = 0; i < this.metadata.getClassInfoCount(); ++i) {
            HeapDumpMetadata.ClassInfo classInfo = this.metadata.getClassInfo(i);
            if (!HeapDumpMetadata.ClassInfoAccess.isValid(classInfo) || !classInfo.getHub().isLoaded()) continue;
            this.writeClassDumpRecord(classInfo);
        }
    }

    private void writeClassDumpRecord(HeapDumpMetadata.ClassInfo classInfo) {
        int staticFieldsCount = classInfo.getStaticFieldCount();
        int staticFieldsSize = staticFieldsCount * (HeapDumpWriter.wordSize() + 1) + HeapDumpMetadata.computeFieldsDumpSize(classInfo.getStaticFields(), classInfo.getStaticFieldCount());
        int instanceFieldsCount = classInfo.getInstanceFieldCount();
        int instanceFieldsSize = instanceFieldsCount * (HeapDumpWriter.wordSize() + 1);
        int recordSize = 1 + HeapDumpWriter.wordSize() + 4 + 6 * HeapDumpWriter.wordSize() + 4 + 2 + 2 + staticFieldsSize + 2 + instanceFieldsSize;
        Class<?> clazz = DynamicHub.toClass(classInfo.getHub());
        this.startSubRecord(HProfSubRecord.GC_CLASS_DUMP, recordSize);
        this.writeClassId(clazz);
        this.writeInt(1);
        this.writeClassId(clazz.getSuperclass());
        this.writeObjectId(HeapDumpWriter.getClassLoader(clazz));
        this.writeObjectId(null);
        this.writeObjectId(null);
        this.writeObjectId(null);
        this.writeObjectId(null);
        this.writeInt(HeapDumpWriter.getObjectSizeInHeap(clazz));
        this.writeShort((short)0);
        this.writeFieldDescriptors(staticFieldsCount, classInfo.getStaticFields(), true);
        this.writeFieldDescriptors(instanceFieldsCount, classInfo.getInstanceFields(), false);
        this.endSubRecord(recordSize);
    }

    private void writeFieldDescriptors(int fieldCount, HeapDumpMetadata.FieldInfoPointer fieldInfos, boolean isStatic) {
        this.writeShort(NumUtil.safeToUShort((int)fieldCount));
        for (int i = 0; i < fieldCount; ++i) {
            HeapDumpMetadata.FieldInfo field = fieldInfos.addressOf(i).read();
            this.writeFieldNameId(HeapDumpMetadata.FieldInfoAccess.getFieldName(field));
            HProfType type = HeapDumpMetadata.FieldInfoAccess.getType(field);
            this.writeType(type);
            if (!isStatic) continue;
            Object dataHolder = HeapDumpWriter.getStaticFieldDataHolder(type);
            this.writeFieldData(dataHolder, field);
        }
    }

    private static Object getStaticFieldDataHolder(HProfType type) {
        if (type == HProfType.NORMAL_OBJECT) {
            return StaticFieldsSupport.getStaticObjectFields();
        }
        return StaticFieldsSupport.getStaticPrimitiveFields();
    }

    private void writeFieldData(Object dataHolder, HeapDumpMetadata.FieldInfo field) {
        Word p = Word.objectToUntrackedPointer((Object)dataHolder);
        int location = HeapDumpMetadata.FieldInfoAccess.getLocation(field);
        HProfType type = HeapDumpMetadata.FieldInfoAccess.getType(field);
        switch (type) {
            case BOOLEAN: 
            case BYTE: {
                this.writeByte(p.readByte(location));
                break;
            }
            case CHAR: {
                this.writeChar(p.readChar(location));
                break;
            }
            case SHORT: {
                this.writeShort(p.readShort(location));
                break;
            }
            case INT: {
                this.writeInt(p.readInt(location));
                break;
            }
            case LONG: {
                this.writeLong(p.readLong(location));
                break;
            }
            case FLOAT: {
                this.writeFloat(p.readFloat(location));
                break;
            }
            case DOUBLE: {
                this.writeDouble(p.readDouble(location));
                break;
            }
            case NORMAL_OBJECT: {
                this.writeObjectId(ReferenceAccess.singleton().readObjectAt(p.add(location), true));
                break;
            }
            default: {
                throw VMError.shouldNotReachHere("Unexpected type.");
            }
        }
    }

    private void writeThreads(Pointer currentThreadSp) {
        long nextFrameId = 1L;
        int threadSerialNum = 1;
        IsolateThread isolateThread = VMThreads.firstThread();
        while (isolateThread.isNonNull()) {
            int stackTraceSerialNum = threadSerialNum + 1;
            Thread thread = PlatformThreads.fromVMThread(isolateThread);
            this.writeThread(thread, threadSerialNum, stackTraceSerialNum);
            nextFrameId += (long)this.dumpStackData(isolateThread, currentThreadSp, threadSerialNum, nextFrameId, true);
            this.writeThreadLocals(isolateThread, threadSerialNum);
            ++threadSerialNum;
            isolateThread = VMThreads.nextThread(isolateThread);
        }
    }

    private void writeThread(Thread threadObj, int threadSerialNum, int stackTraceSerialNum) {
        int recordSize = 1 + HeapDumpWriter.wordSize() + 4 + 4;
        this.startSubRecord(HProfSubRecord.GC_ROOT_THREAD_OBJ, recordSize);
        this.writeObjectId(threadObj);
        this.writeInt(threadSerialNum);
        this.writeInt(stackTraceSerialNum);
        this.endSubRecord(recordSize);
    }

    private void writeThreadLocals(IsolateThread isolateThread, int threadSerialNum) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            this.threadLocalsVisitor.initialize(threadSerialNum);
            VMThreadLocalMTSupport.singleton().walk(isolateThread, this.threadLocalsVisitor);
        }
    }

    private void writeJNIGlobals() {
        RuntimeCodeInfoMemory.singleton().walkRuntimeMethods(this.codeMetadataVisitor);
    }

    private void writeStickyClasses() {
        for (int i = 0; i < this.metadata.getClassInfoCount(); ++i) {
            HeapDumpMetadata.ClassInfo classInfo = this.metadata.getClassInfo(i);
            if (!HeapDumpMetadata.ClassInfoAccess.isValid(classInfo)) continue;
            int recordSize = 1 + HeapDumpWriter.wordSize();
            this.startSubRecord(HProfSubRecord.GC_ROOT_STICKY_CLASS, recordSize);
            this.writeClassId(classInfo.getHub());
            this.endSubRecord(recordSize);
        }
    }

    private void writeObjects() {
        GrowableWordArray largeObjects = (GrowableWordArray)StackValue.get(GrowableWordArray.class);
        GrowableWordArrayAccess.initialize(largeObjects);
        try {
            this.dumpObjectsVisitor.initialize(largeObjects);
            Heap.getHeap().walkImageHeapObjects(this.dumpObjectsVisitor);
            this.dumpObjectsVisitor.initialize(largeObjects);
            Heap.getHeap().walkCollectedHeapObjects(this.dumpObjectsVisitor);
            this.writeLargeObjects(largeObjects);
        }
        finally {
            GrowableWordArrayAccess.freeData(largeObjects);
            largeObjects = (GrowableWordArray)WordFactory.nullPointer();
        }
    }

    private void writeLargeObjects(GrowableWordArray largeObjects) {
        int count = largeObjects.getSize();
        for (int i = 0; i < count; ++i) {
            Word rawObj = GrowableWordArrayAccess.get(largeObjects, i);
            this.writeObject(rawObj.toObject());
        }
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        Class<?> c = clazz;
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c.getClassLoader();
    }

    private static int getObjectSizeInHeap(Class<?> cls) {
        DynamicHub hub = DynamicHub.fromClass(cls);
        int encoding = hub.getLayoutEncoding();
        if (LayoutEncoding.isPureInstance(encoding)) {
            return (int)LayoutEncoding.getPureInstanceAllocationSize(encoding).rawValue();
        }
        if (LayoutEncoding.isHybrid(encoding)) {
            return LayoutEncoding.getArrayBaseOffsetAsInt(encoding);
        }
        return 0;
    }

    private void writeObject(Object obj) {
        Object monitor;
        int monitorOffset;
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        int layoutEncoding = hub.getLayoutEncoding();
        if (LayoutEncoding.isArray(layoutEncoding)) {
            if (LayoutEncoding.isPrimitiveArray(layoutEncoding)) {
                this.writePrimitiveArray(obj, layoutEncoding);
            } else {
                this.writeObjectArray(obj);
            }
        } else {
            this.writeInstance(obj);
        }
        if (Heap.getHeap().isInImageHeap(obj)) {
            this.markImageHeapObjectAsGCRoot(obj);
        }
        if ((monitorOffset = hub.getMonitorOffset()) != 0 && (monitor = ObjectAccess.readObject((Object)obj, (int)monitorOffset)) != null) {
            this.markMonitorAsGCRoot(monitor);
        }
    }

    private void markMonitorAsGCRoot(Object monitor) {
        int recordSize = 1 + HeapDumpWriter.wordSize();
        this.startSubRecord(HProfSubRecord.GC_ROOT_MONITOR_USED, recordSize);
        this.writeObjectId(monitor);
        this.endSubRecord(recordSize);
    }

    private void markImageHeapObjectAsGCRoot(Object obj) {
        assert (Heap.getHeap().isInImageHeap(obj));
        this.markAsJniGlobalGCRoot(obj);
    }

    private void markAsJniGlobalGCRoot(Object obj) {
        int recordSize = 1 + 2 * HeapDumpWriter.wordSize();
        this.startSubRecord(HProfSubRecord.GC_ROOT_JNI_GLOBAL, recordSize);
        this.writeObjectId(obj);
        this.writeObjectId(null);
        this.endSubRecord(recordSize);
    }

    private void writeInstance(Object obj) {
        HeapDumpMetadata.ClassInfo classInfo = this.metadata.getClassInfo(obj.getClass());
        int instanceFieldsSize = classInfo.getInstanceFieldsDumpSize();
        int recordSize = 1 + HeapDumpWriter.wordSize() + 4 + HeapDumpWriter.wordSize() + 4 + instanceFieldsSize;
        this.startSubRecord(HProfSubRecord.GC_INSTANCE_DUMP, recordSize);
        this.writeObjectId(obj);
        this.writeInt(1);
        this.writeClassId(obj.getClass());
        this.writeInt(instanceFieldsSize);
        do {
            int instanceFieldCount = classInfo.getInstanceFieldCount();
            HeapDumpMetadata.FieldInfoPointer instanceFields = classInfo.getInstanceFields();
            for (int i = 0; i < instanceFieldCount; ++i) {
                HeapDumpMetadata.FieldInfo field = instanceFields.addressOf(i).read();
                this.writeFieldData(obj, field);
            }
        } while ((classInfo = this.metadata.getClassInfo(classInfo.getHub().getSuperHub())).isNonNull());
        this.endSubRecord(recordSize);
    }

    private void writePrimitiveArray(Object array, int layoutEncoding) {
        int arrayBaseOffset = LayoutEncoding.getArrayBaseOffsetAsInt(layoutEncoding);
        int elementSize = LayoutEncoding.getArrayIndexScale(layoutEncoding);
        int recordHeaderSize = 1 + HeapDumpWriter.wordSize() + 8 + 1;
        int length = HeapDumpWriter.calculateMaxArrayLength(array, elementSize, recordHeaderSize);
        long recordSize = (long)recordHeaderSize + (long)length * (long)elementSize;
        this.startSubRecord(HProfSubRecord.GC_PRIM_ARRAY_DUMP, recordSize);
        this.writeObjectId(array);
        this.writeInt(1);
        this.writeInt(length);
        if (array instanceof boolean[]) {
            this.writeType(HProfType.BOOLEAN);
            this.writeU1ArrayData(array, length, arrayBaseOffset);
        } else if (array instanceof byte[]) {
            this.writeType(HProfType.BYTE);
            this.writeU1ArrayData(array, length, arrayBaseOffset);
        } else if (array instanceof short[]) {
            this.writeType(HProfType.SHORT);
            this.writeU2ArrayData(array, length, arrayBaseOffset);
        } else if (array instanceof char[]) {
            this.writeType(HProfType.CHAR);
            this.writeU2ArrayData(array, length, arrayBaseOffset);
        } else if (array instanceof int[]) {
            this.writeType(HProfType.INT);
            this.writeU4ArrayData(array, length, arrayBaseOffset);
        } else if (array instanceof float[]) {
            this.writeType(HProfType.FLOAT);
            this.writeU4ArrayData(array, length, arrayBaseOffset);
        } else if (array instanceof long[]) {
            this.writeType(HProfType.LONG);
            this.writeU8ArrayData(array, length, arrayBaseOffset);
        } else if (array instanceof double[]) {
            this.writeType(HProfType.DOUBLE);
            this.writeU8ArrayData(array, length, arrayBaseOffset);
        } else {
            assert (WordBase.class.isAssignableFrom(array.getClass().getComponentType()));
            assert (elementSize == HeapDumpWriter.wordSize());
            this.writeWordArray(array, length, arrayBaseOffset);
        }
        this.endSubRecord(recordSize);
    }

    private void writeObjectArray(Object array) {
        int recordHeaderSize = 9 + 2 * HeapDumpWriter.wordSize();
        int length = HeapDumpWriter.calculateMaxArrayLength(array, HeapDumpWriter.wordSize(), recordHeaderSize);
        long recordSize = (long)recordHeaderSize + (long)length * (long)HeapDumpWriter.wordSize();
        this.startSubRecord(HProfSubRecord.GC_OBJ_ARRAY_DUMP, recordSize);
        this.writeObjectId(array);
        this.writeInt(1);
        this.writeInt(length);
        this.writeClassId(array.getClass());
        Object[] data = (Object[])array;
        for (int i = 0; i < length; ++i) {
            this.writeObjectId(data[i]);
        }
        this.endSubRecord(recordSize);
    }

    private static int calculateMaxArrayLength(Object array, int elementSize, int recordHeaderSize) {
        UnsignedWord maxBytes;
        int length = ArrayLengthNode.arrayLength((Object)array);
        UnsignedWord lengthInBytes = WordFactory.unsigned((int)length).multiply(elementSize);
        if (lengthInBytes.belowOrEqual(maxBytes = WordFactory.unsigned((long)0xFFFFFFFFL).subtract(recordHeaderSize))) {
            return length;
        }
        UnsignedWord newLength = maxBytes.unsignedDivide(elementSize);
        Log.log().string("Cannot dump very large arrays. Array is truncated to ").unsigned((WordBase)newLength).string(" elements.").newline();
        return NumUtil.safeToInt((long)newLength.rawValue());
    }

    private void writeWordArray(Object array, int length, int arrayBaseOffset) {
        if (HeapDumpWriter.wordSize() == 8) {
            this.writeType(HProfType.LONG);
            this.writeU8ArrayData(array, length, arrayBaseOffset);
        } else {
            assert (HeapDumpWriter.wordSize() == 4);
            this.writeType(HProfType.INT);
            this.writeU4ArrayData(array, length, arrayBaseOffset);
        }
    }

    private void writeU1ArrayData(Object array, int length, int arrayBaseOffset) {
        Pointer data = HeapDumpWriter.getArrayData(array, arrayBaseOffset);
        this.write(data, WordFactory.unsigned((int)length));
    }

    private void writeU2ArrayData(Object array, int length, int arrayBaseOffset) {
        Pointer cur = HeapDumpWriter.getArrayData(array, arrayBaseOffset);
        for (int i = 0; i < length; ++i) {
            this.writeChar(cur.readChar(0));
            cur = cur.add(2);
        }
    }

    private void writeU4ArrayData(Object array, int length, int arrayBaseOffset) {
        Pointer cur = HeapDumpWriter.getArrayData(array, arrayBaseOffset);
        for (int i = 0; i < length; ++i) {
            this.writeInt(cur.readInt(0));
            cur = cur.add(4);
        }
    }

    private void writeU8ArrayData(Object array, int length, int arrayBaseOffset) {
        Pointer cur = HeapDumpWriter.getArrayData(array, arrayBaseOffset);
        for (int i = 0; i < length; ++i) {
            this.writeLong(cur.readLong(0));
            cur = cur.add(8);
        }
    }

    private static Pointer getArrayData(Object array, int arrayBaseOffset) {
        return Word.objectToUntrackedPointer((Object)array).add(arrayBaseOffset);
    }

    private void writeByte(byte value) {
        boolean success = HeapDumpWriter.file().writeByte(this.f, value);
        this.handleError(success);
    }

    private void writeShort(short value) {
        boolean success = HeapDumpWriter.file().writeShort(this.f, value);
        this.handleError(success);
    }

    private void writeChar(char value) {
        boolean success = HeapDumpWriter.file().writeChar(this.f, value);
        this.handleError(success);
    }

    private void writeInt(int value) {
        boolean success = HeapDumpWriter.file().writeInt(this.f, value);
        this.handleError(success);
    }

    private void writeLong(long value) {
        boolean success = HeapDumpWriter.file().writeLong(this.f, value);
        this.handleError(success);
    }

    private void writeFloat(float value) {
        boolean success = HeapDumpWriter.file().writeFloat(this.f, value);
        this.handleError(success);
    }

    private void writeDouble(double value) {
        boolean success = HeapDumpWriter.file().writeDouble(this.f, value);
        this.handleError(success);
    }

    private void writeType(HProfType type) {
        this.writeByte(type.getValue());
    }

    private void writeObjectId(Object obj) {
        this.writeId0(Word.objectToUntrackedPointer((Object)obj).rawValue());
    }

    private void writeClassId(Class<?> clazz) {
        this.writeClassId(DynamicHub.fromClass(clazz));
    }

    private void writeClassId(DynamicHub hub) {
        Word hubAddress = Word.objectToUntrackedPointer((Object)hub);
        if (hubAddress.isNonNull()) {
            hubAddress = hubAddress.add(1);
        }
        this.writeId0(hubAddress.rawValue());
    }

    private void writeFieldNameId(HeapDumpMetadata.FieldName fieldName) {
        this.writeId0(fieldName.rawValue());
    }

    private void writeFrameId(long frameId) {
        this.writeId0(frameId);
    }

    private void writeId0(long value) {
        boolean success;
        if (HeapDumpWriter.wordSize() == 8) {
            success = HeapDumpWriter.file().writeLong(this.f, value);
        } else {
            assert (HeapDumpWriter.wordSize() == 4);
            success = HeapDumpWriter.file().writeInt(this.f, (int)value);
        }
        this.handleError(success);
    }

    private void writeUTF8(String value) {
        this.writeUTF8(value, null);
    }

    private void writeUTF8(String value, UninterruptibleUtils.CharReplacer replacer) {
        boolean success = HeapDumpWriter.file().writeUTF8(this.f, value, replacer);
        this.handleError(success);
    }

    private void write(Pointer data, UnsignedWord size) {
        boolean success = HeapDumpWriter.file().write(this.f, data, size);
        this.handleError(success);
    }

    private long getPosition() {
        long result = HeapDumpWriter.file().position(this.f);
        this.handleError(result >= 0L);
        return result;
    }

    private void setPosition(long newPos) {
        boolean success = HeapDumpWriter.file().seek(this.f, newPos);
        this.handleError(success);
    }

    private void flush() {
        boolean success = HeapDumpWriter.file().flush(this.f);
        this.handleError(success);
    }

    private void handleError(boolean success) {
        if (!success) {
            this.error = true;
        }
    }

    @Fold
    static BufferedFileOperationSupport file() {
        return BufferedFileOperationSupport.bigEndian();
    }

    @Fold
    static int wordSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    private class DumpStackFrameVisitor
    extends StackFrameVisitor
    implements ObjectReferenceVisitor {
        private static final int LINE_NUM_NATIVE_METHOD = -3;
        private final CodeInfoDecoder.FrameInfoCursor frameInfoCursor = new CodeInfoDecoder.FrameInfoCursor();
        private int threadSerialNum;
        private long initialNextFrameId;
        private long nextFrameId;
        private boolean markGCRoots;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        DumpStackFrameVisitor() {
        }

        public void initialize(int threadSerialNum, long nextFrameId, boolean markGCRoots) {
            assert (nextFrameId > 0L);
            assert (threadSerialNum > 0);
            assert (nextFrameId > 0L);
            this.threadSerialNum = threadSerialNum;
            this.initialNextFrameId = nextFrameId;
            this.nextFrameId = nextFrameId;
            this.markGCRoots = markGCRoots;
        }

        public int getWrittenFrames() {
            return NumUtil.safeToInt((long)(this.nextFrameId - this.initialNextFrameId));
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Heap dumping must not allocate.")
        protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            if (deoptimizedFrame != null) {
                this.markAsGCRoot(deoptimizedFrame);
                for (DeoptimizedFrame.VirtualFrame frame = deoptimizedFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                    this.visitFrame(frame.getFrameInfo());
                    ++this.nextFrameId;
                }
            } else {
                this.markStackValuesAsGCRoots(sp, ip, codeInfo);
                this.frameInfoCursor.initialize(codeInfo, ip);
                while (this.frameInfoCursor.advance()) {
                    FrameInfoQueryResult frame = this.frameInfoCursor.get();
                    this.visitFrame(frame);
                    ++this.nextFrameId;
                }
            }
            return true;
        }

        private void markAsGCRoot(DeoptimizedFrame frame) {
            if (this.markGCRoots) {
                HeapDumpWriter.this.markAsJniGlobalGCRoot(frame);
            }
        }

        private void markStackValuesAsGCRoots(Pointer sp, CodePointer ip, CodeInfo codeInfo) {
            if (this.markGCRoots) {
                SimpleCodeInfoQueryResult queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
                CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
                NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
                long referenceMapIndex = queryResult.getReferenceMapIndex();
                if (referenceMapIndex == -1L) {
                    throw CodeInfoTable.reportNoReferenceMap(sp, ip, codeInfo);
                }
                CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, this, null);
            }
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Heap dumping must not allocate.")
        public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
            assert (this.markGCRoots);
            Object obj = ReferenceAccess.singleton().readObjectAt(objRef, compressed);
            if (obj != null) {
                int recordSize = 1 + HeapDumpWriter.wordSize() + 4 + 4;
                HeapDumpWriter.this.startSubRecord(HProfSubRecord.GC_ROOT_JAVA_FRAME, recordSize);
                HeapDumpWriter.this.writeObjectId(obj);
                HeapDumpWriter.this.writeInt(this.threadSerialNum);
                HeapDumpWriter.this.writeInt(this.getWrittenFrames());
            }
            return true;
        }

        private void visitFrame(FrameInfoQueryResult frame) {
            if (!this.markGCRoots) {
                String methodName = DumpStackFrameVisitor.getSourceMethodName(frame);
                String methodSignature = "";
                String sourceFileName = DumpStackFrameVisitor.getSourceFileName(frame);
                HeapDumpWriter.this.writeSymbol(methodName);
                HeapDumpWriter.this.writeSymbol(methodSignature);
                HeapDumpWriter.this.writeSymbol(sourceFileName);
                Class<?> sourceClass = DumpStackFrameVisitor.getSourceClass(frame);
                HeapDumpMetadata.ClassInfo classInfo = HeapDumpWriter.this.metadata.getClassInfo(sourceClass);
                int lineNumber = DumpStackFrameVisitor.getLineNumber(frame);
                this.writeFrame(classInfo.getSerialNum(), lineNumber, methodName, methodSignature, sourceFileName);
            }
        }

        private void writeFrame(int classSerialNum, int lineNumber, String methodName, String methodSignature, String sourceFileName) {
            assert (!this.markGCRoots);
            HeapDumpWriter.this.startTopLevelRecord(HProfTopLevelRecord.FRAME);
            HeapDumpWriter.this.writeFrameId(this.nextFrameId);
            HeapDumpWriter.this.writeObjectId(methodName);
            HeapDumpWriter.this.writeObjectId(methodSignature);
            HeapDumpWriter.this.writeObjectId(sourceFileName);
            HeapDumpWriter.this.writeInt(classSerialNum);
            HeapDumpWriter.this.writeInt(lineNumber);
            HeapDumpWriter.this.endTopLevelRecord();
        }

        private static String getSourceMethodName(FrameInfoQueryResult frame) {
            String result = frame.getSourceMethodName();
            if (result == null || result.isEmpty()) {
                return "unknownMethod";
            }
            return result;
        }

        private static String getSourceFileName(FrameInfoQueryResult frame) {
            String result = frame.getSourceFileName();
            if (result == null || result.isEmpty()) {
                return "unknown file";
            }
            return result;
        }

        private static Class<?> getSourceClass(FrameInfoQueryResult frame) {
            Class<?> result = frame.getSourceClass();
            if (result == null) {
                return UnknownClass.class;
            }
            return result;
        }

        private static int getLineNumber(FrameInfoQueryResult frame) {
            if (frame.isNativeMethod()) {
                return -3;
            }
            return frame.getSourceLineNumber();
        }
    }

    private class DumpObjectsVisitor
    implements ObjectVisitor {
        private GrowableWordArray largeObjects;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        DumpObjectsVisitor() {
        }

        public void initialize(GrowableWordArray largeObjects) {
            this.largeObjects = largeObjects;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Heap dumping must not allocate.")
        public boolean visitObject(Object obj) {
            if (this.isLarge(obj)) {
                boolean added = GrowableWordArrayAccess.add(this.largeObjects, Word.objectToUntrackedPointer((Object)obj));
                if (!added) {
                    Log.log().string("Failed to add an element to the large object list. Heap dump will be incomplete.").newline();
                }
            } else {
                HeapDumpWriter.this.writeObject(obj);
            }
            return true;
        }

        private boolean isLarge(Object obj) {
            return this.getObjectSize(obj).aboveThan(0x100000);
        }

        private UnsignedWord getObjectSize(Object obj) {
            int layoutEncoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
            if (LayoutEncoding.isArray(layoutEncoding)) {
                int elementSize = LayoutEncoding.isPrimitiveArray(layoutEncoding) ? LayoutEncoding.getArrayIndexScale(layoutEncoding) : HeapDumpWriter.wordSize();
                int length = ArrayLengthNode.arrayLength((Object)obj);
                return WordFactory.unsigned((int)length).multiply(elementSize);
            }
            HeapDumpMetadata.ClassInfo classInfo = HeapDumpWriter.this.metadata.getClassInfo(obj.getClass());
            return WordFactory.unsigned((int)classInfo.getInstanceFieldsDumpSize());
        }
    }

    private class CodeMetadataVisitor
    implements RuntimeCodeCache.CodeInfoVisitor,
    ObjectReferenceVisitor {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        CodeMetadataVisitor() {
        }

        @Override
        public boolean visitCode(CodeInfo info) {
            RuntimeCodeInfoAccess.walkObjectFields(info, this);
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Heap dumping must not allocate.")
        public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
            Object obj = ReferenceAccess.singleton().readObjectAt(objRef, compressed);
            if (obj != null) {
                HeapDumpWriter.this.markAsJniGlobalGCRoot(obj);
            }
            return true;
        }
    }

    private class ThreadLocalsVisitor
    implements ObjectReferenceVisitor {
        private int threadSerialNum;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ThreadLocalsVisitor() {
        }

        public void initialize(int threadSerialNum) {
            this.threadSerialNum = threadSerialNum;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Heap dumping must not allocate.")
        public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
            Object obj = ReferenceAccess.singleton().readObjectAt(objRef, compressed);
            if (obj != null) {
                this.markThreadLocalAsGCRoot(obj);
            }
            return true;
        }

        private void markThreadLocalAsGCRoot(Object obj) {
            int recordSize = 1 + HeapDumpWriter.wordSize() + 4 + 4;
            HeapDumpWriter.this.startSubRecord(HProfSubRecord.GC_ROOT_JNI_LOCAL, recordSize);
            HeapDumpWriter.this.writeObjectId(obj);
            HeapDumpWriter.this.writeInt(this.threadSerialNum);
            HeapDumpWriter.this.writeInt(-1);
            HeapDumpWriter.this.endSubRecord(recordSize);
        }
    }

    private static class UnknownClass {
        private UnknownClass() {
        }
    }
}

