/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import com.oracle.svm.core.containers.CgroupInfo;
import com.oracle.svm.core.containers.CgroupMetrics;
import com.oracle.svm.core.containers.CgroupSubsystem;
import com.oracle.svm.core.containers.CgroupUtil;
import com.oracle.svm.core.containers.CgroupV1MetricsImpl;
import com.oracle.svm.core.containers.cgroupv1.CgroupV1Subsystem;
import com.oracle.svm.core.containers.cgroupv2.CgroupV2Subsystem;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class CgroupSubsystemFactory {
    private static final String CPU_CTRL = "cpu";
    private static final String CPUACCT_CTRL = "cpuacct";
    private static final String CPUSET_CTRL = "cpuset";
    private static final String BLKIO_CTRL = "blkio";
    private static final String MEMORY_CTRL = "memory";
    private static final String PIDS_CTRL = "pids";

    static CgroupMetrics create() {
        Optional<CgroupTypeResult> optResult = null;
        try {
            optResult = CgroupSubsystemFactory.determineType("/proc/self/mountinfo", "/proc/cgroups", "/proc/self/cgroup");
        }
        catch (IOException e) {
            return null;
        }
        return CgroupSubsystemFactory.create(optResult);
    }

    public static CgroupMetrics create(Optional<CgroupTypeResult> optResult) {
        if (optResult.isEmpty()) {
            return null;
        }
        CgroupTypeResult result = optResult.get();
        if (!result.isAnyControllersEnabled()) {
            return null;
        }
        if (result.isAnyCgroupV1Controllers() && result.isAnyCgroupV2Controllers()) {
            return null;
        }
        Map<String, CgroupInfo> infos = result.getInfos();
        if (result.isCgroupV2()) {
            CgroupInfo anyController = infos.values().iterator().next();
            CgroupSubsystem subsystem = CgroupV2Subsystem.getInstance(Objects.requireNonNull(anyController));
            return new CgroupMetrics(subsystem);
        }
        CgroupV1Subsystem subsystem = CgroupV1Subsystem.getInstance(infos);
        return subsystem != null ? new CgroupV1MetricsImpl(subsystem) : null;
    }

    public static Optional<CgroupTypeResult> determineType(String mountInfo, String cgroups, String selfCgroup) throws IOException {
        HashMap<String, CgroupInfo> infos = new HashMap<String, CgroupInfo>();
        List<String> lines = CgroupUtil.readAllLinesPrivileged(Paths.get(cgroups, new String[0]));
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            CgroupInfo info = CgroupInfo.fromCgroupsLine(line);
            switch (info.getName()) {
                case "cpu": {
                    infos.put(CPU_CTRL, info);
                    break;
                }
                case "cpuacct": {
                    infos.put(CPUACCT_CTRL, info);
                    break;
                }
                case "cpuset": {
                    infos.put(CPUSET_CTRL, info);
                    break;
                }
                case "memory": {
                    infos.put(MEMORY_CTRL, info);
                    break;
                }
                case "blkio": {
                    infos.put(BLKIO_CTRL, info);
                    break;
                }
                case "pids": {
                    infos.put(PIDS_CTRL, info);
                }
            }
        }
        boolean isCgroupsV2 = true;
        boolean anyControllersEnabled = false;
        boolean anyCgroupsV2Controller = false;
        boolean anyCgroupsV1Controller = false;
        for (Object info : infos.values()) {
            anyCgroupsV1Controller = anyCgroupsV1Controller || ((CgroupInfo)info).getHierarchyId() != 0;
            anyCgroupsV2Controller = anyCgroupsV2Controller || ((CgroupInfo)info).getHierarchyId() == 0;
            isCgroupsV2 = isCgroupsV2 && ((CgroupInfo)info).getHierarchyId() == 0;
            anyControllersEnabled = anyControllersEnabled || ((CgroupInfo)info).isEnabled();
        }
        lines = CgroupUtil.readAllLinesPrivileged(Paths.get(mountInfo, new String[0]));
        boolean anyCgroupMounted = false;
        for (String string : lines) {
            boolean cgroupsControllerFound = CgroupSubsystemFactory.amendCgroupInfos(string, infos, isCgroupsV2);
            anyCgroupMounted = anyCgroupMounted || cgroupsControllerFound;
        }
        if (!anyCgroupMounted) {
            return Optional.empty();
        }
        Consumer<String[]> action = tokens -> CgroupSubsystemFactory.setCgroupV1Path(infos, tokens);
        if (isCgroupsV2) {
            action = tokens -> CgroupSubsystemFactory.setCgroupV2Path(infos, tokens);
        }
        for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get(selfCgroup, new String[0]))) {
            action.accept(line.split(":", 3));
        }
        CgroupTypeResult cgroupTypeResult = new CgroupTypeResult(isCgroupsV2, anyControllersEnabled, anyCgroupsV2Controller, anyCgroupsV1Controller, Collections.unmodifiableMap(infos));
        return Optional.of(cgroupTypeResult);
    }

    private static void setCgroupV2Path(Map<String, CgroupInfo> infos, String[] tokens) {
        String name = tokens[1];
        if (!name.equals("")) {
            assert (infos.get(name) == null);
            return;
        }
        int hierarchyId = Integer.parseInt(tokens[0]);
        String cgroupPath = tokens[2];
        for (CgroupInfo info : infos.values()) {
            assert (hierarchyId == info.getHierarchyId() && hierarchyId == 0);
            info.setCgroupPath(cgroupPath);
        }
    }

    private static void setCgroupV1Path(Map<String, CgroupInfo> infos, String[] tokens) {
        String controllerName = tokens[1];
        String cgroupPath = tokens[2];
        if (controllerName != null && cgroupPath != null) {
            String[] stringArray = controllerName.split(",");
            int n = stringArray.length;
            block11: for (int i = 0; i < n; ++i) {
                String cName;
                switch (cName = stringArray[i]) {
                    case "memory": 
                    case "cpuset": 
                    case "cpuacct": 
                    case "cpu": 
                    case "blkio": 
                    case "pids": {
                        CgroupInfo info = infos.get(cName);
                        info.setCgroupPath(cgroupPath);
                        continue block11;
                    }
                }
            }
        }
    }

    private static boolean amendCgroupInfos(String mntInfoLine, Map<String, CgroupInfo> infos, boolean isCgroupsV2) {
        MountInfo mountInfo = MountInfo.parse(mntInfoLine);
        boolean cgroupv1ControllerFound = false;
        boolean cgroupv2ControllerFound = false;
        if (mountInfo != null) {
            String mountRoot = mountInfo.mountRoot;
            String mountPath = mountInfo.mountPath;
            String fsType = mountInfo.fsType;
            if (fsType.equals("cgroup")) {
                String[] controllerNames;
                Path p = Paths.get(mountPath, new String[0]);
                String[] stringArray = controllerNames = p.getFileName().toString().split(",");
                int n = stringArray.length;
                block11: for (int i = 0; i < n; ++i) {
                    String controllerName;
                    switch (controllerName = stringArray[i]) {
                        case "memory": 
                        case "cpu": 
                        case "cpuacct": 
                        case "cpuset": 
                        case "pids": 
                        case "blkio": {
                            CgroupInfo info = infos.get(controllerName);
                            CgroupSubsystemFactory.setMountPoints(info, mountPath, mountRoot);
                            cgroupv1ControllerFound = true;
                            continue block11;
                        }
                    }
                }
            } else if (fsType.equals("cgroup2")) {
                if (isCgroupsV2) {
                    for (CgroupInfo info : infos.values()) {
                        CgroupSubsystemFactory.setMountPoints(info, mountPath, mountRoot);
                    }
                }
                cgroupv2ControllerFound = true;
            }
        }
        return cgroupv1ControllerFound || cgroupv2ControllerFound;
    }

    private static void setMountPoints(CgroupInfo info, String mountPath, String mountRoot) {
        if (info.getMountPoint() != null) {
            if (!info.getMountPoint().startsWith("/sys/fs/cgroup")) {
                info.setMountPoint(mountPath);
                info.setMountRoot(mountRoot);
            }
        } else {
            info.setMountPoint(mountPath);
            info.setMountRoot(mountRoot);
        }
    }

    public static final class CgroupTypeResult {
        private final boolean isCgroupV2;
        private final boolean anyControllersEnabled;
        private final boolean anyCgroupV2Controllers;
        private final boolean anyCgroupV1Controllers;
        private final Map<String, CgroupInfo> infos;

        private CgroupTypeResult(boolean isCgroupV2, boolean anyControllersEnabled, boolean anyCgroupV2Controllers, boolean anyCgroupV1Controllers, Map<String, CgroupInfo> infos) {
            this.isCgroupV2 = isCgroupV2;
            this.anyControllersEnabled = anyControllersEnabled;
            this.anyCgroupV1Controllers = anyCgroupV1Controllers;
            this.anyCgroupV2Controllers = anyCgroupV2Controllers;
            this.infos = infos;
        }

        public boolean isCgroupV2() {
            return this.isCgroupV2;
        }

        public boolean isAnyControllersEnabled() {
            return this.anyControllersEnabled;
        }

        public boolean isAnyCgroupV2Controllers() {
            return this.anyCgroupV2Controllers;
        }

        public boolean isAnyCgroupV1Controllers() {
            return this.anyCgroupV1Controllers;
        }

        public Map<String, CgroupInfo> getInfos() {
            return this.infos;
        }
    }

    private static final class MountInfo {
        final String mountRoot;
        final String mountPath;
        final String fsType;

        private MountInfo(String mountRoot, String mountPath, String fsType) {
            this.mountRoot = mountRoot;
            this.mountPath = mountPath;
            this.fsType = fsType;
        }

        static MountInfo parse(String line) {
            String mountRoot = null;
            String mountPath = null;
            int separatorOrdinal = -1;
            int tOrdinal = 1;
            int tStart = 0;
            int tEnd = line.indexOf(32);
            while (tEnd != -1 && tStart != tEnd) {
                switch (tOrdinal) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 4: {
                        mountRoot = line.substring(tStart, tEnd);
                        break;
                    }
                    case 5: {
                        mountPath = line.substring(tStart, tEnd);
                        break;
                    }
                    default: {
                        assert (tOrdinal >= 7);
                        if (separatorOrdinal == -1) {
                            if (tEnd - tStart != 1 || line.charAt(tStart) != '-') break;
                            separatorOrdinal = tOrdinal;
                            break;
                        }
                        if (tOrdinal != separatorOrdinal + 1) break;
                        String fsType = line.substring(tStart, tEnd);
                        return new MountInfo(mountRoot, mountPath, fsType);
                    }
                }
                ++tOrdinal;
                tStart = tEnd + 1;
                tEnd = line.indexOf(32, tStart);
            }
            return null;
        }
    }
}

