/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointBuiltins;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.code.IsolateEnterStub;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.replacements.SubstrateGraphKit;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Iterator;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeadEndNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public final class CEntryPointCallStubMethod
extends EntryPointCallStubMethod {
    private static final JavaKind cEnumParameterKind = JavaKind.Int;
    private final CEntryPointData entryPointData;
    private final ResolvedJavaMethod targetMethod;

    static CEntryPointCallStubMethod create(AnalysisMethod targetMethod, CEntryPointData entryPointData, AnalysisMetaAccess metaAccess) {
        ResolvedJavaMethod unwrappedMethod = targetMethod.getWrapped();
        MetaAccessProvider unwrappedMetaAccess = metaAccess.getWrapped();
        ResolvedJavaType declaringClass = unwrappedMetaAccess.lookupJavaType(IsolateEnterStub.class);
        ConstantPool constantPool = IsolateEnterStub.getConstantPool(unwrappedMetaAccess);
        return new CEntryPointCallStubMethod(entryPointData, unwrappedMethod, declaringClass, constantPool);
    }

    private CEntryPointCallStubMethod(CEntryPointData entryPointData, ResolvedJavaMethod targetMethod, ResolvedJavaType holderClass, ConstantPool holderConstantPool) {
        super(SubstrateUtil.uniqueStubName(targetMethod), holderClass, targetMethod.getSignature(), holderConstantPool);
        this.entryPointData = entryPointData;
        this.targetMethod = targetMethod;
    }

    @Override
    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.targetMethod.getParameters();
    }

    private static ResolvedJavaMethod lookupMethodInUniverse(UniverseMetaAccess metaAccess, ResolvedJavaMethod method) {
        ResolvedJavaMethod universeMethod = method;
        MetaAccessProvider wrappedMetaAccess = metaAccess.getWrapped();
        if (wrappedMetaAccess instanceof UniverseMetaAccess) {
            universeMethod = CEntryPointCallStubMethod.lookupMethodInUniverse((UniverseMetaAccess)wrappedMetaAccess, universeMethod);
        }
        return metaAccess.getUniverse().lookup((JavaMethod)universeMethod);
    }

    AnalysisMethod lookupTargetMethod(AnalysisMetaAccess metaAccess) {
        return (AnalysisMethod)CEntryPointCallStubMethod.lookupMethodInUniverse((UniverseMetaAccess)metaAccess, this.targetMethod);
    }

    private ResolvedJavaMethod unwrapMethodAndLookupInUniverse(UniverseMetaAccess metaAccess) {
        ResolvedJavaMethod unwrappedTargetMethod = this.targetMethod;
        while (unwrappedTargetMethod instanceof WrappedJavaMethod) {
            unwrappedTargetMethod = ((WrappedJavaMethod)unwrappedTargetMethod).getWrapped();
        }
        return CEntryPointCallStubMethod.lookupMethodInUniverse(metaAccess, unwrappedTargetMethod);
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.entryPointData.getBuiltin() != CEntryPointData.DEFAULT_BUILTIN) {
            return this.buildBuiltinGraph(debug, method, providers, purpose);
        }
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        NativeLibraries nativeLibraries = CEntryPointCallStubSupport.singleton().getNativeLibraries();
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        JavaType[] parameterTypes = method.toParameterTypes();
        JavaType[] parameterLoadTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        EnumInfo[] parameterEnumInfos = this.adaptParameterTypes(providers, nativeLibraries, kit, parameterTypes, parameterLoadTypes);
        ValueNode[] args = kit.loadArguments(parameterLoadTypes).toArray(ValueNode.EMPTY_ARRAY);
        InvokeWithExceptionNode invokePrologue = this.generatePrologue(providers, kit, parameterLoadTypes, this.targetMethod.getParameterAnnotations(), args);
        if (invokePrologue != null) {
            ResolvedJavaMethod prologueMethod = invokePrologue.callTarget().targetMethod();
            JavaKind prologueReturnKind = prologueMethod.getSignature().getReturnKind();
            if (prologueReturnKind == JavaKind.Int) {
                kit.startIf((LogicNode)kit.unique((FloatingNode)new IntegerEqualsNode((ValueNode)invokePrologue, (ValueNode)ConstantNode.forInt((int)0, (StructuredGraph)kit.getGraph()))), BranchProbabilityNode.VERY_FAST_PATH_PROFILE);
                kit.thenPart();
                kit.elsePart();
                Class<?> bailoutCustomizer = this.entryPointData.getPrologueBailout();
                JavaKind targetMethodReturnKind = this.targetMethod.getSignature().getReturnKind();
                boolean createdReturnNode = false;
                if (bailoutCustomizer == CEntryPointOptions.AutomaticPrologueBailout.class) {
                    if (targetMethodReturnKind == JavaKind.Int) {
                        kit.createReturn((ValueNode)invokePrologue, JavaKind.Int);
                        createdReturnNode = true;
                    } else if (targetMethodReturnKind == JavaKind.Void) {
                        kit.createReturn(null, JavaKind.Void);
                        createdReturnNode = true;
                    } else {
                        VMError.shouldNotReachHere("@CEntryPointOptions on " + this.targetMethod + " must specify a custom prologue bailout as the method's return type is neither int nor void.");
                    }
                }
                if (!createdReturnNode) {
                    ResolvedJavaMethod[] bailoutMethods = providers.getMetaAccess().lookupJavaType(bailoutCustomizer).getDeclaredMethods();
                    UserError.guarantee(bailoutMethods.length == 1 && bailoutMethods[0].isStatic(), "Prologue bailout customization class must declare exactly one static method: %s -> %s", this.targetMethod, bailoutCustomizer);
                    InvokeWithExceptionNode invokeBailoutCustomizer = CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, bailoutMethods[0], new ValueNode[]{invokePrologue});
                    VMError.guarantee(bailoutMethods[0].getSignature().getReturnKind() == method.getSignature().getReturnKind(), "Return type mismatch: %s is incompatible with %s", bailoutMethods[0], this.targetMethod);
                    kit.createReturn((ValueNode)invokeBailoutCustomizer, this.targetMethod.getSignature().getReturnKind());
                }
                kit.endIf();
            } else {
                VMError.guarantee(prologueReturnKind == JavaKind.Void, "%s is a prologue method and must therefore either return int or void.", prologueMethod);
            }
        }
        CEntryPointCallStubMethod.adaptArgumentValues(providers, kit, parameterTypes, parameterEnumInfos, args);
        ResolvedJavaMethod universeTargetMethod = this.unwrapMethodAndLookupInUniverse(metaAccess);
        kit.emitEnsureInitializedCall(universeTargetMethod.getDeclaringClass());
        int invokeBci = kit.bci();
        CallTargetNode.InvokeKind invokeKind = universeTargetMethod.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Special;
        ValueNode[] invokeArgs = args;
        if (invokeKind != CallTargetNode.InvokeKind.Static) {
            invokeArgs = new ValueNode[args.length + 1];
            invokeArgs[0] = kit.createObject(null);
            System.arraycopy(args, 0, invokeArgs, 1, args.length);
        }
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(universeTargetMethod, invokeKind, kit.getFrameState(), invokeBci, invokeArgs);
        CEntryPointCallStubMethod.patchNodeSourcePosition(invoke);
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        this.generateExceptionHandler(method, providers, purpose, kit, exception, invoke.getStackKind());
        kit.endInvokeWithException();
        this.generateEpilogueAndReturn(method, providers, purpose, kit, (ValueNode)invoke);
        return kit.finalizeGraph();
    }

    private void generateEpilogueAndReturn(ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose, HostedGraphKit kit, ValueNode value) {
        ValueNode returnValue = this.adaptReturnValue(method, providers, purpose, kit, value);
        this.generateEpilogue(providers, kit);
        kit.createReturn(returnValue, returnValue.getStackKind());
    }

    private static void patchNodeSourcePosition(InvokeWithExceptionNode invoke) {
        NodeSourcePosition position = invoke.getNodeSourcePosition();
        if (position != null && position.getBCI() == -6) {
            invoke.setNodeSourcePosition(new NodeSourcePosition(position.getCaller(), position.getMethod(), invoke.bci()));
        }
    }

    private StructuredGraph buildBuiltinGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        int index;
        ResolvedJavaMethod universeTargetMethod = this.unwrapMethodAndLookupInUniverse((UniverseMetaAccess)providers.getMetaAccess());
        UserError.guarantee(this.entryPointData.getPrologue() == CEntryPointData.DEFAULT_PROLOGUE, "@%s method declared as built-in must not have a custom prologue: %s", CEntryPoint.class.getSimpleName(), universeTargetMethod);
        UserError.guarantee(this.entryPointData.getEpilogue() == CEntryPointData.DEFAULT_EPILOGUE, "@%s method declared as built-in must not have a custom epilogue: %s", CEntryPoint.class.getSimpleName(), universeTargetMethod);
        UserError.guarantee(this.entryPointData.getExceptionHandler() == CEntryPointData.DEFAULT_EXCEPTION_HANDLER, "@%s method declared as built-in must not have a custom exception handler: %s", CEntryPoint.class.getSimpleName(), universeTargetMethod);
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        ExecutionContextParameters executionContext = this.findExecutionContextParameters(providers, universeTargetMethod.toParameterTypes(), universeTargetMethod.getParameterAnnotations());
        CEntryPoint.Builtin builtin = this.entryPointData.getBuiltin();
        ResolvedJavaMethod builtinCallee = null;
        for (ResolvedJavaMethod candidate : metaAccess.lookupJavaType(CEntryPointBuiltins.class).getDeclaredMethods()) {
            CEntryPointBuiltins.CEntryPointBuiltinImplementation annotation = (CEntryPointBuiltins.CEntryPointBuiltinImplementation)candidate.getAnnotation(CEntryPointBuiltins.CEntryPointBuiltinImplementation.class);
            if (annotation == null || !annotation.builtin().equals((Object)builtin)) continue;
            VMError.guarantee(builtinCallee == null, "More than one candidate for @%s built-in %s", CEntryPoint.class.getSimpleName(), builtin);
            builtinCallee = candidate;
        }
        VMError.guarantee(builtinCallee != null, "No candidate for @%s built-in %s", CEntryPoint.class.getSimpleName(), builtin);
        ResolvedJavaType isolateType = providers.getMetaAccess().lookupJavaType(Isolate.class);
        ResolvedJavaType threadType = providers.getMetaAccess().lookupJavaType(IsolateThread.class);
        int builtinIsolateIndex = -1;
        int builtinThreadIndex = -1;
        JavaType[] builtinParamTypes = builtinCallee.toParameterTypes();
        for (int i = 0; i < builtinParamTypes.length; ++i) {
            ResolvedJavaType type = (ResolvedJavaType)builtinParamTypes[i];
            if (isolateType.isAssignableFrom(type)) {
                VMError.guarantee(builtinIsolateIndex == -1, "@%s built-in with more than one %s parameter: %s", CEntryPoint.class.getSimpleName(), Isolate.class.getSimpleName(), builtinCallee);
                builtinIsolateIndex = i;
                continue;
            }
            if (threadType.isAssignableFrom(type)) {
                VMError.guarantee(builtinThreadIndex == -1, "@%s built-in with more than one %s parameter: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), builtinCallee);
                builtinThreadIndex = i;
                continue;
            }
            VMError.shouldNotReachHere("@%s built-in currently may have only %s or %s parameters: %s", CEntryPoint.class.getSimpleName(), Isolate.class.getSimpleName(), IsolateThread.class.getSimpleName(), builtinCallee);
        }
        ValueNode[] args = kit.loadArguments(method.toParameterTypes()).toArray(ValueNode.EMPTY_ARRAY);
        ValueNode[] builtinArgs = new ValueNode[builtinParamTypes.length];
        if (builtinIsolateIndex != -1) {
            VMError.guarantee(executionContext.designatedIsolateIndex != -1 || executionContext.isolateCount == 1, "@%s built-in %s needs exactly one %s parameter: %s", CEntryPoint.class.getSimpleName(), this.entryPointData.getBuiltin(), Isolate.class.getSimpleName(), builtinCallee);
            index = executionContext.designatedIsolateIndex != -1 ? executionContext.designatedIsolateIndex : executionContext.lastIsolateIndex;
            builtinArgs[builtinIsolateIndex] = args[index];
        }
        if (builtinThreadIndex != -1) {
            VMError.guarantee(executionContext.designatedThreadIndex != -1 || executionContext.threadCount == 1, "@%s built-in %s needs exactly one %s parameter: %s", CEntryPoint.class.getSimpleName(), this.entryPointData.getBuiltin(), IsolateThread.class.getSimpleName(), builtinCallee);
            index = executionContext.designatedThreadIndex != -1 ? executionContext.designatedThreadIndex : executionContext.lastThreadIndex;
            builtinArgs[builtinThreadIndex] = args[index];
        }
        int invokeBci = kit.bci();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(builtinCallee, CallTargetNode.InvokeKind.Static, kit.getFrameState(), invokeBci, builtinArgs);
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        this.generateExceptionHandler(method, providers, purpose, kit, exception, invoke.getStackKind());
        kit.endInvokeWithException();
        kit.createReturn((ValueNode)invoke, universeTargetMethod.getSignature().getReturnKind());
        return kit.finalizeGraph();
    }

    private EnumInfo[] adaptParameterTypes(HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, JavaType[] parameterTypes, JavaType[] parameterLoadTypes) {
        EnumInfo[] parameterEnumInfos = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].getJavaKind().isPrimitive() || providers.getWordTypes().isWord(parameterTypes[i])) continue;
            ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)parameterTypes[i]));
            if (typeInfo instanceof EnumInfo) {
                UserError.guarantee(typeInfo.getChildren().stream().anyMatch(EnumLookupInfo.class::isInstance), "Enum class %s needs a method that is annotated with @%s because it is used as a parameter of an entry point method: %s", parameterTypes[i], CEnumLookup.class.getSimpleName(), this.targetMethod);
                if (parameterEnumInfos == null) {
                    parameterEnumInfos = new EnumInfo[parameterTypes.length];
                }
                parameterEnumInfos[i] = (EnumInfo)typeInfo;
                parameterLoadTypes[i] = providers.getMetaAccess().lookupJavaType(cEnumParameterKind.toJavaClass());
                int parameterIndex = i;
                FrameState initialState = kit.getGraph().start().stateAfter();
                Iterator matchingNodes = initialState.values().filter(node -> ((ParameterNode)node).index() == parameterIndex).iterator();
                ValueNode parameterNode = (ValueNode)matchingNodes.next();
                assert (!matchingNodes.hasNext() && parameterNode.usages().filter(n -> n != initialState).isEmpty());
                parameterNode.setStamp(StampFactory.forKind((JavaKind)cEnumParameterKind));
                continue;
            }
            throw UserError.abort("Entry point method parameter types are restricted to primitive types, word types and enumerations (@%s): %s", CEnum.class.getSimpleName(), this.targetMethod);
        }
        return parameterEnumInfos;
    }

    private static void adaptArgumentValues(HostedProviders providers, HostedGraphKit kit, JavaType[] parameterTypes, EnumInfo[] parameterEnumInfos, ValueNode[] args) {
        if (parameterEnumInfos != null) {
            for (int i = 0; i < parameterEnumInfos.length; ++i) {
                if (parameterEnumInfos[i] == null) continue;
                CInterfaceEnumTool tool = new CInterfaceEnumTool(providers.getMetaAccess(), providers.getSnippetReflection());
                args[i] = tool.createEnumLookupInvoke(kit, (ResolvedJavaType)parameterTypes[i], parameterEnumInfos[i], cEnumParameterKind, args[i]);
            }
        }
    }

    private InvokeWithExceptionNode generatePrologue(HostedProviders providers, SubstrateGraphKit kit, JavaType[] parameterTypes, Annotation[][] parameterAnnotations, ValueNode[] args) {
        Class<Object> prologueClass = this.entryPointData.getPrologue();
        if (prologueClass == CEntryPointOptions.NoPrologue.class) {
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)this.targetMethod), "%s.%s is allowed only for methods annotated with @%s: %s", CEntryPointOptions.class.getSimpleName(), CEntryPointOptions.NoPrologue.class.getSimpleName(), Uninterruptible.class.getSimpleName(), this.targetMethod);
            return null;
        }
        if (prologueClass != CEntryPointOptions.AutomaticPrologue.class) {
            ResolvedJavaType prologue = providers.getMetaAccess().lookupJavaType(prologueClass);
            ResolvedJavaMethod[] prologueMethods = prologue.getDeclaredMethods();
            UserError.guarantee(prologueMethods.length == 1 && prologueMethods[0].isStatic(), "Prologue class must declare exactly one static method: %s -> %s", this.targetMethod, prologue);
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)prologueMethods[0]), "Prologue method must be annotated with @%s: %s", Uninterruptible.class.getSimpleName(), prologueMethods[0]);
            ValueNode[] prologueArgs = this.matchPrologueParameters(providers, parameterTypes, args, prologueMethods[0]);
            return CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, prologueMethods[0], prologueArgs);
        }
        ExecutionContextParameters executionContext = this.findExecutionContextParameters(providers, parameterTypes, parameterAnnotations);
        int contextIndex = -1;
        if (executionContext.designatedThreadIndex != -1) {
            contextIndex = executionContext.designatedThreadIndex;
        } else if (executionContext.threadCount == 1) {
            contextIndex = executionContext.lastThreadIndex;
        } else {
            UserError.abort("@%s requires exactly one execution context parameter of type %s: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
        }
        ValueNode contextValue = args[contextIndex];
        prologueClass = CEntryPointSetup.EnterPrologue.class;
        ResolvedJavaMethod[] prologueMethods = providers.getMetaAccess().lookupJavaType(prologueClass).getDeclaredMethods();
        assert (prologueMethods.length == 1 && prologueMethods[0].isStatic()) : "Prologue class must declare exactly one static method";
        return CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, prologueMethods[0], contextValue);
    }

    private static InvokeWithExceptionNode generatePrologueOrEpilogueInvoke(SubstrateGraphKit kit, ResolvedJavaMethod method, ValueNode ... args) {
        VMError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method), "The method %s must be uninterruptible as it is used for a prologue or epilogue.", method);
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(method, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), args);
        kit.exceptionPart();
        kit.append((ValueNode)new DeadEndNode());
        kit.endInvokeWithException();
        return invoke;
    }

    private ExecutionContextParameters findExecutionContextParameters(HostedProviders providers, JavaType[] parameterTypes, Annotation[][] parameterAnnotations) {
        ResolvedJavaType isolateType = providers.getMetaAccess().lookupJavaType(Isolate.class);
        ResolvedJavaType threadType = providers.getMetaAccess().lookupJavaType(IsolateThread.class);
        ExecutionContextParameters result = new ExecutionContextParameters();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ResolvedJavaType declaredType = (ResolvedJavaType)parameterTypes[i];
            boolean isIsolate = isolateType.isAssignableFrom(declaredType);
            boolean isThread = threadType.isAssignableFrom(declaredType);
            boolean isLong = declaredType.getJavaKind() == JavaKind.Long;
            boolean designated = false;
            for (Annotation ann : parameterAnnotations[i]) {
                if (ann.annotationType() == CEntryPoint.IsolateContext.class) {
                    UserError.guarantee(isIsolate || isLong, "@%s parameter %d is annotated with @%s, but does not have type %s: %s", CEntryPoint.class.getSimpleName(), i, CEntryPoint.IsolateContext.class.getSimpleName(), Isolate.class.getSimpleName(), this.targetMethod);
                    designated = true;
                    isIsolate = true;
                    continue;
                }
                if (ann.annotationType() != CEntryPoint.IsolateThreadContext.class) continue;
                UserError.guarantee(isThread || isLong, "@%s parameter %d is annotated with @%s, but does not have type %s: %s", CEntryPoint.class.getSimpleName(), i, CEntryPoint.IsolateThreadContext.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
                designated = true;
                isThread = true;
            }
            UserError.guarantee(!isIsolate || !isThread, "@%s parameter %d has a type as both an %s and a %s: %s", CEntryPoint.class.getSimpleName(), i, Isolate.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
            if (isIsolate) {
                result.lastIsolateIndex = i;
                ++result.isolateCount;
                if (!designated) continue;
                UserError.guarantee(result.designatedIsolateIndex == -1, "@%s has more than one designated %s parameter: %s", CEntryPoint.class.getSimpleName(), Isolate.class.getSimpleName(), this.targetMethod);
                result.designatedIsolateIndex = i;
                continue;
            }
            if (!isThread) continue;
            result.lastThreadIndex = i;
            ++result.threadCount;
            if (!designated) continue;
            UserError.guarantee(result.designatedThreadIndex == -1, "@%s has more than one designated %s parameter: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
            result.designatedThreadIndex = i;
        }
        return result;
    }

    private ValueNode[] matchPrologueParameters(HostedProviders providers, JavaType[] types, ValueNode[] values, ResolvedJavaMethod prologueMethod) {
        JavaType[] prologueTypes = prologueMethod.toParameterTypes();
        ValueNode[] prologueValues = new ValueNode[prologueTypes.length];
        int i = 0;
        for (int p = 0; p < prologueTypes.length; ++p) {
            ResolvedJavaType prologueType = (ResolvedJavaType)prologueTypes[p];
            UserError.guarantee(prologueType.isPrimitive() || providers.getWordTypes().isWord((JavaType)prologueType), "Prologue method parameter types are restricted to primitive types and word types: %s -> %s", this.targetMethod, prologueMethod);
            while (i < types.length && !prologueType.isAssignableFrom((ResolvedJavaType)types[i])) {
                ++i;
            }
            if (i >= types.length) {
                throw UserError.abort("Unable to match signature of entry point method to that of prologue method: %s -> %s", this.targetMethod, prologueMethod);
            }
            prologueValues[p] = values[i];
            ++i;
        }
        return prologueValues;
    }

    private void generateExceptionHandler(ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose, HostedGraphKit kit, ExceptionObjectNode exception, JavaKind returnKind) {
        if (this.entryPointData.getExceptionHandler() == CEntryPoint.FatalExceptionHandler.class) {
            kit.appendStateSplitProxy(exception.stateAfter());
            CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)exception);
            kit.append((ValueNode)leave);
            kit.append((ValueNode)new LoweredDeadEndNode());
        } else {
            ResolvedJavaType throwable = providers.getMetaAccess().lookupJavaType(Throwable.class);
            ResolvedJavaType handler = providers.getMetaAccess().lookupJavaType(this.entryPointData.getExceptionHandler());
            ResolvedJavaMethod[] handlerMethods = handler.getDeclaredMethods();
            UserError.guarantee(handlerMethods.length == 1 && handlerMethods[0].isStatic(), "Exception handler class must declare exactly one static method: %s -> %s", this.targetMethod, handler);
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)handlerMethods[0]), "Exception handler method must be annotated with @%s: %s", Uninterruptible.class.getSimpleName(), handlerMethods[0]);
            JavaType[] handlerParameterTypes = handlerMethods[0].toParameterTypes();
            UserError.guarantee(handlerParameterTypes.length == 1 && ((ResolvedJavaType)handlerParameterTypes[0]).isAssignableFrom(throwable), "Exception handler method must have exactly one parameter of type Throwable: %s -> %s", this.targetMethod, handlerMethods[0]);
            InvokeWithExceptionNode handlerInvoke = kit.startInvokeWithException(handlerMethods[0], CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{exception});
            kit.noExceptionPart();
            InvokeWithExceptionNode returnValue = handlerInvoke;
            if (handlerInvoke.getStackKind() != returnKind) {
                JavaKind fromKind = handlerInvoke.getStackKind();
                if (fromKind == JavaKind.Float && returnKind == JavaKind.Double) {
                    returnValue = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.F2D, (ValueNode)returnValue));
                } else if (fromKind.isUnsigned() && returnKind.isNumericInteger() && returnKind.getBitCount() > fromKind.getBitCount()) {
                    returnValue = kit.unique((FloatingNode)new ZeroExtendNode((ValueNode)returnValue, returnKind.getBitCount()));
                } else if (fromKind.isNumericInteger() && returnKind.isNumericInteger() && returnKind.getBitCount() > fromKind.getBitCount()) {
                    returnValue = kit.unique((FloatingNode)new SignExtendNode((ValueNode)returnValue, returnKind.getBitCount()));
                } else {
                    throw UserError.abort("Exception handler method return type must be assignable to entry point method return type: %s -> %s", this.targetMethod, handlerMethods[0]);
                }
            }
            this.generateEpilogueAndReturn(method, providers, purpose, kit, (ValueNode)returnValue);
            kit.exceptionPart();
            kit.append((ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)kit.exceptionObject()));
            kit.append((ValueNode)new LoweredDeadEndNode());
            kit.endInvokeWithException();
        }
    }

    private ValueNode adaptReturnValue(ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose, HostedGraphKit kit, ValueNode value) {
        ValueNode returnValue = value;
        if (returnValue.getStackKind().isPrimitive()) {
            return returnValue;
        }
        JavaType returnType = method.getSignature().getReturnType(null);
        NativeLibraries nativeLibraries = CEntryPointCallStubSupport.singleton().getNativeLibraries();
        ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)returnType));
        if (typeInfo instanceof EnumInfo) {
            CInterfaceEnumTool tool = new CInterfaceEnumTool(providers.getMetaAccess(), providers.getSnippetReflection());
            JavaKind cEnumReturnType = providers.getWordTypes().getWordKind();
            assert (!cEnumReturnType.isUnsigned()) : "requires correct representation of signed values";
            returnValue = tool.startEnumValueInvokeWithException(kit, (EnumInfo)typeInfo, cEnumReturnType, returnValue);
            kit.exceptionPart();
            kit.append((ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)kit.exceptionObject()));
            kit.append((ValueNode)new LoweredDeadEndNode());
            kit.endInvokeWithException();
        } else if (purpose != GraphProvider.Purpose.ANALYSIS) {
            throw UserError.abort("Entry point method return types are restricted to primitive types, word types and enumerations (@%s): %s", CEnum.class.getSimpleName(), this.targetMethod);
        }
        return returnValue;
    }

    private void generateEpilogue(HostedProviders providers, SubstrateGraphKit kit) {
        Class<?> epilogueClass = this.entryPointData.getEpilogue();
        if (epilogueClass == CEntryPointOptions.NoEpilogue.class) {
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)this.targetMethod), "%s.%s is allowed only for methods annotated with @%s: %s", CEntryPointOptions.class.getSimpleName(), CEntryPointOptions.NoEpilogue.class.getSimpleName(), Uninterruptible.class.getSimpleName(), this.targetMethod);
            return;
        }
        ResolvedJavaType epilogue = providers.getMetaAccess().lookupJavaType(epilogueClass);
        ResolvedJavaMethod[] epilogueMethods = epilogue.getDeclaredMethods();
        UserError.guarantee(epilogueMethods.length == 1 && epilogueMethods[0].isStatic() && epilogueMethods[0].getSignature().getParameterCount(false) == 0, "Epilogue class must declare exactly one static method without parameters: %s -> %s", this.targetMethod, epilogue);
        UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)epilogueMethods[0]), "Epilogue method must be annotated with @%s: %s", Uninterruptible.class.getSimpleName(), epilogueMethods[0]);
        CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, epilogueMethods[0], new ValueNode[0]);
    }

    private static class ExecutionContextParameters {
        int isolateCount = 0;
        int lastIsolateIndex = -1;
        int designatedIsolateIndex = -1;
        int threadCount = 0;
        int lastThreadIndex = -1;
        int designatedThreadIndex = -1;

        private ExecutionContextParameters() {
        }
    }
}

