/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Sched;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.posix.headers.linux.LinuxPthread;
import com.oracle.svm.core.posix.thread.Target_java_lang_Thread;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={PlatformThreads.class})
public final class PosixPlatformThreads
extends PlatformThreads {
    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    private static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PosixPlatformThreads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doStartThread(Thread thread, long stackSize) {
        Pthread.pthread_attr_t attributes = UnsafeStackValue.get(Pthread.pthread_attr_t.class);
        if (Pthread.pthread_attr_init(attributes) != 0) {
            return false;
        }
        try {
            if (Pthread.pthread_attr_setdetachstate(attributes, Pthread.PTHREAD_CREATE_JOINABLE()) != 0) {
                boolean bl = false;
                return bl;
            }
            UnsignedWord threadStackSize = WordFactory.unsigned((long)stackSize);
            if (threadStackSize.notEqual((UnsignedWord)WordFactory.zero())) {
                threadStackSize = UnsignedUtils.max(threadStackSize, Pthread.PTHREAD_STACK_MIN());
                if (Pthread.pthread_attr_setstacksize(attributes, threadStackSize = UnsignedUtils.roundUp(threadStackSize, WordFactory.unsigned((int)Unistd.getpagesize()))) != 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            StackOverflowCheck.singleton().makeYellowZoneAvailable();
            try {
                boolean bl = this.doStartThread0(thread, attributes);
                StackOverflowCheck.singleton().protectYellowZone();
                return bl;
            }
            catch (Throwable throwable) {
                StackOverflowCheck.singleton().protectYellowZone();
                throw throwable;
            }
        }
        finally {
            Pthread.pthread_attr_destroy(attributes);
        }
    }

    @NeverInline(value="Workaround for GR-51925 - prevent that reads float from this method into the caller.")
    private boolean doStartThread0(Thread thread, Pthread.pthread_attr_t attributes) {
        Object startData = this.prepareStart(thread, SizeOf.get(PlatformThreads.ThreadStartData.class));
        try {
            Pthread.pthread_tPointer newThread = UnsafeStackValue.get(Pthread.pthread_tPointer.class);
            if (Pthread.pthread_create(newThread, attributes, (WordBase)threadStartRoutine.getFunctionPointer(), startData) != 0) {
                this.undoPrepareStartOnError(thread, (PlatformThreads.ThreadStartData)startData);
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            throw VMError.shouldNotReachHere("No exception must be thrown after creating the thread start data.", e);
        }
    }

    private static void setPthreadIdentifier(Thread thread, Pthread.pthread_t pthread) {
        PosixPlatformThreads.toTarget((Thread)thread).hasPthreadIdentifier = true;
        PosixPlatformThreads.toTarget((Thread)thread).pthreadIdentifier = pthread;
    }

    static Pthread.pthread_t getPthreadIdentifier(Thread thread) {
        return PosixPlatformThreads.toTarget((Thread)thread).pthreadIdentifier;
    }

    static boolean hasThreadIdentifier(Thread thread) {
        return PosixPlatformThreads.toTarget((Thread)thread).hasPthreadIdentifier;
    }

    @Override
    protected void setNativeName(Thread thread, String name) {
        if (!PosixPlatformThreads.hasThreadIdentifier(thread)) {
            return;
        }
        if (IsDefined.isDarwin() && thread != Thread.currentThread()) {
            return;
        }
        int startIndex = Math.max(0, name.length() - 15);
        String pthreadName = name.substring(startIndex);
        assert (pthreadName.length() < 16) : "thread name for pthread has a maximum length of 16 characters including the terminating 0";
        try (CTypeConversion.CCharPointerHolder threadNameHolder = CTypeConversion.toCString((CharSequence)pthreadName);){
            if (IsDefined.isLinux()) {
                LinuxPthread.pthread_setname_np(PosixPlatformThreads.getPthreadIdentifier(thread), threadNameHolder.get());
            } else if (IsDefined.isDarwin()) {
                assert (thread == Thread.currentThread()) : "Darwin only allows setting the name of the current thread";
                DarwinPthread.pthread_setname_np(threadNameHolder.get());
            } else {
                VMError.unsupportedFeature("PosixPlatformThreads.setNativeName on unknown OS");
            }
        }
    }

    @Override
    protected void yieldCurrent() {
        Sched.sched_yield();
    }

    @Override
    protected void beforeThreadRun(Thread thread) {
        PosixPlatformThreads.setPthreadIdentifier(thread, Pthread.pthread_self());
        this.setNativeName(thread, thread.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMThreads.OSThreadHandle startThreadUnmanaged(CFunctionPointer threadRoutine, PointerBase userData, int stackSize) {
        Pthread.pthread_attr_t attributes = (Pthread.pthread_attr_t)StackValue.get(Pthread.pthread_attr_t.class);
        int status = Pthread.pthread_attr_init_no_transition(attributes);
        if (status != 0) {
            return (VMThreads.OSThreadHandle)WordFactory.nullPointer();
        }
        try {
            Pthread.pthread_tPointer newThread;
            status = Pthread.pthread_attr_setdetachstate_no_transition(attributes, Pthread.PTHREAD_CREATE_JOINABLE());
            if (status != 0) {
                VMThreads.OSThreadHandle oSThreadHandle = (VMThreads.OSThreadHandle)WordFactory.nullPointer();
                return oSThreadHandle;
            }
            UnsignedWord threadStackSize = WordFactory.unsigned((int)stackSize);
            if (threadStackSize.notEqual((UnsignedWord)WordFactory.zero())) {
                threadStackSize = UnsignedUtils.max(threadStackSize, Pthread.PTHREAD_STACK_MIN());
                status = Pthread.pthread_attr_setstacksize_no_transition(attributes, threadStackSize = UnsignedUtils.roundUp(threadStackSize, WordFactory.unsigned((int)Unistd.NoTransitions.getpagesize())));
                if (status != 0) {
                    VMThreads.OSThreadHandle oSThreadHandle = (VMThreads.OSThreadHandle)WordFactory.nullPointer();
                    return oSThreadHandle;
                }
            }
            if ((status = Pthread.pthread_create_no_transition(newThread = (Pthread.pthread_tPointer)StackValue.get(Pthread.pthread_tPointer.class), attributes, (WordBase)threadRoutine, (WordBase)userData)) != 0) {
                VMThreads.OSThreadHandle oSThreadHandle = (VMThreads.OSThreadHandle)WordFactory.nullPointer();
                return oSThreadHandle;
            }
            Pthread.pthread_t pthread_t2 = newThread.read();
            return pthread_t2;
        }
        finally {
            Pthread.pthread_attr_destroy_no_transition(attributes);
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean joinThreadUnmanaged(VMThreads.OSThreadHandle threadHandle, WordPointer threadExitStatus) {
        int status = Pthread.pthread_join_no_transition((Pthread.pthread_t)threadHandle, threadExitStatus);
        return status == 0;
    }
}

