/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.invoke.MethodHandleUtils;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.util.AnnotationWrapper;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.List;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;

public class PolymorphicSignatureWrapperMethod
implements ResolvedJavaMethod,
GraphProvider,
AnnotationWrapper {
    private final SubstitutionMethod substitutionBaseMethod;
    private final ResolvedJavaMethod originalMethod;
    private final ConstantPool constantPool;
    private StackTraceElement stackTraceElement;
    private static final LineNumberTable lineNumberTable = new LineNumberTable(new int[]{1}, new int[]{0});

    PolymorphicSignatureWrapperMethod(SubstitutionMethod substitutionBaseMethod, ResolvedJavaMethod originalMethod) {
        this.substitutionBaseMethod = substitutionBaseMethod;
        this.originalMethod = originalMethod;
        this.constantPool = substitutionBaseMethod.getDeclaringClass().getDeclaredConstructors()[0].getConstantPool();
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
        List<ValueNode> args = kit.loadArguments(method.toParameterTypes());
        ValueNode receiver = null;
        if (!this.substitutionBaseMethod.isStatic()) {
            receiver = args.remove(0);
        }
        ValueNode parameterArray = kit.append((ValueNode)new NewArrayNode(metaAccess.lookupJavaType(Object.class), (ValueNode)kit.createInt(args.size()), true));
        for (int i = 0; i < args.size(); ++i) {
            ValueNode arg = args.get(i);
            if (arg.getStackKind().isPrimitive()) {
                arg = kit.createBoxing(arg, arg.getStackKind(), metaAccess.lookupJavaType(arg.getStackKind().toBoxedJavaClass()));
            }
            StateSplit storeIndexedNode = (StateSplit)kit.createStoreIndexed(parameterArray, i, JavaKind.Object, arg);
            storeIndexedNode.setStateAfter(kit.getFrameState().create(kit.bci(), storeIndexedNode));
        }
        ResolvedJavaMethod invokeTarget = metaAccess instanceof AnalysisMetaAccess ? metaAccess.getUniverse().lookup((JavaMethod)this.substitutionBaseMethod.getOriginal()) : metaAccess.getUniverse().lookup((JavaMethod)((AnalysisMetaAccess)metaAccess.getWrapped()).getUniverse().lookup((JavaMethod)this.substitutionBaseMethod.getOriginal()));
        InvokeWithExceptionNode invoke = this.substitutionBaseMethod.isStatic() ? kit.createInvokeWithExceptionAndUnwind(invokeTarget, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{parameterArray}) : kit.createInvokeWithExceptionAndUnwind(invokeTarget, CallTargetNode.InvokeKind.Virtual, kit.getFrameState(), kit.bci(), new ValueNode[]{receiver, parameterArray});
        JavaKind returnKind = this.getSignature().getReturnKind();
        InvokeWithExceptionNode retVal = invoke;
        if (returnKind.isPrimitive() && returnKind != JavaKind.Void) {
            switch (returnKind) {
                case Short: 
                case Int: 
                case Long: {
                    ResolvedJavaMethod unboxMethod;
                    ValueNode methodHandleOrMemberName;
                    try {
                        String unboxMethodName = returnKind.toString() + "Unbox";
                        switch (this.substitutionBaseMethod.getName()) {
                            case "invokeBasic": 
                            case "invokeExact": 
                            case "invoke": {
                                methodHandleOrMemberName = receiver;
                                unboxMethod = metaAccess.lookupJavaMethod((Executable)MethodHandleUtils.class.getMethod(unboxMethodName, Object.class, MethodHandle.class));
                                break;
                            }
                            case "linkToVirtual": 
                            case "linkToStatic": 
                            case "linkToInterface": 
                            case "linkToSpecial": {
                                methodHandleOrMemberName = args.get(args.size() - 1);
                                unboxMethod = metaAccess.lookupJavaMethod((Executable)MethodHandleUtils.class.getMethod(unboxMethodName, Object.class, Target_java_lang_invoke_MemberName.class));
                                break;
                            }
                            default: {
                                throw VMError.shouldNotReachHere();
                            }
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw VMError.shouldNotReachHere();
                    }
                    retVal = kit.createInvokeWithExceptionAndUnwind(unboxMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{retVal, methodHandleOrMemberName});
                    break;
                }
                default: {
                    retVal = kit.createUnboxing((ValueNode)invoke, returnKind);
                }
            }
        }
        kit.createReturn((ValueNode)retVal, returnKind);
        return kit.finalizeGraph();
    }

    public String getName() {
        return this.substitutionBaseMethod.getName();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.substitutionBaseMethod.getDeclaringClass();
    }

    public Signature getSignature() {
        return this.originalMethod.getSignature();
    }

    public boolean allowRuntimeCompilation() {
        return false;
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public int getMaxLocals() {
        return 2 * this.getSignature().getParameterCount(true);
    }

    public int getMaxStackSize() {
        return 2;
    }

    public boolean isSynthetic() {
        return true;
    }

    public boolean isVarArgs() {
        return false;
    }

    public boolean isBridge() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isClassInitializer() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean canBeStaticallyBound() {
        return true;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return new ExceptionHandler[0];
    }

    public StackTraceElement asStackTraceElement(int bci) {
        if (this.stackTraceElement == null) {
            this.stackTraceElement = new StackTraceElement(this.getDeclaringClass().toJavaName(true), this.getName(), "generated", 0);
        }
        return this.stackTraceElement;
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.unimplemented();
    }

    public void reprofile() {
        throw VMError.unimplemented();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.unimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw VMError.unimplemented();
    }

    public boolean canBeInlined() {
        return true;
    }

    public boolean hasNeverInlineDirective() {
        return false;
    }

    public boolean shouldBeInlined() {
        return true;
    }

    public LineNumberTable getLineNumberTable() {
        return lineNumberTable;
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.unimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.unimplemented();
    }

    public AnnotatedElement getAnnotationRoot() {
        return this.substitutionBaseMethod;
    }

    public int getModifiers() {
        return this.substitutionBaseMethod.getModifiers();
    }
}

