/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.svm.hosted.code.CompilationGraph;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;

public class CompilationInfo {
    protected final HostedMethod method;
    protected final AtomicBoolean inParseQueue = new AtomicBoolean(false);
    protected boolean inCompileQueue;
    private volatile CompilationGraph compilationGraph;
    private OptionValues compileOptions;
    protected boolean isTrivialMethod;
    protected boolean canDeoptForTesting;
    protected ConstantNode[] specializedArguments;
    protected HostedMethod deoptTarget;
    protected final HostedMethod deoptOrigin;
    protected CompileQueue.ParseFunction customParseFunction;
    protected CompileQueue.CompileFunction customCompileFunction;
    protected long numNodesAfterParsing;
    protected long numNodesBeforeCompilation;
    protected long numNodesAfterCompilation;
    protected long numDeoptEntryPoints;
    protected long numDuringCallEntryPoints;
    protected final AtomicLong numDirectCalls = new AtomicLong();
    protected final AtomicLong numVirtualCalls = new AtomicLong();
    protected final AtomicLong numEntryPointCalls = new AtomicLong();

    public CompilationInfo(HostedMethod method, HostedMethod deoptOrigin) {
        this.method = method;
        this.deoptOrigin = deoptOrigin;
        if (deoptOrigin != null) {
            assert (deoptOrigin.compilationInfo.deoptTarget == null);
            deoptOrigin.compilationInfo.deoptTarget = method;
        }
    }

    public boolean isDeoptTarget() {
        return this.deoptOrigin != null;
    }

    public boolean isDeoptEntry(int bci, boolean duringCall, boolean rethrowException) {
        return this.isDeoptTarget() && (this.deoptOrigin.compilationInfo.canDeoptForTesting || CompilationInfoSupport.singleton().isDeoptEntry(this.method, bci, duringCall, rethrowException));
    }

    public boolean isRegisteredDeoptEntry(int bci, boolean duringCall, boolean rethrowException) {
        return this.isDeoptTarget() && CompilationInfoSupport.singleton().isDeoptTarget(this.method) && CompilationInfoSupport.singleton().isDeoptEntry(this.method, bci, duringCall, rethrowException);
    }

    public boolean canDeoptForTesting() {
        return this.canDeoptForTesting;
    }

    public HostedMethod getDeoptTargetMethod() {
        return this.deoptTarget;
    }

    public CompilationGraph getCompilationGraph() {
        return this.compilationGraph;
    }

    public StructuredGraph createGraph(DebugContext debug, CompilationIdentifier compilationId, boolean decode) {
        StructuredGraph graph = new StructuredGraph.Builder(this.compileOptions, debug).method((ResolvedJavaMethod)this.method).recordInlinedMethods(false).trackNodeSourcePosition(this.getCompilationGraph().getEncodedGraph().trackNodeSourcePosition()).compilationId(compilationId).build();
        if (decode) {
            try (DebugContext.Scope s = debug.scope((Object)"CreateGraph", (Object)graph, (Object)this.method);){
                GraphDecoder decoder = new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, graph);
                decoder.decode(this.getCompilationGraph().getEncodedGraph());
            }
            catch (Throwable ex) {
                throw debug.handle(ex);
            }
        }
        return graph;
    }

    void encodeGraph(StructuredGraph graph) {
        this.compilationGraph = CompilationGraph.encode(graph);
    }

    public void setCompileOptions(OptionValues compileOptions) {
        this.compileOptions = compileOptions;
    }

    public void clear() {
        this.compilationGraph = null;
        this.specializedArguments = null;
    }

    public boolean isTrivialMethod() {
        return this.isTrivialMethod;
    }

    public void setTrivialMethod(boolean trivial) {
        this.isTrivialMethod = trivial;
    }

    public void setCustomParseFunction(CompileQueue.ParseFunction parseFunction) {
        this.customParseFunction = parseFunction;
    }

    public CompileQueue.ParseFunction getCustomParseFunction() {
        return this.customParseFunction;
    }

    public void setCustomCompileFunction(CompileQueue.CompileFunction compileFunction) {
        this.customCompileFunction = compileFunction;
    }

    public CompileQueue.CompileFunction getCustomCompileFunction() {
        return this.customCompileFunction;
    }

    public boolean hasDefaultParseFunction() {
        return this.customCompileFunction == null;
    }
}

