/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.BuiltinDirectives;
import com.oracle.svm.hosted.c.CAnnotationProcessor;
import com.oracle.svm.hosted.c.CAnnotationProcessorCache;
import com.oracle.svm.hosted.c.CInterfaceError;
import com.oracle.svm.hosted.c.NativeCodeContext;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawPointerTo;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class NativeLibraries {
    private final MetaAccessProvider metaAccess;
    private final SnippetReflectionProvider snippetReflection;
    private final TargetDescription target;
    private ClassInitializationSupport classInitializationSupport;
    private final Map<Object, ElementInfo> elementToInfo;
    private final Map<Class<? extends CContext.Directives>, NativeCodeContext> compilationUnitToContext;
    private final ResolvedJavaType wordBaseType;
    private final ResolvedJavaType signedType;
    private final ResolvedJavaType unsignedType;
    private final ResolvedJavaType pointerBaseType;
    private final ResolvedJavaType stringType;
    private final ResolvedJavaType byteArrayType;
    private final ResolvedJavaType enumType;
    private final ResolvedJavaType locationIdentityType;
    private final LinkedHashSet<CLibrary> annotated;
    private final List<String> libraries;
    private final DependencyGraph dependencyGraph;
    private final List<String> jniStaticLibraries;
    private final LinkedHashSet<String> libraryPaths;
    private final List<CInterfaceError> errors;
    private final ConstantReflectionProvider constantReflection;
    private final CAnnotationProcessorCache cache;
    public final Path tempDirectory;
    public final DebugContext debug;

    public NativeLibraries(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, TargetDescription target, ClassInitializationSupport classInitializationSupport, Path tempDirectory, DebugContext debug) {
        this.metaAccess = metaAccess;
        this.constantReflection = constantReflection;
        this.snippetReflection = snippetReflection;
        this.target = target;
        this.classInitializationSupport = classInitializationSupport;
        this.tempDirectory = tempDirectory;
        this.debug = debug;
        this.elementToInfo = new HashMap<Object, ElementInfo>();
        this.errors = new ArrayList<CInterfaceError>();
        this.compilationUnitToContext = new HashMap<Class<? extends CContext.Directives>, NativeCodeContext>();
        this.wordBaseType = this.lookupAndRegisterType(WordBase.class);
        this.signedType = this.lookupAndRegisterType(SignedWord.class);
        this.unsignedType = this.lookupAndRegisterType(UnsignedWord.class);
        this.pointerBaseType = this.lookupAndRegisterType(PointerBase.class);
        this.stringType = this.lookupAndRegisterType(String.class);
        this.byteArrayType = this.lookupAndRegisterType(byte[].class);
        this.enumType = this.lookupAndRegisterType(Enum.class);
        this.locationIdentityType = this.lookupAndRegisterType(LocationIdentity.class);
        this.lookupAndRegisterType(Word.class);
        this.lookupAndRegisterType(WordFactory.class);
        this.lookupAndRegisterType(ObjectAccess.class);
        this.lookupAndRegisterType(BarrieredAccess.class);
        this.annotated = new LinkedHashSet();
        this.libraries = Collections.synchronizedList(new ArrayList());
        this.dependencyGraph = new DependencyGraph();
        this.jniStaticLibraries = Collections.synchronizedList(new ArrayList());
        this.libraryPaths = NativeLibraries.initCLibraryPath();
        this.cache = new CAnnotationProcessorCache();
    }

    private ResolvedJavaType lookupAndRegisterType(Class<?> clazz) {
        AnalysisType type = (AnalysisType)this.metaAccess.lookupJavaType(clazz);
        type.registerAsReachable();
        return type;
    }

    public MetaAccessProvider getMetaAccess() {
        return this.metaAccess;
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.snippetReflection;
    }

    public TargetDescription getTarget() {
        return this.target;
    }

    private static String getStaticLibraryName(String libraryName) {
        boolean targetWindows = Platform.includedIn(Platform.WINDOWS.class);
        String prefix = targetWindows ? "" : "lib";
        String suffix = targetWindows ? ".lib" : ".a";
        return prefix + libraryName + suffix;
    }

    private static Path getPlatformDependentJDKStaticLibraryPath() throws IOException {
        Path baseSearchPath = Paths.get(System.getProperty("java.home"), new String[0]).resolve("lib").toRealPath(new LinkOption[0]);
        Path staticLibPath = baseSearchPath.resolve("static");
        Platform platform = (Platform)ImageSingletons.lookup(Platform.class);
        Path platformDependentPath = staticLibPath.resolve((platform.getOS() + "-" + platform.getArchitecture()).toLowerCase());
        if (LibCBase.isPlatformEquivalent(Platform.LINUX.class)) {
            platformDependentPath = platformDependentPath.resolve(LibCBase.singleton().getName());
            if (LibCBase.singleton().requiresLibCSpecificStaticJDKLibraries()) {
                return platformDependentPath;
            }
        }
        if (Files.exists(platformDependentPath, new LinkOption[0])) {
            return platformDependentPath;
        }
        return baseSearchPath;
    }

    private static LinkedHashSet<String> initCLibraryPath() {
        LinkedHashSet<String> libraryPaths = new LinkedHashSet<String>();
        Path staticLibsDir = null;
        String hint = null;
        try {
            Path jdkLibDir = NativeLibraries.getPlatformDependentJDKStaticLibraryPath();
            List<String> defaultBuiltInLibraries = Arrays.asList(PlatformNativeLibrarySupport.defaultBuiltInLibraries);
            Predicate<String> hasStaticLibrary = s -> Files.isRegularFile(jdkLibDir.resolve(NativeLibraries.getStaticLibraryName(s)), new LinkOption[0]);
            if (defaultBuiltInLibraries.stream().allMatch(hasStaticLibrary)) {
                staticLibsDir = jdkLibDir;
            } else {
                String libraryLocationHint = System.lineSeparator() + "(search path: " + jdkLibDir + ")";
                hint = defaultBuiltInLibraries.stream().filter(hasStaticLibrary.negate()).collect(Collectors.joining(", ", "Missing libraries: ", libraryLocationHint));
            }
        }
        catch (IOException e) {
            hint = e.getMessage();
        }
        if (staticLibsDir == null) {
            // empty if block
        }
        if (staticLibsDir != null) {
            libraryPaths.add(staticLibsDir.toString());
        } else if (!(NativeImageOptions.ExitAfterRelocatableImageWrite.getValue().booleanValue() || CAnnotationProcessorCache.Options.ExitAfterQueryCodeGeneration.getValue().booleanValue() || CAnnotationProcessorCache.Options.ExitAfterCAPCache.getValue().booleanValue())) {
            Object libCMessage = "";
            if (Platform.includedIn(Platform.LINUX.class)) {
                libCMessage = " (target libc: " + LibCBase.singleton().getName() + ")";
            }
            String jdkDownloadURL = "https://github.com/graalvm/labs-openjdk-*/releases";
            UserError.guarantee(!Platform.includedIn(InternalPlatform.PLATFORM_JNI.class), "Building images for %s%s requires static JDK libraries.%nUse most recent JDK from %s%n%s", ((Platform)ImageSingletons.lookup(Platform.class)).getClass().getName(), libCMessage, jdkDownloadURL, hint);
        }
        return libraryPaths;
    }

    public void addError(String msg, Object ... context) {
        this.getErrors().add(new CInterfaceError(msg, context));
    }

    public List<CInterfaceError> getErrors() {
        return this.errors;
    }

    public void reportErrors() {
        if (this.errors.size() > 0) {
            throw UserError.abort(this.errors.stream().map(CInterfaceError::getMessage).collect(Collectors.toList()));
        }
    }

    public void loadJavaMethod(ResolvedJavaMethod method) {
        Class<? extends CContext.Directives> directives = this.getDirectives(method);
        NativeCodeContext context = this.makeContext(directives);
        if (context.isInConfiguration()) {
            if (method.getAnnotation(CConstant.class) != null) {
                context.appendConstantAccessor(method);
            } else if (method.getAnnotation(CFunction.class) == null) {
                this.addError("Method is not annotated with supported C interface annotation", method);
            }
        }
    }

    public void loadJavaType(ResolvedJavaType type) {
        NativeCodeContext context = this.makeContext(this.getDirectives(type));
        if (context.isInConfiguration()) {
            if (type.getAnnotation(CStruct.class) != null) {
                context.appendStructType(type);
            } else if (type.getAnnotation(RawStructure.class) != null) {
                context.appendRawStructType(type);
            } else if (type.getAnnotation(CPointerTo.class) != null) {
                context.appendCPointerToType(type);
            } else if (type.getAnnotation(RawPointerTo.class) != null) {
                context.appendRawPointerToType(type);
            } else if (type.getAnnotation(CEnum.class) != null) {
                context.appendEnumType(type);
            } else {
                this.addError("Type is not annotated with supported C interface annotation", type);
            }
        }
    }

    public void processCLibraryAnnotations(ImageClassLoader loader) {
        for (Class<?> clazz : loader.findAnnotatedClasses(CLibrary.class, false)) {
            if (!this.makeContext(this.getDirectives(this.metaAccess.lookupJavaType(clazz))).isInConfiguration()) continue;
            this.annotated.add(clazz.getAnnotation(CLibrary.class));
        }
        for (Method method : loader.findAnnotatedMethods(CLibrary.class)) {
            if (!this.makeContext(this.getDirectives(this.metaAccess.lookupJavaType(method.getDeclaringClass()))).isInConfiguration()) continue;
            this.annotated.add(method.getAnnotation(CLibrary.class));
        }
    }

    public void addStaticJniLibrary(String library, String ... dependencies) {
        this.jniStaticLibraries.add(library);
        ArrayList<String> allDeps = new ArrayList<String>(Arrays.asList(dependencies));
        allDeps.add("jvm");
        this.dependencyGraph.add(library, allDeps);
    }

    public void addDynamicNonJniLibrary(String library) {
        this.libraries.add(library);
    }

    public void addStaticNonJniLibrary(String library, String ... dependencies) {
        this.dependencyGraph.add(library, Arrays.asList(dependencies));
    }

    public Collection<String> getLibraries() {
        return this.libraries;
    }

    public Collection<Path> getStaticLibraries() {
        Map<Path, Path> allStaticLibs = this.getAllStaticLibs();
        ArrayList<Path> staticLibs = new ArrayList<Path>();
        List<String> sortedList = this.dependencyGraph.sort();
        for (String staticLibraryName : sortedList) {
            Path libraryPath = NativeLibraries.getStaticLibraryPath(allStaticLibs, staticLibraryName);
            if (libraryPath == null) continue;
            staticLibs.add(libraryPath);
        }
        return staticLibs;
    }

    public Path getStaticLibraryPath(String staticLibraryName) {
        return NativeLibraries.getStaticLibraryPath(this.getAllStaticLibs(), staticLibraryName);
    }

    private static Path getStaticLibraryPath(Map<Path, Path> allStaticLibs, String staticLibraryName) {
        return allStaticLibs.get(Paths.get(NativeLibraries.getStaticLibraryName(staticLibraryName), new String[0]));
    }

    private Map<Path, Path> getAllStaticLibs() {
        LinkedHashMap<Path, Path> allStaticLibs = new LinkedHashMap<Path, Path>();
        String libSuffix = Platform.includedIn(Platform.WINDOWS.class) ? ".lib" : ".a";
        for (String libraryPath : this.getLibraryPaths()) {
            try {
                Stream<Path> paths = Files.list(Paths.get(libraryPath, new String[0]));
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(libSuffix)).forEachOrdered(candidate -> allStaticLibs.put(candidate.getFileName(), (Path)candidate));
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                UserError.abort(e, "Invalid library path %s", libraryPath);
            }
        }
        return allStaticLibs;
    }

    public Collection<String> getLibraryPaths() {
        return this.libraryPaths;
    }

    private NativeCodeContext makeContext(Class<? extends CContext.Directives> compilationUnit) {
        NativeCodeContext result = this.compilationUnitToContext.get(compilationUnit);
        if (result == null) {
            CContext.Directives unit;
            try {
                unit = (CContext.Directives)ReflectionUtil.newInstance(compilationUnit);
            }
            catch (ReflectionUtil.ReflectionUtilError ex) {
                throw UserError.abort(ex.getCause(), "Cannot construct compilation unit %s", compilationUnit.getCanonicalName());
            }
            if (this.classInitializationSupport != null) {
                this.classInitializationSupport.initializeAtBuildTime(unit.getClass(), "CContext.Directives must be eagerly initialized");
            }
            result = new NativeCodeContext(unit);
            this.compilationUnitToContext.put(compilationUnit, result);
        }
        return result;
    }

    private static Object unwrap(AnnotatedElement e) {
        Object element = e;
        assert (element instanceof ResolvedJavaType || element instanceof ResolvedJavaMethod);
        while (element instanceof WrappedElement) {
            element = ((WrappedElement)element).getWrapped();
        }
        assert (element instanceof ResolvedJavaType || element instanceof ResolvedJavaMethod);
        return element;
    }

    public void registerElementInfo(AnnotatedElement e, ElementInfo elementInfo) {
        Object element = NativeLibraries.unwrap(e);
        assert (!this.elementToInfo.containsKey(element));
        this.elementToInfo.put(element, elementInfo);
    }

    public ElementInfo findElementInfo(AnnotatedElement element) {
        Object element1 = NativeLibraries.unwrap(element);
        ElementInfo result = this.elementToInfo.get(element1);
        if (result == null && element1 instanceof ResolvedJavaType && ((ResolvedJavaType)element1).getInterfaces().length == 1) {
            result = this.findElementInfo((AnnotatedElement)((ResolvedJavaType)element1).getInterfaces()[0]);
        }
        return result;
    }

    private static Class<? extends CContext.Directives> getDirectives(CContext useUnit) {
        return useUnit.value();
    }

    private Class<? extends CContext.Directives> getDirectives(ResolvedJavaMethod method) {
        return this.getDirectives(method.getDeclaringClass());
    }

    private Class<? extends CContext.Directives> getDirectives(ResolvedJavaType type) {
        CContext useUnit = (CContext)type.getAnnotation(CContext.class);
        if (useUnit != null) {
            return NativeLibraries.getDirectives(useUnit);
        }
        if (type.getEnclosingType() != null) {
            return this.getDirectives(type.getEnclosingType());
        }
        return BuiltinDirectives.class;
    }

    public void finish() {
        this.libraryPaths.addAll(OptionUtils.flatten(",", SubstrateOptions.CLibraryPath.getValue()));
        for (NativeCodeContext context : this.compilationUnitToContext.values()) {
            if (!context.isInConfiguration()) continue;
            this.libraries.addAll(context.getDirectives().getLibraries());
            this.libraryPaths.addAll(context.getDirectives().getLibraryPaths());
            new CAnnotationProcessor(this, context).process(this.cache);
        }
    }

    public boolean isWordBase(ResolvedJavaType type) {
        return this.wordBaseType.isAssignableFrom(type);
    }

    public boolean isPointerBase(ResolvedJavaType type) {
        return this.pointerBaseType.isAssignableFrom(type);
    }

    public boolean isSigned(ResolvedJavaType type) {
        return this.signedType.equals(type);
    }

    public boolean isUnsigned(ResolvedJavaType type) {
        return this.unsignedType.equals(type);
    }

    public boolean isString(ResolvedJavaType type) {
        return this.stringType.isAssignableFrom(type);
    }

    public boolean isByteArray(ResolvedJavaType type) {
        return this.byteArrayType.isAssignableFrom(type);
    }

    public boolean isEnum(ResolvedJavaType type) {
        return this.enumType.isAssignableFrom(type);
    }

    public ResolvedJavaType enumType() {
        return this.enumType;
    }

    public ResolvedJavaType getPointerBaseType() {
        return this.pointerBaseType;
    }

    public ResolvedJavaType getLocationIdentityType() {
        return this.locationIdentityType;
    }

    public ConstantReflectionProvider getConstantReflection() {
        return this.constantReflection;
    }

    public boolean processAnnotated() {
        if (this.annotated.isEmpty()) {
            return false;
        }
        for (CLibrary lib : this.annotated) {
            if (lib.requireStatic()) {
                this.addStaticNonJniLibrary(lib.value(), lib.dependsOn());
                continue;
            }
            this.addDynamicNonJniLibrary(lib.value());
        }
        this.annotated.clear();
        return true;
    }

    public List<String> getJniStaticLibraries() {
        return this.jniStaticLibraries;
    }

    public static final class DependencyGraph {
        private final Map<String, Dependency> allDependencies = new ConcurrentHashMap<String, Dependency>();

        public void add(String library, Collection<String> dependencies) {
            UserError.guarantee(library != null, "The library name must be not null and not empty", new Object[0]);
            Dependency libraryDependency = this.putWhenAbsent(library, new Dependency(library, ConcurrentHashMap.newKeySet()));
            Set<Dependency> collectedDependencies = libraryDependency.getDependencies();
            for (String dependency : dependencies) {
                collectedDependencies.add(this.putWhenAbsent(dependency, new Dependency(dependency, ConcurrentHashMap.newKeySet())));
            }
        }

        public List<String> sort() {
            HashSet<Dependency> discovered = new HashSet<Dependency>();
            LinkedHashSet<Dependency> processed = new LinkedHashSet<Dependency>();
            for (Dependency dep : this.allDependencies.values()) {
                this.visit(dep, discovered, processed);
            }
            LinkedList<String> names = new LinkedList<String>();
            processed.forEach(n -> names.push(n.getName()));
            return names;
        }

        private Dependency putWhenAbsent(String libName, Dependency dep) {
            if (!this.allDependencies.containsKey(libName)) {
                this.allDependencies.put(libName, dep);
            }
            return this.allDependencies.get(libName);
        }

        private void visit(Dependency dep, Set<Dependency> discovered, Set<Dependency> processed) {
            if (processed.contains(dep)) {
                return;
            }
            if (discovered.contains(dep)) {
                UserError.abort("While building list of static libraries dependencies a cycle was discovered for dependency: %s ", dep.getName());
            }
            discovered.add(dep);
            dep.getDependencies().forEach(d -> this.visit((Dependency)d, discovered, processed));
            processed.add(dep);
        }

        public String toString() {
            String depsStr = this.allDependencies.values().stream().map(Dependency::toString).collect(Collectors.joining("\n"));
            return "DependencyGraph{\n" + depsStr + "}";
        }

        private static final class Dependency {
            private final String name;
            private final Set<Dependency> dependencies;

            Dependency(String name, Set<Dependency> dependencies) {
                assert (dependencies != null);
                this.name = name;
                this.dependencies = dependencies;
            }

            public String getName() {
                return this.name;
            }

            public Set<Dependency> getDependencies() {
                return this.dependencies;
            }

            public String toString() {
                String depString = this.dependencies.stream().map(Dependency::getName).collect(Collectors.joining());
                return "Dependency{name='" + this.name + "', dependencies=[" + depString + "]}";
            }
        }
    }
}

