/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.CustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.DynamicHubInitializer;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.SubstrateUnsupportedFeatures;
import com.oracle.svm.hosted.analysis.UserLimitationsChecker;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.util.concurrent.ForkJoinPool;
import org.graalvm.compiler.options.OptionValues;

public class NativeImageReachabilityAnalysisEngine
extends ReachabilityAnalysisEngine
implements Inflation {
    private final AnnotationSubstitutionProcessor annotationSubstitutionProcessor;
    private final DynamicHubInitializer dynamicHubInitializer;
    private final boolean strengthenGraalGraphs;
    private final CustomTypeFieldHandler unknownFieldHandler;

    public NativeImageReachabilityAnalysisEngine(OptionValues options, AnalysisUniverse universe, HostedProviders providers, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ForkJoinPool executor, Runnable heartbeatCallback, TimerCollection timerCollection, ReachabilityMethodProcessingHandler reachabilityMethodProcessingHandler) {
        super(options, universe, providers, universe.hostVM(), executor, heartbeatCallback, new SubstrateUnsupportedFeatures(), timerCollection, reachabilityMethodProcessingHandler);
        this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        this.strengthenGraalGraphs = SubstrateOptions.parseOnce();
        this.dynamicHubInitializer = new DynamicHubInitializer(this);
        this.unknownFieldHandler = new CustomTypeFieldHandler(this, this.metaAccess){

            @Override
            protected void injectFieldTypes(AnalysisField aField, AnalysisType ... declaredTypes) {
                NativeImageReachabilityAnalysisEngine.this.markFieldAccessed(aField);
                for (AnalysisType declaredType : declaredTypes) {
                    NativeImageReachabilityAnalysisEngine.this.markTypeReachable(declaredType);
                }
            }
        };
    }

    public boolean strengthenGraalGraphs() {
        return this.strengthenGraalGraphs;
    }

    @Override
    public AnnotationSubstitutionProcessor getAnnotationSubstitutionProcessor() {
        return this.annotationSubstitutionProcessor;
    }

    public void onFieldAccessed(AnalysisField field) {
        this.unknownFieldHandler.handleField(field);
    }

    public void onTypeInitialized(AnalysisType type) {
        this.postTask(d -> this.initializeMetaData(type));
    }

    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.unknownFieldHandler.cleanupAfterAnalysis();
    }

    @Override
    public SubstrateReplacements getReplacements() {
        return (SubstrateReplacements)super.getReplacements();
    }

    @Override
    public SVMHost getHostVM() {
        return (SVMHost)this.hostVM;
    }

    public void checkUserLimitations() {
        UserLimitationsChecker.check(this);
    }

    public void initializeMetaData(AnalysisType type) {
        this.dynamicHubInitializer.initializeMetaData(this.universe.getHeapScanner(), type);
    }
}

