/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;

public class NativeImageSystemIOWrappers {
    final StdioWrapper outWrapper = new StdioWrapper(System.out);
    final StdioWrapper errWrapper = new StdioWrapper(System.err);
    ProgressReporter progressReporter = null;

    NativeImageSystemIOWrappers() {
    }

    void verifySystemOutErrReplacement() {
        String format = "%s was changed during image building. This is not allowed.";
        UserError.guarantee(System.out == this.outWrapper, format, "System.out");
        UserError.guarantee(System.err == this.errWrapper, format, "System.err");
    }

    void replaceSystemOutErr() {
        System.setOut(this.outWrapper);
        System.setErr(this.errWrapper);
    }

    public static NativeImageSystemIOWrappers singleton() {
        return NativeImageSystemClassLoader.singleton().systemIOWrappers;
    }

    public static NativeImageSystemIOWrappers disabled() {
        return new NativeImageSystemIOWrappersDisabled();
    }

    public PrintStream getOut() {
        return this.outWrapper.delegate;
    }

    public void setOut(PrintStream customOut) {
        this.outWrapper.delegate = Objects.requireNonNull(customOut);
    }

    public PrintStream getErr() {
        return this.errWrapper.delegate;
    }

    public void setErr(PrintStream customErr) {
        this.errWrapper.delegate = Objects.requireNonNull(customErr);
    }

    private static class NativeImageSystemIOWrappersDisabled
    extends NativeImageSystemIOWrappers {
        private static final PrintStream NULL_PRINT_STREAM = new PrintStream(OutputStream.nullOutputStream());

        private NativeImageSystemIOWrappersDisabled() {
        }

        @Override
        public PrintStream getOut() {
            return NULL_PRINT_STREAM;
        }

        @Override
        public PrintStream getErr() {
            return NULL_PRINT_STREAM;
        }
    }

    private final class StdioWrapper
    extends PrintStream {
        private PrintStream delegate;

        private StdioWrapper(PrintStream delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void write(int b) {
            this.maybeInformProgressReporterOnce();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.maybeInformProgressReporterOnce();
            this.delegate.write(buf, off, len);
        }

        private void maybeInformProgressReporterOnce() {
            if (NativeImageSystemIOWrappers.this.progressReporter != null) {
                NativeImageSystemIOWrappers.this.progressReporter.beforeNextStdioWrite();
                NativeImageSystemIOWrappers.this.progressReporter = null;
            }
        }
    }
}

