/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import java.io.File;
import java.lang.module.ModuleFinder;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;

public final class LinkAtBuildTimeSupport {
    private final String javaIdentifier = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private final Pattern validOptionValue = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
    private final Set<OptionOrigin> reasonCommandLine = Collections.singleton(OptionOrigin.commandLineOptionOriginSingleton);
    private final Map<String, Set<OptionOrigin>> requireCompletePackageOrClass = new HashMap<String, Set<OptionOrigin>>();
    private final Set<Module> requireCompleteModules = new HashSet<Module>();
    private boolean requireCompleteAll;
    private final ClassLoaderSupport classLoaderSupport;
    private final ImageClassLoader imageClassLoader;
    private final Map<URI, Module> uriModuleMap;

    LinkAtBuildTimeSupport(ImageClassLoader imageClassLoader, ClassLoaderSupport classLoaderSupport) {
        this.classLoaderSupport = classLoaderSupport;
        this.imageClassLoader = imageClassLoader;
        this.uriModuleMap = ModuleFinder.of((Path[])imageClassLoader.applicationModulePath().toArray(Path[]::new)).findAll().stream().filter(mRef -> mRef.location().isPresent()).collect(Collectors.toUnmodifiableMap(mRef -> mRef.location().get(), mRef -> imageClassLoader.findModule(mRef.descriptor().name()).get()));
        this.requireCompletePackageOrClass.put("jdk.internal.reflect", null);
        Options.LinkAtBuildTime.getValue().getValuesWithOrigins().forEach(this::extractLinkAtBuildTimeOptionValue);
        Options.LinkAtBuildTimePaths.getValue().getValuesWithOrigins().forEach(this::extractLinkAtBuildTimePathsOptionValue);
    }

    public static LinkAtBuildTimeSupport singleton() {
        return (LinkAtBuildTimeSupport)ImageSingletons.lookup(LinkAtBuildTimeSupport.class);
    }

    private void extractLinkAtBuildTimeOptionValue(Pair<String, OptionOrigin> valueOrigin) {
        String value = (String)valueOrigin.getLeft();
        OptionOrigin origin = (OptionOrigin)valueOrigin.getRight();
        URI container = origin.container();
        if (value.isEmpty()) {
            if (origin.commandLineLike()) {
                this.requireCompleteAll = true;
                return;
            }
            Module originModule = this.uriModuleMap.get(container);
            if (originModule != null) {
                this.requireCompleteModules.add(originModule);
                return;
            }
            throw UserError.abort("Using '%s' without args only allowed on module-path. %s not part of module-path.", SubstrateOptionsParser.commandArgument(Options.LinkAtBuildTime, value), origin);
        }
        for (String entry : OptionUtils.resolveOptionValuesRedirection(Options.LinkAtBuildTime, value, origin)) {
            if (this.validOptionValue.matcher(entry).matches()) {
                if (!(origin.commandLineLike() || this.imageClassLoader.classes(container).contains((Object)entry) || this.imageClassLoader.packages(container).contains((Object)entry))) {
                    throw UserError.abort("Option '%s' provided by %s contains '%s'. No such package or class name found in '%s'.", SubstrateOptionsParser.commandArgument(Options.LinkAtBuildTime, value), origin, entry, container);
                }
                this.requireCompletePackageOrClass.computeIfAbsent(entry, unused -> new HashSet()).add(origin);
                continue;
            }
            throw UserError.abort("Entry '%s' in option '%s' provided by %s is neither a package nor a fully qualified classname.", entry, SubstrateOptionsParser.commandArgument(Options.LinkAtBuildTime, value), origin);
        }
    }

    private void extractLinkAtBuildTimePathsOptionValue(Pair<String, OptionOrigin> valueOrigin) {
        String value = (String)valueOrigin.getLeft();
        OptionOrigin origin = (OptionOrigin)valueOrigin.getRight();
        if (!origin.commandLineLike()) {
            throw UserError.abort("Using '%s' is only allowed on command line.", SubstrateOptionsParser.commandArgument(Options.LinkAtBuildTimePaths, value), origin);
        }
        if (value.isEmpty()) {
            throw UserError.abort("Using '%s' requires directory or jar-file path arguments.", SubstrateOptionsParser.commandArgument(Options.LinkAtBuildTimePaths, value), origin);
        }
        for (String pathStr : SubstrateUtil.split(value, File.pathSeparator)) {
            Path path = Path.of(pathStr, new String[0]);
            EconomicSet<String> packages = this.imageClassLoader.packages(path.toAbsolutePath().normalize().toUri());
            if (this.imageClassLoader.noEntryForURI(packages)) {
                throw UserError.abort("Option '%s' provided by %s contains entry '%s'. No such entry exists on class or module-path.", SubstrateOptionsParser.commandArgument(Options.LinkAtBuildTimePaths, value), origin, pathStr);
            }
            for (String pkg : packages) {
                this.requireCompletePackageOrClass.put(pkg, Collections.singleton(origin));
            }
        }
    }

    public boolean linkAtBuildTime(ResolvedJavaType type) {
        Class clazz = ((OriginalClassProvider)type).getJavaClass();
        if (clazz == null) {
            return true;
        }
        return this.linkAtBuildTime(clazz);
    }

    public boolean linkAtBuildTime(Class<?> clazz) {
        return this.linkAtBuildTimeImpl(clazz) != null;
    }

    private Object linkAtBuildTimeImpl(Class<?> clazz) {
        if (this.requireCompleteAll) {
            return this.reasonCommandLine;
        }
        if (clazz.isArray() || !this.classLoaderSupport.isNativeImageClassLoader(clazz.getClassLoader())) {
            return "system default";
        }
        assert (!clazz.isPrimitive()) : "Primitive classes are not loaded via NativeImageClassLoader";
        Module module = clazz.getModule();
        if (module.isNamed() && this.requireCompleteModules.contains(module)) {
            return module.toString();
        }
        Set<OptionOrigin> origins = this.requireCompletePackageOrClass.get(clazz.getName());
        if (origins != null) {
            return origins;
        }
        return this.requireCompletePackageOrClass.get(clazz.getPackageName());
    }

    public String errorMessageFor(ResolvedJavaType type) {
        Class clazz = ((OriginalClassProvider)type).getJavaClass();
        if (clazz == null) {
            return "This error is reported at image build time because class " + type.toJavaName(true) + " is registered for linking at image build time.";
        }
        return this.errorMessageFor(clazz);
    }

    public String errorMessageFor(Class<?> clazz) {
        assert (this.linkAtBuildTime(clazz));
        return "This error is reported at image build time because class " + clazz.getTypeName() + " is registered for linking at image build time by " + this.linkAtBuildTimeReason(clazz);
    }

    private String linkAtBuildTimeReason(Class<?> clazz) {
        Object reason = this.linkAtBuildTimeImpl(clazz);
        if (reason == null) {
            return null;
        }
        if (reason instanceof String) {
            return (String)reason;
        }
        Set origins = (Set)reason;
        return origins.stream().map(Object::toString).collect(Collectors.joining(" and "));
    }

    static final class Options {
        @APIOption(name={"link-at-build-time"}, defaultValue={""})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LinkAtBuildTime = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @APIOption(name={"link-at-build-time-paths"})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LinkAtBuildTimePaths = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());

        Options() {
        }
    }
}

