/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.LocatableOption;
import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.collections.Pair;

public abstract class LocatableMultiOptionValue<T>
implements MultiOptionValue<T> {
    private final Class<T> valueType;
    private final List<Pair<T, String>> values;

    private LocatableMultiOptionValue(Class<T> valueType) {
        this.valueType = valueType;
        this.values = new ArrayList<Pair<T, String>>();
    }

    private LocatableMultiOptionValue(Class<T> valueType, List<T> defaults) {
        this(valueType);
        this.values.addAll(defaults.stream().map(val -> Pair.create((Object)val, (Object)"default")).collect(Collectors.toList()));
    }

    private LocatableMultiOptionValue(LocatableMultiOptionValue<T> other) {
        this.valueType = other.valueType;
        this.values = new ArrayList<Pair<T, String>>(other.values);
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public void valueUpdate(Object value) {
        Object rawValue = LocatableOption.rawValue((Object)value);
        String origin = LocatableOption.valueOrigin((Object)value);
        if (!this.valueType.isInstance(rawValue)) {
            VMError.shouldNotReachHere("Cannot update LocatableMultiOptionValue of type " + this.valueType + " with value of type " + rawValue.getClass());
        }
        this.values.add(Pair.create(this.valueType.cast(rawValue), (Object)origin));
    }

    public List<T> values() {
        if (this.values.isEmpty()) {
            return Collections.emptyList();
        }
        return this.values.stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    public Stream<Pair<T, OptionOrigin>> getValuesWithOrigins() {
        if (this.values.isEmpty()) {
            return Stream.empty();
        }
        return this.values.stream().map(pair -> Pair.create((Object)pair.getLeft(), (Object)OptionOrigin.from((String)pair.getRight())));
    }

    public String toString() {
        return "<" + ClassUtil.getUnqualifiedName(this.valueType).toLowerCase() + ">*";
    }

    public static class Strings
    extends LocatableMultiOptionValue<String> {
        private Strings(Strings other) {
            super(other);
        }

        public MultiOptionValue<String> createCopy() {
            return new Strings(this);
        }

        public Strings() {
            super(String.class);
        }

        public Strings(List<String> defaultStrings) {
            super(String.class, defaultStrings);
        }
    }
}

