/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class LayoutEncoding {
    private static final int NEUTRAL_VALUE = 0;
    private static final int PRIMITIVE_VALUE = 1;
    private static final int INTERFACE_VALUE = 2;
    private static final int ABSTRACT_VALUE = 3;
    private static final int LAST_SPECIAL_VALUE = 3;
    private static final int ARRAY_INDEX_SHIFT_SHIFT = 0;
    private static final int ARRAY_INDEX_SHIFT_MASK = 255;
    private static final int ARRAY_BASE_SHIFT = 8;
    private static final int ARRAY_BASE_MASK = 4095;
    private static final int ARRAY_TAG_BITS = 3;
    private static final int ARRAY_TAG_SHIFT = 29;
    private static final int ARRAY_TAG_IDENTITY_BIT = 4;
    private static final int ARRAY_TAG_PRIMITIVE_BIT = 2;
    private static final int ARRAY_TAG_PURE_BIT = 1;
    private static final int ARRAY_TAG_PRIMITIVE_VALUE = 7;
    private static final int ARRAY_TAG_HYBRID_PRIMITIVE_VALUE = 6;
    private static final int ARRAY_TAG_OBJECT_VALUE = 5;
    private static final int ARRAY_TAG_HYBRID_OBJECT_VALUE = 4;

    public static int forPrimitive() {
        return 1;
    }

    public static int forInterface() {
        return 2;
    }

    public static int forAbstract() {
        return 3;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void guaranteeEncoding(ResolvedJavaType type, boolean expected, boolean actual, String description) {
        if (actual != expected) {
            throw VMError.shouldNotReachHere(description + ": expected to be " + expected + ". This error is caused by an incorrect compact encoding of a type (a class, array or a primitive). The error occurred with the following type, but also could be caused by characteristics of the overall type hierarchy: " + type + ". Please report this problem and the conditions in which it occurs and include any noteworthy characteristics of the type hierarchy and architecture of the application and the libraries and frameworks it uses.");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forPureInstance(ResolvedJavaType type, int size) {
        LayoutEncoding.guaranteeEncoding(type, true, size > 3, "Instance type size must be above special values for encoding: " + size);
        int encoding = size;
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.isPureInstance(encoding), "Instance type encoding denotes an instance");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isArray(encoding) || LayoutEncoding.isArrayLike(encoding), "Instance type encoding denotes an array-like object");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isHybrid(encoding), "Instance type encoding denotes a hybrid");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isObjectArray(encoding) || LayoutEncoding.isArrayLikeWithObjectElements(encoding), "Instance type encoding denotes an object array");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isPrimitiveArray(encoding) || LayoutEncoding.isArrayLikeWithPrimitiveElements(encoding), "Instance type encoding denotes a primitive array");
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.getPureInstanceSize(encoding).equal(WordFactory.unsigned((int)size)), "Instance type encoding size matches type size");
        return encoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forArray(ResolvedJavaType type, boolean objectElements, int arrayBaseOffset, int arrayIndexShift) {
        return LayoutEncoding.forArrayLike(type, false, objectElements, arrayBaseOffset, arrayIndexShift);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forHybrid(ResolvedJavaType type, boolean objectElements, int arrayBaseOffset, int arrayIndexShift) {
        return LayoutEncoding.forArrayLike(type, true, objectElements, arrayBaseOffset, arrayIndexShift);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int forArrayLike(ResolvedJavaType type, boolean isHybrid, boolean objectElements, int arrayBaseOffset, int arrayIndexShift) {
        assert (isHybrid != type.isArray());
        int tag = isHybrid ? (objectElements ? 4 : 6) : (objectElements ? 5 : 7);
        int encoding = tag << 29 | arrayBaseOffset << 8 | arrayIndexShift << 0;
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.isArrayLike(encoding), "Array-like object encoding denotes an array-like object");
        LayoutEncoding.guaranteeEncoding(type, !isHybrid, LayoutEncoding.isArray(encoding), "Encoding denotes an array");
        LayoutEncoding.guaranteeEncoding(type, isHybrid, LayoutEncoding.isHybrid(encoding), "Encoding denotes a hybrid");
        LayoutEncoding.guaranteeEncoding(type, false, LayoutEncoding.isPureInstance(encoding), "Array-like object encoding denotes an instance type");
        LayoutEncoding.guaranteeEncoding(type, objectElements, LayoutEncoding.isArrayLikeWithObjectElements(encoding), "Encoding denotes an array-like object with object elements");
        LayoutEncoding.guaranteeEncoding(type, !objectElements, LayoutEncoding.isArrayLikeWithPrimitiveElements(encoding), "Encoding denotes an array-like object with primitive elements");
        LayoutEncoding.guaranteeEncoding(type, !isHybrid && objectElements, LayoutEncoding.isObjectArray(encoding), "Encoding denotes an object array");
        LayoutEncoding.guaranteeEncoding(type, !isHybrid && !objectElements, LayoutEncoding.isPrimitiveArray(encoding), "Encoding denotes a primitive array");
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.getArrayBaseOffset(encoding).equal(WordFactory.unsigned((int)arrayBaseOffset)), "Encoding denotes a base offset of " + arrayBaseOffset + " (actual value: " + LayoutEncoding.getArrayBaseOffset(encoding) + ")");
        LayoutEncoding.guaranteeEncoding(type, true, LayoutEncoding.getArrayIndexShift(encoding) == arrayIndexShift, "Encoding denotes an index shift of " + arrayIndexShift + " (actual value: " + LayoutEncoding.getArrayIndexShift(encoding) + ")");
        return encoding;
    }

    public static boolean isPrimitive(int encoding) {
        return encoding == 1;
    }

    public static boolean isInterface(int encoding) {
        return encoding == 2;
    }

    public static boolean isAbstract(int encoding) {
        return encoding == 3;
    }

    public static boolean isSpecial(int encoding) {
        return encoding >= 0 && encoding <= 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isPureInstance(int encoding) {
        return encoding > 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getPureInstanceSize(int encoding) {
        return WordFactory.unsigned((int)encoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArray(int encoding) {
        int mask = -1610612736;
        return (encoding & mask) == mask;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArrayLike(int encoding) {
        return encoding < 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isHybrid(int encoding) {
        int setBits = Integer.MIN_VALUE;
        int mask = setBits | 0x20000000;
        return (encoding & mask) == setBits;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isPrimitiveArray(int encoding) {
        return UnsignedMath.aboveOrEqual((int)encoding, (int)-536870912);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isObjectArray(int encoding) {
        return encoding >>> 29 == 5;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArrayLikeWithPrimitiveElements(int encoding) {
        return UnsignedMath.aboveOrEqual((int)encoding, (int)-1073741824);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArrayLikeWithObjectElements(int encoding) {
        return encoding <= -1073741825;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getArrayBaseOffsetAsInt(int encoding) {
        return encoding >> 8 & 0xFFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayBaseOffset(int encoding) {
        return WordFactory.unsigned((int)LayoutEncoding.getArrayBaseOffsetAsInt(encoding));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getArrayIndexShift(int encoding) {
        return encoding >> 0 & 0xFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getArrayIndexScale(int encoding) {
        return 1 << LayoutEncoding.getArrayIndexShift(encoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayElementOffset(int encoding, int index) {
        return LayoutEncoding.getArrayBaseOffset(encoding).add(WordFactory.unsigned((int)index).shiftLeft(LayoutEncoding.getArrayIndexShift(encoding)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArraySize(int encoding, int length) {
        int alignmentMask = LayoutEncoding.getAlignmentMask();
        return LayoutEncoding.getArrayElementOffset(encoding, length).add(alignmentMask).and(~alignmentMask);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getSizeFromObject(Object obj) {
        return LayoutEncoding.getSizeFromObjectInline(obj);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getSizeFromObjectInline(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        if (LayoutEncoding.isArrayLike(encoding)) {
            return LayoutEncoding.getArraySize(encoding, ArrayLengthNode.arrayLength((Object)obj));
        }
        return LayoutEncoding.getPureInstanceSize(encoding);
    }

    public static Pointer getObjectEnd(Object obj) {
        return LayoutEncoding.getObjectEndInline(obj);
    }

    @AlwaysInline(value="GC performance")
    public static Pointer getObjectEndInline(Object obj) {
        Word objStart = Word.objectToUntrackedPointer((Object)obj);
        UnsignedWord objSize = LayoutEncoding.getSizeFromObjectInline(obj);
        return objStart.add(objSize);
    }

    public static boolean isArray(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isArray(encoding);
    }

    public static boolean isArrayLike(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isArrayLike(encoding);
    }

    @Fold
    protected static int getAlignmentMask() {
        return ((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getAlignment() - 1;
    }
}

