/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.headers;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibCSupport;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

public class LibC {
    public static final int EXIT_CODE_ABORT = 99;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int errno() {
        return LibC.libc().errno();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setErrno(int value) {
        LibC.libc().setErrno(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T memcpy(T dest, PointerBase src, UnsignedWord n) {
        return LibC.libc().memcpy(dest, src, n);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T memmove(T dest, PointerBase src, UnsignedWord n) {
        return LibC.libc().memmove(dest, src, n);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T memset(T s, SignedWord c, UnsignedWord n) {
        return LibC.libc().memset(s, c, n);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T malloc(UnsignedWord size) {
        return LibC.libc().malloc(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T calloc(UnsignedWord nmemb, UnsignedWord size) {
        return LibC.libc().calloc(nmemb, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T realloc(PointerBase ptr, UnsignedWord size) {
        return LibC.libc().realloc(ptr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(PointerBase ptr) {
        LibC.libc().free(ptr);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void exit(int status) {
        LibC.libc().exit(status);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void abort() {
        LibC.exit(99);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord strlen(CCharPointer str) {
        return LibC.libc().strlen(str);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int strcmp(CCharPointer s1, CCharPointer s2) {
        return LibC.libc().strcmp(s1, s2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int isdigit(int c) {
        return LibC.libc().isdigit(c);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord strtoull(CCharPointer string, CCharPointerPointer endPtr, int base) {
        return LibC.libc().strtoull(string, endPtr, base);
    }

    @Fold
    public static boolean isSupported() {
        return ImageSingletons.contains(LibCSupport.class);
    }

    @Fold
    static LibCSupport libc() {
        return (LibCSupport)ImageSingletons.lookup(LibCSupport.class);
    }
}

