/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.WordBase;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class StackValueNode
extends AbstractStateSplit
implements LIRLowerable,
IterableNodeType {
    public static final NodeClass<StackValueNode> TYPE = NodeClass.create(StackValueNode.class);
    private static final int MAX_SIZE = 0xA00000;
    protected final int sizeInBytes;
    protected final int alignmentInBytes;
    protected final StackSlotIdentity slotIdentity;
    private int recursionDepth;
    protected StackSlotHolder stackSlotHolder;

    public static ValueNode create(long numElements, long elementSize, GraphBuilderContext b) {
        if (UnsignedMath.aboveOrEqual((long)numElements, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)elementSize, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)(numElements * elementSize), (long)0xA00000L)) {
            throw new PermanentBailoutException("stack value has illegal size " + numElements + " * " + elementSize);
        }
        int sizeInBytes = NumUtil.safeToInt((long)(numElements * elementSize));
        return StackValueNode.create(sizeInBytes, b.getGraph().method(), b.bci());
    }

    public static StackValueNode create(int sizeInBytes, ResolvedJavaMethod method, int bci) {
        String name = method.asStackTraceElement(bci).toString();
        if (UnsignedMath.aboveOrEqual((int)sizeInBytes, (int)0xA00000)) {
            throw new PermanentBailoutException("stack value has illegal size " + sizeInBytes + ": " + name);
        }
        int alignmentInBytes = ConfigurationValues.getTarget().stackAlignment;
        StackSlotIdentity slotIdentity = new StackSlotIdentity(name, false);
        return new StackValueNode(sizeInBytes, alignmentInBytes, slotIdentity);
    }

    protected StackValueNode(int sizeInBytes, int alignmentInBytes, StackSlotIdentity slotIdentity) {
        super(TYPE, FrameAccess.getWordStamp());
        this.sizeInBytes = sizeInBytes;
        this.alignmentInBytes = alignmentInBytes;
        this.slotIdentity = slotIdentity;
        this.recursionDepth = slotIdentity.shared ? 0 : -1;
    }

    int getRecursionDepth() {
        assert (this.recursionDepth >= 0);
        return this.recursionDepth;
    }

    void setRecursionDepth(int value) {
        this.recursionDepth = value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        assert (this.stackSlotHolder != null) : "node not processed by StackValuePhase";
        assert (this.stackSlotHolder.gen == null || this.stackSlotHolder.gen == gen) : "Same stack slot holder used during multiple compilations, therefore caching a wrong value";
        this.stackSlotHolder.gen = gen;
        if (this.sizeInBytes == 0) {
            gen.setResult((ValueNode)this, (Value)new ConstantValue((ValueKind)gen.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (Constant)JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)0L)));
        } else {
            VirtualStackSlot slot = this.stackSlotHolder.slot;
            if (slot == null) {
                this.stackSlotHolder.slot = slot = gen.getLIRGeneratorTool().allocateStackMemory(this.sizeInBytes, this.alignmentInBytes);
            }
            gen.setResult((ValueNode)this, (Value)gen.getLIRGeneratorTool().emitAddress((AllocatableValue)slot));
        }
    }

    @Node.NodeIntrinsic
    public static native WordBase stackValue(@Node.ConstantNodeParameter int var0, @Node.ConstantNodeParameter int var1, @Node.ConstantNodeParameter StackSlotIdentity var2);

    protected static class StackSlotHolder {
        protected VirtualStackSlot slot;
        protected NodeLIRBuilderTool gen;

        protected StackSlotHolder() {
        }
    }

    public static class StackSlotIdentity {
        protected final boolean shared;
        protected final String name;

        public StackSlotIdentity(String name, boolean shared) {
            this.name = name;
            this.shared = shared;
        }

        public String toString() {
            return this.name;
        }
    }
}

