/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.jvmstat;

import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapAccounting;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.jvmstat.PerfDataHolder;
import com.oracle.svm.core.jvmstat.PerfLongConstant;
import com.oracle.svm.core.jvmstat.PerfLongCounter;
import com.oracle.svm.core.jvmstat.PerfLongVariable;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfStringConstant;
import com.oracle.svm.core.jvmstat.PerfUnit;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SerialGCPerfData
implements PerfDataHolder {
    private final PerfDataGCPolicy gcPolicy = new PerfDataGCPolicy();
    private final PerfDataCollector youngCollector = new PerfDataCollector(0);
    private final PerfDataCollector oldCollector = new PerfDataCollector(1);
    private final PerfDataGeneration youngGen;
    private final PerfDataGeneration oldGen;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SerialGCPerfData() {
        int youngSpaceCount = 1 + HeapParameters.getMaxSurvivorSpaces();
        SpacePerfData[] youngGenSpaces = new SpacePerfData[youngSpaceCount];
        for (int i = 0; i < youngSpaceCount; ++i) {
            youngGenSpaces[i] = new SpacePerfData(0, i);
        }
        this.youngGen = new PerfDataGeneration(0, youngGenSpaces);
        int oldSpaceIndex = youngSpaceCount;
        SpacePerfData[] oldGenSpaces = new SpacePerfData[]{new SpacePerfData(1, oldSpaceIndex)};
        this.oldGen = new PerfDataGeneration(1, oldGenSpaces);
    }

    @Override
    public void allocate() {
        this.gcPolicy.allocate();
        this.youngCollector.allocate("Serial young collection pauses");
        this.oldCollector.allocate("Serial full collection pauses");
        this.youngGen.allocate("young");
        this.youngGen.spaces[0].allocate("eden");
        for (int i = 1; i < this.youngGen.spaces.length; ++i) {
            this.youngGen.spaces[i].allocate("s" + (i - 1));
        }
        this.oldGen.allocate("old");
        this.oldGen.spaces[0].allocate("old");
        assert (this.oldGen.spaces.length == 1);
    }

    @Override
    public void update() {
        GCAccounting accounting = GCImpl.getGCImpl().getAccounting();
        HeapAccounting heapAccounting = HeapImpl.getHeapImpl().getAccounting();
        long maxNewSize = GCImpl.getPolicy().getMaximumYoungGenerationSize().rawValue();
        this.youngCollector.invocations.setValue(accounting.getIncrementalCollectionCount());
        this.youngCollector.time.setValue(accounting.getIncrementalCollectionTotalNanos());
        this.youngGen.capacity.setValue(heapAccounting.getYoungUsedBytes().rawValue());
        this.youngGen.maxCapacity.setValue(maxNewSize);
        this.youngGen.spaces[0].used.setValue(heapAccounting.getEdenUsedBytes().rawValue());
        for (int i = 1; i < this.youngGen.spaces.length; ++i) {
            this.youngGen.spaces[i].used.setValue(heapAccounting.getSurvivorSpaceAfterChunkBytes(i - 1).rawValue());
        }
        long maxOldSize = GCImpl.getPolicy().getMaximumHeapSize().rawValue() - maxNewSize;
        this.oldCollector.invocations.setValue(accounting.getCompleteCollectionCount());
        this.oldCollector.time.setValue(accounting.getCompleteCollectionTotalNanos());
        this.oldGen.capacity.setValue(accounting.getOldGenerationAfterChunkBytes().rawValue());
        this.oldGen.maxCapacity.setValue(maxOldSize);
        this.oldGen.spaces[0].used.setValue(accounting.getOldGenerationAfterChunkBytes().rawValue());
    }

    static class SpacePerfData {
        private final PerfStringConstant name;
        final PerfLongVariable used;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        SpacePerfData(int generationIndex, int spaceIndex) {
            PerfManager manager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.name = manager.createStringConstant("sun.gc.generation." + generationIndex + ".space." + spaceIndex + ".name");
            this.used = manager.createLongVariable("sun.gc.generation." + generationIndex + ".space." + spaceIndex + ".used", PerfUnit.BYTES);
        }

        public void allocate(String spaceName) {
            this.name.allocate(spaceName);
            this.used.allocate();
        }
    }

    static class PerfDataGeneration {
        private final PerfStringConstant name;
        private final PerfLongConstant numSpaces;
        final PerfLongVariable capacity;
        final PerfLongVariable maxCapacity;
        private final SpacePerfData[] spaces;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        PerfDataGeneration(int generationIndex, SpacePerfData[] spaces) {
            PerfManager manager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.name = manager.createStringConstant("sun.gc.generation." + generationIndex + ".name");
            this.numSpaces = manager.createLongConstant("sun.gc.generation." + generationIndex + ".spaces", PerfUnit.NONE);
            this.capacity = manager.createLongVariable("sun.gc.generation." + generationIndex + ".capacity", PerfUnit.BYTES);
            this.maxCapacity = manager.createLongVariable("sun.gc.generation." + generationIndex + ".maxCapacity", PerfUnit.BYTES);
            this.spaces = spaces;
        }

        public void allocate(String generationName) {
            this.name.allocate(generationName);
            this.numSpaces.allocate(this.spaces.length);
            this.capacity.allocate();
            this.maxCapacity.allocate();
        }
    }

    private static class PerfDataCollector {
        private final PerfStringConstant name;
        private final PerfLongCounter invocations;
        private final PerfLongCounter time;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        PerfDataCollector(int index) {
            PerfManager manager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.name = manager.createStringConstant("sun.gc.collector." + index + ".name");
            this.invocations = manager.createLongCounter("sun.gc.collector." + index + ".invocations", PerfUnit.EVENTS);
            this.time = manager.createLongCounter("sun.gc.collector." + index + ".time", PerfUnit.TICKS);
        }

        public void allocate(String collectorName) {
            this.name.allocate(collectorName);
            this.invocations.allocate();
            this.time.allocate();
        }
    }

    private static class PerfDataGCPolicy {
        private final PerfLongConstant collectors;
        private final PerfLongConstant generations;
        private final PerfStringConstant name;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        PerfDataGCPolicy() {
            PerfManager manager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.collectors = manager.createLongConstant("sun.gc.policy.collectors", PerfUnit.NONE);
            this.generations = manager.createLongConstant("sun.gc.policy.generations", PerfUnit.NONE);
            this.name = manager.createStringConstant("sun.gc.policy.name");
        }

        public void allocate() {
            this.collectors.allocate(1L);
            this.generations.allocate(2L);
            this.name.allocate(GCImpl.getPolicy().getName());
        }
    }
}

