/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTableCounters;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class CodeInfoTable {
    private static CodeInfo imageCodeInfo;

    @Fold
    public static ImageCodeInfo getImageCodeCache() {
        return (ImageCodeInfo)ImageSingletons.lookup(ImageCodeInfo.class);
    }

    @Fold
    public static RuntimeCodeCache getRuntimeCodeCache() {
        return (RuntimeCodeCache)ImageSingletons.lookup(RuntimeCodeCache.class);
    }

    @Uninterruptible(reason="Executes during isolate creation.")
    public static void prepareImageCodeInfo() {
        imageCodeInfo = CodeInfoTable.getImageCodeCache().prepareCodeInfo();
        assert (imageCodeInfo.notEqual((ComparableWord)WordFactory.zero()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CodeInfo getImageCodeInfo() {
        assert (imageCodeInfo.notEqual((ComparableWord)WordFactory.zero())) : "uninitialized";
        return imageCodeInfo;
    }

    public static CodeInfoQueryResult lookupCodeInfoQueryResult(CodeInfo info, CodePointer absoluteIP) {
        CodeInfoTable.counters().lookupCodeInfoCount.inc();
        if (info.isNull()) {
            return null;
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        result.ip = absoluteIP;
        CodeInfoAccess.lookupCodeInfo(info, CodeInfoAccess.relativeIP(info, absoluteIP), result);
        return result;
    }

    public static CodeInfoQueryResult lookupDeoptimizationEntrypoint(int deoptOffsetInImage, long encodedBci) {
        CodeInfoTable.counters().lookupDeoptimizationEntrypointCount.inc();
        CodeInfo info = CodeInfoTable.getImageCodeInfo();
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = CodeInfoAccess.lookupDeoptimizationEntrypoint(info, deoptOffsetInImage, encodedBci, result);
        if (relativeIP < 0L) {
            return null;
        }
        result.ip = CodeInfoAccess.absoluteIP(info, relativeIP);
        return result;
    }

    public static boolean visitObjectReferences(Pointer sp, CodePointer ip, CodeInfo info, DeoptimizedFrame deoptimizedFrame, ObjectReferenceVisitor visitor) {
        CodeInfoTable.counters().visitObjectReferencesCount.inc();
        if (deoptimizedFrame != null) {
            return true;
        }
        Object referenceMapEncoding = NonmovableArrays.nullArray();
        long referenceMapIndex = -1L;
        if (info.isNonNull()) {
            referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(info);
            referenceMapIndex = CodeInfoAccess.lookupStackReferenceMapIndex(info, CodeInfoAccess.relativeIP(info, ip));
        }
        if (referenceMapIndex == -1L) {
            throw CodeInfoTable.reportNoReferenceMap(sp, ip, info);
        }
        return CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, visitor, null);
    }

    public static RuntimeException reportNoReferenceMap(Pointer sp, CodePointer ip, CodeInfo info) {
        Log.log().string("ip: ").hex((WordBase)ip).string("  sp: ").hex((WordBase)sp).string("  info:");
        CodeInfoAccess.log(info, Log.log()).newline();
        throw VMError.shouldNotReachHere("No reference map information found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    public static SubstrateInstalledCode lookupInstalledCode(CodePointer ip) {
        CodeInfoTable.counters().lookupInstalledCodeCount.inc();
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNull() || untetheredInfo.equal((ComparableWord)CodeInfoTable.getImageCodeInfo())) {
            return null;
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
            SubstrateInstalledCode substrateInstalledCode = CodeInfoTable.getInstalledCode0(info);
            return substrateInstalledCode;
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly retrieve InstalledCode.", calleeMustBe=false)
    private static SubstrateInstalledCode getInstalledCode0(CodeInfo info) {
        return RuntimeCodeInfoAccess.getInstalledCode(info);
    }

    public static void invalidateInstalledCode(SubstrateInstalledCode installedCode) {
        InvalidateInstalledCodeOperation vmOp = new InvalidateInstalledCodeOperation(installedCode);
        vmOp.enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.")
    private static void invalidateInstalledCodeAtSafepoint(SubstrateInstalledCode installedCode, CodePointer codePointer) {
        if (!installedCode.isAlive()) {
            return;
        }
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.getRuntimeCodeCache().lookupCodeInfo(codePointer);
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            assert (tether != null) : "Invalidation can't be triggered before the code was fully installed.";
            CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
            if (CodeInfoAccess.isAlive(info)) {
                CodeInfoTable.invalidateCodeAtSafepoint0(info);
            }
            assert (CodeInfoAccess.getState(info) == 4);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly retrieve InstalledCode.", calleeMustBe=false)
    private static void invalidateCodeAtSafepoint0(CodeInfo info) {
        CodeInfoTable.invalidateCodeAtSafepoint(info);
    }

    private static void invalidateCodeAtSafepoint(CodeInfo info) {
        VMOperation.guaranteeInProgressAtSafepoint("Must be at a safepoint");
        RuntimeCodeCache codeCache = CodeInfoTable.getRuntimeCodeCache();
        codeCache.invalidateMethod(info);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC")
    public static void invalidateNonStackCodeAtSafepoint(CodeInfo info) {
        VMOperation.guaranteeGCInProgress("Must only be called during a GC.");
        RuntimeCodeCache codeCache = CodeInfoTable.getRuntimeCodeCache();
        codeCache.invalidateNonStackMethod(info);
    }

    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo.", callerMustBe=true)
    public static UntetheredCodeInfo lookupCodeInfo(CodePointer ip) {
        CodeInfoTable.counters().lookupCodeInfoCount.inc();
        if (CodeInfoAccess.contains(CodeInfoTable.getImageCodeInfo(), ip)) {
            return CodeInfoTable.getImageCodeInfo();
        }
        return CodeInfoTable.getRuntimeCodeCache().lookupCodeInfo(ip);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void tearDown() {
        CodeInfoTable.getRuntimeCodeCache().tearDown();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CodeInfoTableCounters counters() {
        return (CodeInfoTableCounters)ImageSingletons.lookup(CodeInfoTableCounters.class);
    }

    private static class InvalidateInstalledCodeOperation
    extends JavaVMOperation {
        private final SubstrateInstalledCode installedCode;

        InvalidateInstalledCodeOperation(SubstrateInstalledCode installedCode) {
            super(VMOperationInfos.get(InvalidateInstalledCodeOperation.class, "Invalidate code", VMOperation.SystemEffect.SAFEPOINT));
            this.installedCode = installedCode;
        }

        @Override
        protected void operate() {
            CodeInfoTable.counters().invalidateInstalledCodeCount.inc();
            CodePointer codePointer = (CodePointer)WordFactory.pointer((long)this.installedCode.getAddress());
            CodeInfoTable.invalidateInstalledCodeAtSafepoint(this.installedCode, codePointer);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> CodeCacheCounters = new HostedOptionKey<Boolean>(false);
    }
}

