/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.truffle.isolated.IsolatedTruffleInlining;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleInliningData;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedTruffleCompilationTask
extends IsolatedObjectProxy<TruffleCompilationTask>
implements TruffleCompilationTask {
    IsolatedTruffleCompilationTask(ClientHandle<TruffleCompilationTask> handle) {
        super(handle);
    }

    public boolean isCancelled() {
        return IsolatedTruffleCompilationTask.isCancelled0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public boolean isLastTier() {
        return IsolatedTruffleCompilationTask.isLastTier0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public boolean isFirstTier() {
        return IsolatedTruffleCompilationTask.isFirstTier0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public TruffleInliningData inliningData() {
        ClientHandle<TruffleInliningData> inliningDataHandle = IsolatedTruffleCompilationTask.inliningData0(IsolatedCompileContext.get().getClient(), this.handle);
        return new IsolatedTruffleInlining<TruffleInliningData>(inliningDataHandle);
    }

    public boolean hasNextTier() {
        return IsolatedTruffleCompilationTask.hasNextTier0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean isCancelled0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return IsolatedCompileClient.get().unhand(taskHandle).isCancelled();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean isLastTier0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return IsolatedCompileClient.get().unhand(taskHandle).isLastTier();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean isFirstTier0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return IsolatedCompileClient.get().unhand(taskHandle).isFirstTier();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean hasNextTier0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return IsolatedCompileClient.get().unhand(taskHandle).hasNextTier();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<TruffleInliningData> inliningData0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        TruffleInliningData inliningData = IsolatedCompileClient.get().unhand(taskHandle).inliningData();
        return IsolatedCompileClient.get().hand(inliningData);
    }
}

