/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.impl.ImageBuildtimeCodeAnnotationAccessSupport;

@AutomaticallyRegisteredImageSingleton(value={ImageBuildtimeCodeAnnotationAccessSupport.class})
class ImageBuildtimeCodeAnnotationAccessSupportSingleton
implements ImageBuildtimeCodeAnnotationAccessSupport {
    ImageBuildtimeCodeAnnotationAccessSupportSingleton() {
    }

    public boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        assert (ImageInfo.inImageBuildtimeCode()) : "This method should only be called from within image buildtime code";
        return GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)element, annotationClass);
    }

    public Annotation getAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        assert (ImageInfo.inImageBuildtimeCode()) : "This method should only be called from within image buildtime code";
        return GuardedAnnotationAccess.getAnnotation((AnnotatedElement)element, annotationType);
    }

    public Class<? extends Annotation>[] getAnnotationTypes(AnnotatedElement element) {
        assert (ImageInfo.inImageBuildtimeCode()) : "This method should only be called from within image buildtime code";
        return GuardedAnnotationAccess.getAnnotationTypes((AnnotatedElement)element);
    }
}

