/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.CommandLineOptionOrigin;
import com.oracle.svm.core.option.DirectoryOptionOrigin;
import com.oracle.svm.core.option.JarOptionOrigin;
import com.oracle.svm.core.option.MacroOptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public abstract class OptionOrigin {
    public static final OptionOrigin commandLineOptionOriginSingleton = new CommandLineOptionOrigin();
    public static final String argFilePrefix = "argfile:";

    public URI container() {
        return null;
    }

    public Path location() {
        return null;
    }

    public boolean commandLineLike() {
        return false;
    }

    public List<String> getRedirectionValues(Path valuesFile) throws IOException {
        throw new IOException(new UnsupportedOperationException());
    }

    public static OptionOrigin from(String origin) {
        if (origin == null || origin.startsWith(argFilePrefix)) {
            return commandLineOptionOriginSingleton;
        }
        URI originURI = OptionOrigin.originURI(origin);
        if (originURI == null) {
            MacroOptionOrigin macroOption = MacroOptionOrigin.from(origin);
            if (macroOption != null) {
                return macroOption;
            }
            throw VMError.shouldNotReachHere("Unsupported OptionOrigin: " + origin);
        }
        switch (originURI.getScheme()) {
            case "jar": {
                return new JarOptionOrigin(originURI);
            }
            case "file": {
                Path originPath = Path.of(originURI);
                if (!Files.isReadable(originPath)) {
                    VMError.shouldNotReachHere("Directory origin with path that cannot be read: " + originPath);
                }
                return new DirectoryOptionOrigin(originPath);
            }
        }
        throw VMError.shouldNotReachHere("OptionOrigin of unsupported scheme: " + originURI);
    }

    protected static URI originURI(String origin) {
        try {
            return new URI(origin);
        }
        catch (URISyntaxException x) {
            return null;
        }
    }

    static List<String> getRedirectionValuesFromPath(Path normalizedRedirPath) throws IOException {
        if (Files.isReadable(normalizedRedirPath)) {
            return Files.readAllLines(normalizedRedirPath);
        }
        throw new FileNotFoundException("Unable to read file from " + normalizedRedirPath.toUri());
    }
}

