/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasChunkRotationMonitorField;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBuffers;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrGlobalMemory;
import com.oracle.svm.core.jfr.JfrUnlockedChunkWriter;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_JVM;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.word.UnsignedWord;

public class JfrRecorderThread
extends Thread {
    private static final int BUFFER_FULL_ENOUGH_PERCENTAGE = 50;
    private final JfrGlobalMemory globalMemory;
    private final JfrUnlockedChunkWriter unlockedChunkWriter;
    private final VMMutex mutex;
    private final VMCondition condition;
    private volatile boolean notified;
    private volatile boolean stopped;

    public JfrRecorderThread(JfrGlobalMemory globalMemory, JfrUnlockedChunkWriter unlockedChunkWriter) {
        super("JFR recorder");
        this.globalMemory = globalMemory;
        this.unlockedChunkWriter = unlockedChunkWriter;
        this.mutex = new VMMutex("jfrRecorder");
        this.condition = new VMCondition(this.mutex);
        this.setDaemon(true);
    }

    public void setStopped(boolean value) {
        this.stopped = value;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped) {
                this.waitForNotification();
                JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
                try {
                    if (!chunkWriter.hasOpenFile()) continue;
                    this.persistBuffers(chunkWriter);
                }
                finally {
                    chunkWriter.unlock();
                }
            }
        }
        catch (Throwable e) {
            VMError.shouldNotReachHere("No exception must by thrown in the JFR recorder thread as this could break file IO operations.");
        }
    }

    private void waitForNotification() {
        this.mutex.lock();
        try {
            while (!this.notified) {
                this.condition.block();
            }
            this.notified = false;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="state change is in native buffer")
    private void persistBuffers(JfrChunkWriter chunkWriter) {
        JfrBuffers buffers = this.globalMemory.getBuffers();
        int i = 0;
        while ((long)i < this.globalMemory.getBufferCount()) {
            boolean shouldNotify;
            JfrBuffer buffer = buffers.addressOf(i).read();
            if (JfrRecorderThread.isFullEnough(buffer) && (shouldNotify = JfrRecorderThread.persistBuffer(chunkWriter, buffer))) {
                Object chunkRotationMonitor;
                Object object = chunkRotationMonitor = JfrRecorderThread.getChunkRotationMonitor();
                synchronized (object) {
                    chunkRotationMonitor.notifyAll();
                }
            }
            ++i;
        }
    }

    private static Object getChunkRotationMonitor() {
        if (HasChunkRotationMonitorField.get()) {
            return Target_jdk_jfr_internal_JVM.CHUNK_ROTATION_MONITOR;
        }
        return Target_jdk_jfr_internal_JVM.FILE_DELTA_CHANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Epoch must not change while in this method.")
    private static boolean persistBuffer(JfrChunkWriter chunkWriter, JfrBuffer buffer) {
        if (JfrBufferAccess.acquire(buffer)) {
            try {
                boolean shouldNotify = chunkWriter.write(buffer);
                JfrBufferAccess.reinitialize(buffer);
                boolean bl = shouldNotify;
                return bl;
            }
            finally {
                JfrBufferAccess.release(buffer);
            }
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        this.notified = true;
        this.condition.broadcast();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean shouldSignal(JfrBuffer buffer) {
        return JfrRecorderThread.isFullEnough(buffer) && this.unlockedChunkWriter.hasOpenFile();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isFullEnough(JfrBuffer buffer) {
        UnsignedWord bufferTargetSize = buffer.getSize().multiply(100).unsignedDivide(50);
        return JfrBufferAccess.getAvailableSize(buffer).belowOrEqual(bufferTargetSize);
    }
}

