/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.resources.NativeImageResourceFileAttributes;
import com.oracle.svm.core.jdk.resources.NativeImageResourcePath;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class NativeImageResourceFileAttributesView
implements BasicFileAttributeView {
    private final NativeImageResourcePath path;
    private final boolean isBasic;

    public NativeImageResourceFileAttributesView(NativeImageResourcePath path, boolean isBasic) {
        this.path = path;
        this.isBasic = isBasic;
    }

    static <V extends FileAttributeView> V get(NativeImageResourcePath path, Class<V> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            return (V)new NativeImageResourceFileAttributesView(path, true);
        }
        if (type == NativeImageResourceFileAttributesView.class) {
            return (V)new NativeImageResourceFileAttributesView(path, false);
        }
        return null;
    }

    static NativeImageResourceFileAttributesView get(NativeImageResourcePath path, String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type.equals("basic")) {
            return new NativeImageResourceFileAttributesView(path, true);
        }
        if (type.equals("resource")) {
            return new NativeImageResourceFileAttributesView(path, false);
        }
        return null;
    }

    @Override
    public String name() {
        return this.isBasic ? "basic" : "resource";
    }

    @Override
    public NativeImageResourceFileAttributes readAttributes() throws IOException {
        return this.path.getAttributes();
    }

    public void setAttribute(String attribute, Object value) throws IOException {
        try {
            if (AttributeID.valueOf(attribute) == AttributeID.lastModifiedTime) {
                this.setTimes((FileTime)value, null, null);
            }
            if (AttributeID.valueOf(attribute) == AttributeID.lastAccessTime) {
                this.setTimes(null, (FileTime)value, null);
            }
            if (AttributeID.valueOf(attribute) == AttributeID.creationTime) {
                this.setTimes(null, null, (FileTime)value);
            }
        }
        catch (IllegalArgumentException x) {
            throw new UnsupportedOperationException("'" + attribute + "' is unknown or read-only attribute");
        }
    }

    Map<String, Object> readAttributes(String attributes) throws IOException {
        NativeImageResourceFileAttributes nativeImageResourceFileAttributes = this.readAttributes();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if ("*".equals(attributes)) {
            for (AttributeID id : AttributeID.values()) {
                map.put(id.name(), this.attribute(id, nativeImageResourceFileAttributes));
            }
        } else {
            String[] as;
            for (String a : as = attributes.split(",")) {
                if (!AttributeID.contains(a)) continue;
                map.put(a, this.attribute(AttributeID.valueOf(a), nativeImageResourceFileAttributes));
            }
        }
        return map;
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.path.setTimes(lastModifiedTime, lastAccessTime, createTime);
    }

    Object attribute(AttributeID id, NativeImageResourceFileAttributes nativeImageResourceFileAttributes) {
        switch (id) {
            case size: {
                return nativeImageResourceFileAttributes.size();
            }
            case creationTime: {
                return nativeImageResourceFileAttributes.creationTime();
            }
            case lastAccessTime: {
                return nativeImageResourceFileAttributes.lastAccessTime();
            }
            case lastModifiedTime: {
                return nativeImageResourceFileAttributes.lastModifiedTime();
            }
            case isDirectory: {
                return nativeImageResourceFileAttributes.isDirectory();
            }
            case isRegularFile: {
                return nativeImageResourceFileAttributes.isRegularFile();
            }
            case isSymbolicLink: {
                return nativeImageResourceFileAttributes.isSymbolicLink();
            }
            case isOther: {
                return nativeImageResourceFileAttributes.isOther();
            }
            case fileKey: {
                return nativeImageResourceFileAttributes.fileKey();
            }
        }
        return null;
    }

    private static enum AttributeID {
        size,
        creationTime,
        lastAccessTime,
        lastModifiedTime,
        isDirectory,
        isRegularFile,
        isSymbolicLink,
        isOther,
        fileKey;

        private static final Set<String> attributeValues;

        public static boolean contains(String value) {
            return attributeValues.contains(value);
        }

        static {
            attributeValues = new HashSet<String>();
            for (AttributeID choice : AttributeID.values()) {
                attributeValues.add(choice.name());
            }
        }
    }
}

