/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.reflect.target.EncodedReflectionMetadataSupplier;
import com.oracle.svm.core.reflect.target.ReflectionMetadataDecoderImpl;
import com.oracle.svm.core.reflect.target.ReflectionMetadataEncoding;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.reflect.AnnotationEncoder;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.reflect.ReflectionMetadata;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import com.oracle.svm.util.GuardedAnnotationAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jdk.internal.reflect.Reflection;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ReflectionMetadataEncoderImpl
implements NativeImageCodeCache.ReflectionMetadataEncoder {
    private final CodeInfoEncoder.Encoders encoders;
    private final ReflectionDataAccessors accessors;
    private final ReflectionDataBuilder dataBuilder;
    private final TreeSet<HostedType> sortedTypes = new TreeSet<HostedType>(Comparator.comparingLong(t -> t.getHub().getTypeID()));
    private final Map<HostedType, ReflectionMetadata.ClassMetadata> classData = new HashMap<HostedType, ReflectionMetadata.ClassMetadata>();
    private final Map<HostedType, Map<Object, ReflectionMetadata.FieldMetadata>> fieldData = new HashMap<HostedType, Map<Object, ReflectionMetadata.FieldMetadata>>();
    private final Map<HostedType, Map<Object, ReflectionMetadata.MethodMetadata>> methodData = new HashMap<HostedType, Map<Object, ReflectionMetadata.MethodMetadata>>();
    private final Map<HostedType, Map<Object, ReflectionMetadata.ConstructorMetadata>> constructorData = new HashMap<HostedType, Map<Object, ReflectionMetadata.ConstructorMetadata>>();
    private final Set<ReflectionMetadata.AccessibleObjectMetadata> heapData = new HashSet<ReflectionMetadata.AccessibleObjectMetadata>();
    private final Map<AccessibleObject, byte[]> annotationsEncodings = new HashMap<AccessibleObject, byte[]>();
    private final Map<Executable, byte[]> parameterAnnotationsEncodings = new HashMap<Executable, byte[]>();
    private final Map<Method, byte[]> annotationDefaultEncodings = new HashMap<Method, byte[]>();
    private final Map<AccessibleObject, byte[]> typeAnnotationsEncodings = new HashMap<AccessibleObject, byte[]>();
    private final Map<Executable, byte[]> reflectParametersEncodings = new HashMap<Executable, byte[]>();
    private static final Method getEnclosingMethod0 = ReflectionUtil.lookupMethod(Class.class, (String)"getEnclosingMethod0", (Class[])new Class[0]);
    private static final Method getPermittedSubclasses = ReflectionUtil.lookupMethod((boolean)true, Class.class, (String)"getPermittedSubclasses", (Class[])new Class[0]);
    private static final Method isFieldTrustedFinal = ReflectionUtil.lookupMethod((boolean)true, Field.class, (String)"isTrustedFinal", (Class[])new Class[0]);
    private static final Method getRoot = ReflectionUtil.lookupMethod(AccessibleObject.class, (String)"getRoot", (Class[])new Class[0]);
    private static final Class<?> recordComponentClass;
    private static final Method getRecordComponentName;
    private static final Method getRecordComponentType;
    private static final Method getRecordComponentSignature;
    private static final Method getRecordComponentAccessor;
    private static final Method getFieldSignature;
    private static final Method getMethodSignature;
    private static final Method getConstructorSignature;
    private static final Method getExecutableParameters;

    public ReflectionMetadataEncoderImpl(CodeInfoEncoder.Encoders encoders) {
        this.encoders = encoders;
        this.accessors = new ReflectionDataAccessors();
        this.dataBuilder = (ReflectionDataBuilder)ImageSingletons.lookup(RuntimeReflectionSupport.class);
    }

    private void registerClass(HostedType type, ReflectionMetadata.ClassMetadata metadata) {
        this.sortedTypes.add(type);
        this.classData.put(type, metadata);
    }

    private void registerField(HostedType declaringType, Object field, ReflectionMetadata.FieldMetadata metadata) {
        this.sortedTypes.add(declaringType);
        ReflectionMetadata.FieldMetadata oldData = this.fieldData.computeIfAbsent(declaringType, t -> new HashMap()).put(field, metadata);
        assert (oldData == null);
    }

    private ReflectionMetadata.FieldMetadata[] getFields(HostedType declaringType) {
        Field[] jdkFields = this.accessors.getDeclaredFields(declaringType.getJavaClass());
        Map fieldMetadata = this.fieldData.getOrDefault(declaringType, Collections.emptyMap());
        return ReflectionMetadataEncoderImpl.sortElements(jdkFields, fieldMetadata).toArray(new ReflectionMetadata.FieldMetadata[0]);
    }

    private void registerMethod(HostedType declaringType, Object method, ReflectionMetadata.MethodMetadata metadata) {
        this.sortedTypes.add(declaringType);
        ReflectionMetadata.MethodMetadata oldData = this.methodData.computeIfAbsent(declaringType, t -> new HashMap()).put(method, metadata);
        assert (oldData == null);
    }

    private ReflectionMetadata.MethodMetadata[] getMethods(HostedType declaringType) {
        Method[] jdkMethods = this.accessors.getDeclaredMethods(declaringType.getJavaClass());
        Map methodMetadata = this.methodData.getOrDefault(declaringType, Collections.emptyMap());
        return ReflectionMetadataEncoderImpl.sortElements(jdkMethods, methodMetadata).toArray(new ReflectionMetadata.MethodMetadata[0]);
    }

    private void registerConstructor(HostedType declaringType, Object constructor, ReflectionMetadata.ConstructorMetadata metadata) {
        this.sortedTypes.add(declaringType);
        ReflectionMetadata.ConstructorMetadata oldData = this.constructorData.computeIfAbsent(declaringType, t -> new HashMap()).put(constructor, metadata);
        assert (oldData == null);
    }

    private ReflectionMetadata.ConstructorMetadata[] getConstructors(HostedType declaringType) {
        Constructor<?>[] jdkConstructors = this.accessors.getDeclaredConstructors(declaringType.getJavaClass());
        Map constructorMetadata = this.constructorData.getOrDefault(declaringType, Collections.emptyMap());
        return ReflectionMetadataEncoderImpl.sortElements(jdkConstructors, constructorMetadata).toArray(new ReflectionMetadata.ConstructorMetadata[0]);
    }

    private static <T, M> List<M> sortElements(T[] jdkElements, Map<T, M> metadata) {
        ArrayList<Object> orderedElements = new ArrayList<Object>();
        ArrayList<M> trailingElements = new ArrayList<M>();
        for (T element : jdkElements) {
            if (!metadata.containsKey(element)) continue;
            M elementMetadata = metadata.remove(element);
            if (element instanceof Method && ((Method)element).isBridge()) {
                trailingElements.add(elementMetadata);
                continue;
            }
            orderedElements.add(elementMetadata);
        }
        orderedElements.addAll(metadata.values());
        orderedElements.addAll(trailingElements);
        return orderedElements;
    }

    @Override
    public byte[] getAnnotationsEncoding(AccessibleObject object) {
        return this.annotationsEncodings.get(object);
    }

    @Override
    public byte[] getParameterAnnotationsEncoding(Executable object) {
        return this.parameterAnnotationsEncodings.get(object);
    }

    @Override
    public byte[] getAnnotationDefaultEncoding(Method object) {
        return this.annotationDefaultEncodings.get(object);
    }

    @Override
    public byte[] getTypeAnnotationsEncoding(AccessibleObject object) {
        return this.typeAnnotationsEncodings.get(object);
    }

    @Override
    public byte[] getReflectParametersEncoding(Executable object) {
        return this.reflectParametersEncodings.get(object);
    }

    @Override
    public void addClassMetadata(MetaAccessProvider metaAccess, HostedType type, Class<?>[] innerClasses) {
        Class<?> javaClass = type.getHub().getHostedJavaClass();
        Object enclosingMethodInfo = ReflectionMetadataEncoderImpl.getEnclosingMethodInfo(javaClass);
        ReflectionMetadata.RecordComponentMetadata[] recordComponents = this.getRecordComponents(metaAccess, type, javaClass);
        Class<?>[] permittedSubclasses = ReflectionMetadataEncoderImpl.getPermittedSubclasses(metaAccess, javaClass);
        int classAccessFlags = Reflection.getClassAccessFlags(javaClass);
        this.encoders.sourceClasses.addObject(javaClass);
        if (enclosingMethodInfo instanceof Throwable) {
            this.registerError((Throwable)enclosingMethodInfo);
        } else {
            this.registerEnclosingMethodInfo((Object[])enclosingMethodInfo);
        }
        HostedType[] innerTypes = this.registerClassValues(metaAccess, innerClasses);
        HostedType[] permittedSubtypes = permittedSubclasses != null ? this.registerClassValues(metaAccess, permittedSubclasses) : null;
        AnalysisType analysisType = type.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues((AnnotatedElement)analysisType);
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues((AnnotatedElement)analysisType);
        this.registerClass(type, new ReflectionMetadata.ClassMetadata(innerTypes, enclosingMethodInfo, recordComponents, permittedSubtypes, classAccessFlags, annotations, typeAnnotations));
    }

    private void registerError(Throwable error) {
        this.encoders.objectConstants.addObject((Object)SubstrateObjectConstant.forObject(error));
    }

    private static Object getEnclosingMethodInfo(Class<?> clazz) {
        try {
            return getEnclosingMethod0.invoke(clazz, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof LinkageError) {
                return e.getCause();
            }
            throw VMError.shouldNotReachHere(e);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private void registerEnclosingMethodInfo(Object[] enclosingMethodInfo) {
        if (enclosingMethodInfo == null) {
            return;
        }
        this.encoders.sourceClasses.addObject((Object)((Class)enclosingMethodInfo[0]));
        this.encoders.sourceMethodNames.addObject((Object)((String)enclosingMethodInfo[1]));
        this.encoders.sourceMethodNames.addObject((Object)((String)enclosingMethodInfo[2]));
    }

    private static Class<?>[] getPermittedSubclasses(MetaAccessProvider metaAccess, Class<?> clazz) {
        if (JavaVersionUtil.JAVA_SPEC < 17) {
            return null;
        }
        try {
            Class[] permittedSubclasses = (Class[])getPermittedSubclasses.invoke(clazz, new Object[0]);
            if (permittedSubclasses == null) {
                return null;
            }
            HashSet<Class> reachablePermittedSubclasses = new HashSet<Class>();
            for (Class permittedSubclass : permittedSubclasses) {
                try {
                    HostedType hostedType = ((HostedMetaAccess)metaAccess).optionalLookupJavaType(permittedSubclass).orElse(null);
                    if (hostedType == null || !hostedType.getWrapped().isReachable()) continue;
                    reachablePermittedSubclasses.add(permittedSubclass);
                }
                catch (DeletedElementException deletedElementException) {
                    // empty catch block
                }
            }
            return reachablePermittedSubclasses.toArray(new Class[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    public void addReflectionFieldMetadata(MetaAccessProvider metaAccess, HostedField hostedField, Field reflectField) {
        HostedType declaringType = hostedField.getDeclaringClass();
        String name = hostedField.getName();
        HostedType type = hostedField.getType();
        int modifiers = reflectField.getModifiers();
        boolean trustedFinal = ReflectionMetadataEncoderImpl.isTrustedFinal(reflectField);
        String signature = ReflectionMetadataEncoderImpl.getSignature(reflectField);
        int offset = hostedField.wrapped.isUnsafeAccessed() ? hostedField.getOffset() : -1;
        Delete deleteAnnotation = (Delete)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)((Object)hostedField), Delete.class);
        String deletedReason = deleteAnnotation != null ? deleteAnnotation.value() : null;
        this.encoders.sourceMethodNames.addObject((Object)name);
        this.encoders.sourceClasses.addObject(type.getJavaClass());
        this.encoders.sourceMethodNames.addObject((Object)signature);
        this.encoders.sourceMethodNames.addObject((Object)deletedReason);
        AnalysisField analysisField = hostedField.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues((AnnotatedElement)analysisField);
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues((AnnotatedElement)analysisField);
        this.registerField(declaringType, reflectField, new ReflectionMetadata.FieldMetadata(declaringType, name, type, modifiers, trustedFinal, signature, annotations, typeAnnotations, offset, deletedReason));
    }

    @Override
    public void addReflectionExecutableMetadata(MetaAccessProvider metaAccess, HostedMethod hostedMethod, Executable reflectMethod, Object accessor) {
        boolean isMethod = !hostedMethod.isConstructor();
        HostedType declaringType = hostedMethod.getDeclaringClass();
        String name = isMethod ? hostedMethod.getName() : null;
        HostedType[] parameterTypes = ReflectionMetadataEncoderImpl.getParameterTypes(hostedMethod);
        int modifiers = reflectMethod.getModifiers();
        HostedType returnType = (HostedType)hostedMethod.getSignature().getReturnType(null);
        HostedType[] exceptionTypes = ReflectionMetadataEncoderImpl.getExceptionTypes(metaAccess, reflectMethod);
        String signature = ReflectionMetadataEncoderImpl.getSignature(reflectMethod);
        if (isMethod) {
            this.encoders.sourceMethodNames.addObject((Object)name);
            this.encoders.sourceClasses.addObject(returnType.getJavaClass());
        }
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        for (HostedType exceptionType : exceptionTypes) {
            this.encoders.sourceClasses.addObject(exceptionType.getJavaClass());
        }
        this.encoders.sourceMethodNames.addObject((Object)signature);
        AnalysisMethod analysisMethod = hostedMethod.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues((AnnotatedElement)analysisMethod);
        AnnotationValue[][] parameterAnnotations = this.registerParameterAnnotationValues(analysisMethod);
        AnnotationMemberValue annotationDefault = isMethod ? this.registerAnnotationDefaultValues(analysisMethod) : null;
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues((AnnotatedElement)analysisMethod);
        ReflectionMetadata.ReflectParameterMetadata[] reflectParameters = this.registerReflectParameters(reflectMethod);
        JavaConstant accessorConstant = null;
        if (accessor != null) {
            accessorConstant = SubstrateObjectConstant.forObject(accessor);
            this.encoders.objectConstants.addObject((Object)accessorConstant);
        }
        if (isMethod) {
            this.registerMethod(declaringType, reflectMethod, new ReflectionMetadata.MethodMetadata(declaringType, name, parameterTypes, modifiers, returnType, exceptionTypes, signature, annotations, parameterAnnotations, annotationDefault, typeAnnotations, reflectParameters, accessorConstant));
        } else {
            this.registerConstructor(declaringType, reflectMethod, new ReflectionMetadata.ConstructorMetadata(declaringType, parameterTypes, modifiers, exceptionTypes, signature, annotations, parameterAnnotations, typeAnnotations, reflectParameters, accessorConstant));
        }
    }

    private static boolean isTrustedFinal(Field field) {
        if (JavaVersionUtil.JAVA_SPEC < 17) {
            return false;
        }
        try {
            return (Boolean)isFieldTrustedFinal.invoke((Object)field, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    public void addHeapAccessibleObjectMetadata(MetaAccessProvider metaAccess, WrappedElement hostedObject, AccessibleObject object, boolean registered) {
        ReflectionMetadata.AccessibleObjectMetadata metadata;
        boolean isExecutable = object instanceof Executable;
        boolean isMethod = object instanceof Method;
        AnnotatedElement analysisObject = (AnnotatedElement)hostedObject.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues(analysisObject);
        AnnotationValue[][] parameterAnnotations = isExecutable ? this.registerParameterAnnotationValues((AnalysisMethod)analysisObject) : null;
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues(analysisObject);
        AnnotationMemberValue annotationDefault = isMethod ? this.registerAnnotationDefaultValues((AnalysisMethod)analysisObject) : null;
        ReflectionMetadata.ReflectParameterMetadata[] reflectParameters = isExecutable ? this.registerReflectParameters((Executable)object) : null;
        AccessibleObject holder = ReflectionMetadataEncoderImpl.getHolder(object);
        JavaConstant heapObjectConstant = SubstrateObjectConstant.forObject(holder);
        this.encoders.objectConstants.addObject((Object)heapObjectConstant);
        if (isMethod) {
            metadata = new ReflectionMetadata.MethodMetadata(registered, heapObjectConstant, annotations, parameterAnnotations, annotationDefault, typeAnnotations, reflectParameters);
            this.registerMethod((HostedType)metaAccess.lookupJavaType(((Method)object).getDeclaringClass()), holder, (ReflectionMetadata.MethodMetadata)metadata);
        } else if (isExecutable) {
            metadata = new ReflectionMetadata.ConstructorMetadata(registered, heapObjectConstant, annotations, parameterAnnotations, typeAnnotations, reflectParameters);
            this.registerConstructor((HostedType)metaAccess.lookupJavaType(((Constructor)object).getDeclaringClass()), holder, (ReflectionMetadata.ConstructorMetadata)metadata);
        } else {
            metadata = new ReflectionMetadata.FieldMetadata(registered, heapObjectConstant, annotations, typeAnnotations);
            this.registerField((HostedType)metaAccess.lookupJavaType(((Field)object).getDeclaringClass()), holder, (ReflectionMetadata.FieldMetadata)metadata);
        }
        this.heapData.add(metadata);
    }

    private static AccessibleObject getHolder(AccessibleObject accessibleObject) {
        try {
            AccessibleObject root = (AccessibleObject)getRoot.invoke((Object)accessibleObject, new Object[0]);
            return root == null ? accessibleObject : root;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private HostedType[] registerClassValues(MetaAccessProvider metaAccess, Class<?>[] classes) {
        HashSet<HostedType> includedClasses = new HashSet<HostedType>();
        for (Class<?> clazz : classes) {
            HostedType type;
            try {
                type = ((HostedMetaAccess)metaAccess).optionalLookupJavaType(clazz).orElse(null);
            }
            catch (DeletedElementException e) {
                type = null;
            }
            if (type == null || !type.getWrapped().isReachable()) continue;
            this.encoders.sourceClasses.addObject(type.getJavaClass());
            includedClasses.add(type);
        }
        return includedClasses.toArray(new HostedType[0]);
    }

    private AnnotationValue[] registerAnnotationValues(AnnotatedElement element) {
        AnnotationValue[] annotations;
        for (AnnotationValue annotation : annotations = this.dataBuilder.getAnnotationData(element)) {
            this.registerValues(annotation);
        }
        return annotations;
    }

    private AnnotationValue[][] registerParameterAnnotationValues(AnalysisMethod element) {
        AnnotationValue[][] parameterAnnotations;
        AnnotationValue[][] annotationValueArray = parameterAnnotations = this.dataBuilder.getParameterAnnotationData(element);
        int n = annotationValueArray.length;
        for (int i = 0; i < n; ++i) {
            AnnotationValue[] annotations;
            for (AnnotationValue annotation : annotations = annotationValueArray[i]) {
                this.registerValues(annotation);
            }
        }
        return parameterAnnotations;
    }

    private AnnotationMemberValue registerAnnotationDefaultValues(AnalysisMethod method) {
        AnnotationMemberValue annotationDefault = this.dataBuilder.getAnnotationDefaultData((AnnotatedElement)method);
        if (annotationDefault != null) {
            this.registerValues(annotationDefault);
        }
        return annotationDefault;
    }

    private TypeAnnotationValue[] registerTypeAnnotationValues(AnnotatedElement element) {
        TypeAnnotationValue[] typeAnnotations;
        for (TypeAnnotationValue typeAnnotation : typeAnnotations = this.dataBuilder.getTypeAnnotationData(element)) {
            this.registerValues(typeAnnotation.getAnnotationData());
        }
        return typeAnnotations;
    }

    private void registerValues(AnnotationMemberValue annotationValue) {
        for (Class<?> type : annotationValue.getTypes()) {
            this.encoders.sourceClasses.addObject(type);
        }
        for (String string : annotationValue.getStrings()) {
            this.encoders.sourceMethodNames.addObject((Object)string);
        }
        for (JavaConstant proxy : annotationValue.getExceptionProxies()) {
            this.encoders.objectConstants.addObject((Object)proxy);
        }
    }

    private ReflectionMetadata.ReflectParameterMetadata[] registerReflectParameters(Executable executable) {
        ReflectionMetadata.ReflectParameterMetadata[] reflectParameters = ReflectionMetadataEncoderImpl.getReflectParameters(executable);
        if (reflectParameters != null) {
            for (ReflectionMetadata.ReflectParameterMetadata parameter : reflectParameters) {
                this.encoders.sourceMethodNames.addObject((Object)parameter.name);
            }
        }
        return reflectParameters;
    }

    @Override
    public void addHidingFieldMetadata(AnalysisField analysisField, HostedType declaringType, String name, HostedType type, int modifiers) {
        this.encoders.sourceMethodNames.addObject((Object)name);
        this.encoders.sourceClasses.addObject(type.getJavaClass());
        this.sortedTypes.add(declaringType);
        this.registerField(declaringType, analysisField, new ReflectionMetadata.FieldMetadata(declaringType, name, type, modifiers));
    }

    @Override
    public void addHidingMethodMetadata(AnalysisMethod analysisMethod, HostedType declaringType, String name, HostedType[] parameterTypes, int modifiers, HostedType returnType) {
        this.encoders.sourceMethodNames.addObject((Object)name);
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        this.encoders.sourceClasses.addObject(returnType.getJavaClass());
        this.sortedTypes.add(declaringType);
        this.registerMethod(declaringType, analysisMethod, new ReflectionMetadata.MethodMetadata(declaringType, name, parameterTypes, modifiers, returnType));
    }

    @Override
    public void addReachableFieldMetadata(HostedField field) {
        HostedType declaringType = field.getDeclaringClass();
        String name = field.getName();
        this.encoders.sourceMethodNames.addObject((Object)name);
        this.registerField(declaringType, field, new ReflectionMetadata.FieldMetadata(declaringType, name));
    }

    @Override
    public void addReachableExecutableMetadata(HostedMethod executable) {
        boolean isMethod = !executable.isConstructor();
        HostedType declaringType = executable.getDeclaringClass();
        String name = isMethod ? executable.getName() : null;
        HostedType[] parameterTypes = ReflectionMetadataEncoderImpl.getParameterTypes(executable);
        if (isMethod) {
            this.encoders.sourceMethodNames.addObject((Object)name);
        }
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        if (isMethod) {
            this.registerMethod(declaringType, executable, new ReflectionMetadata.MethodMetadata(declaringType, name, parameterTypes));
        } else {
            this.registerConstructor(declaringType, executable, new ReflectionMetadata.ConstructorMetadata(declaringType, parameterTypes));
        }
    }

    private static HostedType[] getParameterTypes(HostedMethod method) {
        HostedType[] parameterTypes = new HostedType[method.getSignature().getParameterCount(false)];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = (HostedType)method.getSignature().getParameterType(i, null);
        }
        return parameterTypes;
    }

    private static HostedType[] getExceptionTypes(MetaAccessProvider metaAccess, Executable reflectMethod) {
        Class<?>[] exceptionClasses = reflectMethod.getExceptionTypes();
        HostedType[] exceptionTypes = new HostedType[exceptionClasses.length];
        for (int i = 0; i < exceptionClasses.length; ++i) {
            exceptionTypes[i] = (HostedType)metaAccess.lookupJavaType(exceptionClasses[i]);
        }
        return exceptionTypes;
    }

    private static ReflectionMetadata.ReflectParameterMetadata[] getReflectParameters(Executable reflectMethod) {
        Parameter[] rawParameters = ReflectionMetadataEncoderImpl.getRawParameters(reflectMethod);
        if (rawParameters == null) {
            return null;
        }
        ReflectionMetadata.ReflectParameterMetadata[] reflectParameters = new ReflectionMetadata.ReflectParameterMetadata[rawParameters.length];
        for (int i = 0; i < rawParameters.length; ++i) {
            reflectParameters[i] = new ReflectionMetadata.ReflectParameterMetadata(rawParameters[i].getName(), rawParameters[i].getModifiers());
        }
        return reflectParameters;
    }

    private ReflectionMetadata.RecordComponentMetadata[] getRecordComponents(MetaAccessProvider metaAccess, HostedType declaringType, Class<?> clazz) {
        Object[] recordComponents = ((ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class)).getRecordComponents(clazz);
        if (recordComponents == null) {
            return null;
        }
        ReflectionMetadata.RecordComponentMetadata[] metadata = new ReflectionMetadata.RecordComponentMetadata[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            AnnotatedElement recordComponent = (AnnotatedElement)recordComponents[i];
            String name = ReflectionMetadataEncoderImpl.getRecordComponentName(recordComponent);
            HostedType type = (HostedType)metaAccess.lookupJavaType(ReflectionMetadataEncoderImpl.getRecordComponentType(recordComponent));
            String signature = ReflectionMetadataEncoderImpl.getRecordComponentSignature(recordComponent);
            Method accessor = ReflectionMetadataEncoderImpl.getRecordComponentAccessor(recordComponent);
            this.encoders.sourceMethodNames.addObject((Object)name);
            this.encoders.sourceClasses.addObject(type.getJavaClass());
            this.encoders.sourceMethodNames.addObject((Object)signature);
            AnnotationValue[] annotations = this.registerAnnotationValues(recordComponent);
            TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues(recordComponent);
            JavaConstant accessorConstant = null;
            if (accessor != null) {
                accessorConstant = SubstrateObjectConstant.forObject(accessor);
                this.encoders.objectConstants.addObject((Object)accessorConstant);
            }
            metadata[i] = new ReflectionMetadata.RecordComponentMetadata(declaringType, name, type, signature, accessorConstant, annotations, typeAnnotations);
        }
        return metadata;
    }

    private static String getRecordComponentName(Object recordComponent) {
        try {
            return (String)getRecordComponentName.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static Class<?> getRecordComponentType(Object recordComponent) {
        try {
            return (Class)getRecordComponentType.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static String getRecordComponentSignature(Object recordComponent) {
        try {
            return (String)getRecordComponentSignature.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static Method getRecordComponentAccessor(Object recordComponent) {
        try {
            return (Method)getRecordComponentAccessor.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    public void encodeAllAndInstall() {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        int typesIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.sortedTypes.toArray(new HostedType[0]), this::encodeType, false);
        assert (typesIndex == 0);
        for (HostedType declaringType : this.sortedTypes) {
            int permittedSubclassesIndex;
            DynamicHub hub = declaringType.getHub();
            ReflectionMetadata.ClassMetadata classMetadata = this.classData.get(declaringType);
            int enclosingMethodInfoIndex = classMetadata.enclosingMethodInfo instanceof Throwable ? this.encodeErrorIndex((Throwable)classMetadata.enclosingMethodInfo) : ReflectionMetadataEncoderImpl.addElement(buf, this.encodeEnclosingMethodInfo((Object[])classMetadata.enclosingMethodInfo));
            int annotationsIndex = ReflectionMetadataEncoderImpl.addEncodedElement(buf, this.encodeAnnotations(classMetadata.annotations));
            int typeAnnotationsIndex = ReflectionMetadataEncoderImpl.addEncodedElement(buf, this.encodeTypeAnnotations(classMetadata.typeAnnotations));
            int classesEncodingIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, classMetadata.classes, this::encodeType, false);
            int n = permittedSubclassesIndex = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, classMetadata.permittedSubclasses, this::encodeType, true) : -1;
            if (ReflectionMetadataEncoderImpl.anySet(enclosingMethodInfoIndex, annotationsIndex, typeAnnotationsIndex, classesEncodingIndex, permittedSubclassesIndex)) {
                hub.setHubMetadata(enclosingMethodInfoIndex, annotationsIndex, typeAnnotationsIndex, classesEncodingIndex, permittedSubclassesIndex);
            }
            int fieldsIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.getFields(declaringType), this::encodeField, false);
            int methodsIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.getMethods(declaringType), this::encodeExecutable, false);
            int constructorsIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.getConstructors(declaringType), this::encodeExecutable, false);
            int recordComponentsIndex = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, classMetadata.recordComponents, this::encodeRecordComponent, true) : -1;
            int classAccessFlags = classMetadata.classAccessFlags;
            if (!ReflectionMetadataEncoderImpl.anySet(fieldsIndex, methodsIndex, constructorsIndex, recordComponentsIndex) && classAccessFlags == hub.getModifiers()) continue;
            hub.setReflectionMetadata(fieldsIndex, methodsIndex, constructorsIndex, recordComponentsIndex, classAccessFlags);
        }
        for (ReflectionMetadata.AccessibleObjectMetadata metadata : this.heapData) {
            AccessibleObject heapObject = (AccessibleObject)SubstrateObjectConstant.asObject((Constant)metadata.heapObject);
            this.annotationsEncodings.put(heapObject, this.encodeAnnotations(metadata.annotations));
            this.typeAnnotationsEncodings.put(heapObject, this.encodeTypeAnnotations(metadata.typeAnnotations));
            if (!(metadata instanceof ReflectionMetadata.ExecutableMetadata)) continue;
            this.parameterAnnotationsEncodings.put((Executable)heapObject, this.encodeParameterAnnotations(((ReflectionMetadata.ExecutableMetadata)metadata).parameterAnnotations));
            if (((ReflectionMetadata.ExecutableMetadata)metadata).reflectParameters != null) {
                this.reflectParametersEncodings.put((Executable)heapObject, this.encodeReflectParameters(((ReflectionMetadata.ExecutableMetadata)metadata).reflectParameters));
            }
            if (!(metadata instanceof ReflectionMetadata.MethodMetadata)) continue;
            this.annotationDefaultEncodings.put((Method)heapObject, this.encodeAnnotationDefault(((ReflectionMetadata.MethodMetadata)metadata).annotationDefault));
        }
        ReflectionMetadataEncoderImpl.install(buf);
        ImageSingletons.add(EncodedReflectionMetadataSupplier.class, (Object)this);
    }

    private int encodeErrorIndex(Throwable error) {
        int index = this.encoders.objectConstants.getIndex((Object)SubstrateObjectConstant.forObject(error));
        int encodedIndex = -2 - index;
        VMError.guarantee(ReflectionMetadataDecoderImpl.isErrorIndex(encodedIndex));
        return encodedIndex;
    }

    private static <T> int encodeAndAddCollection(UnsafeArrayTypeWriter buf, T[] data, BiConsumer<UnsafeArrayTypeWriter, T> encodeCallback, boolean canBeNull) {
        if (data == null || !canBeNull && data.length == 0) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        ReflectionMetadataEncoderImpl.encodeArray(buf, data, element -> encodeCallback.accept(buf, element));
        return offset;
    }

    private static int addElement(UnsafeArrayTypeWriter buf, byte[] encoding) {
        if (encoding == null) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        ReflectionMetadataEncoderImpl.encodeBytes(buf, encoding);
        return offset;
    }

    private static int addEncodedElement(UnsafeArrayTypeWriter buf, byte[] encoding) {
        if (encoding == null) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        ReflectionMetadataEncoderImpl.encodeByteArray(buf, encoding);
        return offset;
    }

    private static void install(UnsafeArrayTypeWriter encodingBuffer) {
        int encodingSize = TypeConversion.asS4((long)encodingBuffer.getBytesWritten());
        byte[] dataEncoding = new byte[encodingSize];
        ((ReflectionMetadataEncoding)ImageSingletons.lookup(ReflectionMetadataEncoding.class)).setEncoding(encodingBuffer.toArray(dataEncoding));
    }

    private static boolean anySet(int ... indices) {
        for (int index : indices) {
            if (index == -1) continue;
            return true;
        }
        return false;
    }

    private void encodeField(UnsafeArrayTypeWriter buf, ReflectionMetadata.FieldMetadata field) {
        assert ((field.modifiers & 0xE0000000) == 0);
        int modifiers = field.modifiers;
        modifiers |= field.complete ? Integer.MIN_VALUE : 0;
        modifiers |= field.heapObject != null ? 0x40000000 : 0;
        buf.putUV((long)(modifiers |= field.hiding ? 0x20000000 : 0));
        if (field.heapObject != null) {
            this.encodeObject(buf, field.heapObject);
        } else {
            this.encodeName(buf, field.name);
            if (field.complete || field.hiding) {
                this.encodeType(buf, field.type);
            }
            if (field.complete) {
                if (JavaVersionUtil.JAVA_SPEC >= 17) {
                    buf.putU1(field.trustedFinal ? 1L : 0L);
                }
                this.encodeName(buf, field.signature);
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(field.annotations));
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(field.typeAnnotations));
                buf.putSV((long)field.offset);
                this.encodeName(buf, field.deletedReason);
            }
        }
    }

    private void encodeExecutable(UnsafeArrayTypeWriter buf, ReflectionMetadata.ExecutableMetadata executable) {
        boolean isHiding;
        boolean isMethod = executable instanceof ReflectionMetadata.MethodMetadata;
        boolean bl = isHiding = isMethod && ((ReflectionMetadata.MethodMetadata)executable).hiding;
        assert ((executable.modifiers & 0xE0000000) == 0);
        int modifiers = executable.modifiers;
        modifiers |= executable.complete ? Integer.MIN_VALUE : 0;
        modifiers |= executable.heapObject != null ? 0x40000000 : 0;
        buf.putUV((long)(modifiers |= isHiding ? 0x20000000 : 0));
        if (executable.heapObject != null) {
            this.encodeObject(buf, executable.heapObject);
        } else {
            if (isMethod) {
                this.encodeName(buf, ((ReflectionMetadata.MethodMetadata)executable).name);
            }
            ReflectionMetadataEncoderImpl.encodeArray(buf, executable.parameterTypes, parameterType -> this.encodeType(buf, (HostedType)parameterType));
            if (isMethod && (executable.complete || isHiding)) {
                this.encodeType(buf, ((ReflectionMetadata.MethodMetadata)executable).returnType);
            }
            if (executable.complete) {
                ReflectionMetadataEncoderImpl.encodeArray(buf, executable.exceptionTypes, exceptionType -> this.encodeType(buf, (HostedType)exceptionType));
                this.encodeName(buf, executable.signature);
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(executable.annotations));
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeParameterAnnotations(executable.parameterAnnotations));
                if (isMethod && executable.declaringType.getHub().getHostedJavaClass().isAnnotation()) {
                    ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotationDefault(((ReflectionMetadata.MethodMetadata)executable).annotationDefault));
                }
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(executable.typeAnnotations));
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeReflectParameters(executable.reflectParameters));
                this.encodeObject(buf, executable.accessor);
            }
        }
    }

    private void encodeType(UnsafeArrayTypeWriter buf, HostedType type) {
        this.encodeType(buf, type.getJavaClass());
    }

    private void encodeType(UnsafeArrayTypeWriter buf, Class<?> type) {
        buf.putSV((long)this.encoders.sourceClasses.getIndex(type));
    }

    private void encodeName(UnsafeArrayTypeWriter buf, String name) {
        buf.putSV((long)this.encoders.sourceMethodNames.getIndex((Object)name));
    }

    private void encodeObject(UnsafeArrayTypeWriter buf, JavaConstant object) {
        if (object == null) {
            buf.putSV(-1L);
        } else {
            buf.putSV((long)this.encoders.objectConstants.getIndex((Object)object));
        }
    }

    private static <T> void encodeArray(UnsafeArrayTypeWriter buf, T[] array, Consumer<T> elementEncoder) {
        buf.putUV((long)array.length);
        for (T elem : array) {
            elementEncoder.accept(elem);
        }
    }

    private static void encodeByteArray(UnsafeArrayTypeWriter buf, byte[] array) {
        if (array == null) {
            buf.putUV(-1L);
            return;
        }
        buf.putUV((long)array.length);
        ReflectionMetadataEncoderImpl.encodeBytes(buf, array);
    }

    private static void encodeBytes(UnsafeArrayTypeWriter buf, byte[] bytes) {
        for (byte b : bytes) {
            buf.putS1((long)b);
        }
    }

    private static String getSignature(Field field) {
        try {
            return (String)getFieldSignature.invoke((Object)field, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static String getSignature(Executable executable) {
        try {
            return (String)(executable instanceof Method ? getMethodSignature.invoke((Object)executable, new Object[0]) : getConstructorSignature.invoke((Object)executable, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static Parameter[] getRawParameters(Executable executable) {
        try {
            return (Parameter[])getExecutableParameters.invoke((Object)executable, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public byte[] encodeAnnotations(AnnotationValue[] annotations) {
        if (annotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        AnnotationEncoder.encodeArray(buf, annotations, annotation -> AnnotationEncoder.encodeAnnotation(buf, annotation, this.encoders));
        return buf.toArray();
    }

    private byte[] encodeParameterAnnotations(AnnotationValue[][] parameterAnnotations) {
        if (parameterAnnotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        buf.putU1((long)parameterAnnotations.length);
        for (AnnotationValue[] annotations : parameterAnnotations) {
            AnnotationEncoder.encodeArray(buf, annotations, annotation -> AnnotationEncoder.encodeAnnotation(buf, annotation, this.encoders));
        }
        return buf.toArray();
    }

    private byte[] encodeAnnotationDefault(AnnotationMemberValue annotationDefault) {
        if (annotationDefault == null) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        AnnotationEncoder.encodeAnnotationMember(buf, annotationDefault, this.encoders);
        return buf.toArray();
    }

    public byte[] encodeTypeAnnotations(TypeAnnotationValue[] typeAnnotations) {
        if (typeAnnotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        AnnotationEncoder.encodeArray(buf, typeAnnotations, typeAnnotation -> AnnotationEncoder.encodeTypeAnnotation(buf, typeAnnotation, this.encoders));
        return buf.toArray();
    }

    private byte[] encodeReflectParameters(ReflectionMetadata.ReflectParameterMetadata[] reflectParameters) {
        if (reflectParameters == null) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        ReflectionMetadataEncoderImpl.encodeArray(buf, reflectParameters, reflectParameter -> this.encodeReflectParameter(buf, (ReflectionMetadata.ReflectParameterMetadata)reflectParameter));
        return buf.toArray();
    }

    private void encodeReflectParameter(UnsafeArrayTypeWriter buf, ReflectionMetadata.ReflectParameterMetadata reflectParameter) {
        this.encodeName(buf, reflectParameter.name);
        buf.putUV((long)reflectParameter.modifiers);
    }

    private void encodeRecordComponent(UnsafeArrayTypeWriter buf, ReflectionMetadata.RecordComponentMetadata recordComponent) {
        this.encodeName(buf, recordComponent.name);
        this.encodeType(buf, recordComponent.type);
        this.encodeName(buf, recordComponent.signature);
        this.encodeObject(buf, recordComponent.accessor);
        ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(recordComponent.annotations));
        ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(recordComponent.typeAnnotations));
    }

    private byte[] encodeEnclosingMethodInfo(Object[] enclosingMethodInfo) {
        if (enclosingMethodInfo == null) {
            return null;
        }
        assert (enclosingMethodInfo.length == 3);
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        this.encodeType(buf, (Class)enclosingMethodInfo[0]);
        this.encodeName(buf, (String)enclosingMethodInfo[1]);
        this.encodeName(buf, (String)enclosingMethodInfo[2]);
        return buf.toArray();
    }

    static {
        try {
            recordComponentClass = JavaVersionUtil.JAVA_SPEC >= 17 ? Class.forName("java.lang.reflect.RecordComponent") : null;
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere(e);
        }
        getRecordComponentName = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getName", (Class[])new Class[0]) : null;
        getRecordComponentType = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getType", (Class[])new Class[0]) : null;
        getRecordComponentSignature = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getGenericSignature", (Class[])new Class[0]) : null;
        getRecordComponentAccessor = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getAccessor", (Class[])new Class[0]) : null;
        getFieldSignature = ReflectionUtil.lookupMethod(Field.class, (String)"getGenericSignature", (Class[])new Class[0]);
        getMethodSignature = ReflectionUtil.lookupMethod(Method.class, (String)"getGenericSignature", (Class[])new Class[0]);
        getConstructorSignature = ReflectionUtil.lookupMethod(Constructor.class, (String)"getSignature", (Class[])new Class[0]);
        getExecutableParameters = ReflectionUtil.lookupMethod(Executable.class, (String)"getParameters0", (Class[])new Class[0]);
    }

    static final class ReflectionDataAccessors {
        private final Method privateGetDeclaredFields = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredFields", (Class[])new Class[]{Boolean.TYPE});
        private final Method privateGetDeclaredMethods = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredMethods", (Class[])new Class[]{Boolean.TYPE});
        private final Method privateGetDeclaredConstructors = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredConstructors", (Class[])new Class[]{Boolean.TYPE});

        ReflectionDataAccessors() {
        }

        Field[] getDeclaredFields(Object obj) {
            try {
                return (Field[])this.privateGetDeclaredFields.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Field[0];
            }
        }

        Method[] getDeclaredMethods(Object obj) {
            try {
                return (Method[])this.privateGetDeclaredMethods.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Method[0];
            }
        }

        Constructor<?>[] getDeclaredConstructors(Object obj) {
            try {
                return (Constructor[])this.privateGetDeclaredConstructors.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Constructor[0];
            }
        }
    }

    @AutomaticallyRegisteredImageSingleton(value={NativeImageCodeCache.ReflectionMetadataEncoderFactory.class})
    static class Factory
    implements NativeImageCodeCache.ReflectionMetadataEncoderFactory {
        Factory() {
        }

        @Override
        public NativeImageCodeCache.ReflectionMetadataEncoder create(CodeInfoEncoder.Encoders encoders) {
            return new ReflectionMetadataEncoderImpl(encoders);
        }
    }
}

