/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.AnalysisConstantPool;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.phases.SharedGraphBuilderPhase;
import com.oracle.svm.util.ModuleSupport;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.BootstrapMethodIntrospection;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.word.WordTypes;

public class AnalysisGraphBuilderPhase
extends SharedGraphBuilderPhase {
    public AnalysisGraphBuilderPhase(CoreProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes) {
        super(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, wordTypes);
    }

    protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        return new AnalysisBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
    }

    public static class AnalysisBytecodeParser
    extends SharedGraphBuilderPhase.SharedBytecodeParser {
        private final boolean parseOnce = SubstrateOptions.parseOnce();

        protected AnalysisBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, true);
        }

        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            boolean result = super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
            if (result) {
                ((AnalysisMethod)targetMethod).registerAsIntrinsicMethod();
            }
            return result;
        }

        protected boolean applyInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType, InvocationPlugin plugin) {
            Class<?> accessingClass = plugin.getClass();
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, accessingClass, (boolean)false, (String)"jdk.internal.vm.ci", (String[])new String[]{"jdk.vm.ci.meta"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, accessingClass, (boolean)false, (String)"jdk.internal.vm.compiler", (String[])new String[]{"org.graalvm.compiler.nodes"});
            return super.applyInvocationPlugin(invokeKind, args, targetMethod, resultType, plugin);
        }

        protected BytecodeParser.ExceptionEdgeAction getActionForInvokeExceptionEdge(InlineInvokePlugin.InlineInfo lastInlineInfo) {
            if (!this.parseOnce && !this.insideTryBlock()) {
                return BytecodeParser.ExceptionEdgeAction.OMIT;
            }
            return super.getActionForInvokeExceptionEdge(lastInlineInfo);
        }

        private boolean tryNodePluginForDynamicInvocation(BootstrapMethodIntrospection bootstrap) {
            for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
                Pair result = plugin.convertInvokeDynamic((GraphBuilderContext)this, bootstrap);
                if (result == null) continue;
                this.appendInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)result.getLeft(), (ValueNode[])result.getRight());
                return true;
            }
            return false;
        }

        protected void genInvokeDynamic(int cpi, int opcode) {
            BootstrapMethodIntrospection bootstrap;
            if (this.parseOnce && (bootstrap = ((AnalysisConstantPool)this.constantPool).lookupBootstrapMethodIntrospection(cpi, opcode)) != null && this.tryNodePluginForDynamicInvocation(bootstrap)) {
                return;
            }
            super.genInvokeDynamic(cpi, opcode);
        }
    }
}

