/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class ImageHeapMapFeature
implements InternalFeature {
    private final Set<ImageHeapMap.HostedImageHeapMap<?, ?>> allInstances = ConcurrentHashMap.newKeySet();

    ImageHeapMapFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        config.registerObjectReplacer(this::imageHeapMapTransformer);
    }

    private Object imageHeapMapTransformer(Object obj) {
        if (obj instanceof ImageHeapMap.HostedImageHeapMap) {
            ImageHeapMap.HostedImageHeapMap hostedImageHeapMap = (ImageHeapMap.HostedImageHeapMap)((Object)obj);
            if (BuildPhaseProvider.isAnalysisFinished()) {
                VMError.guarantee(this.allInstances.contains((Object)hostedImageHeapMap), "ImageHeapMap reachable after analysis that was not seen during analysis");
            } else {
                this.allInstances.add(hostedImageHeapMap);
            }
            return hostedImageHeapMap.runtimeMap;
        }
        return obj;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        for (ImageHeapMap.HostedImageHeapMap<?, ?> hostedImageHeapMap : this.allInstances) {
            if (!ImageHeapMapFeature.needsUpdate(hostedImageHeapMap)) continue;
            ImageHeapMapFeature.update(hostedImageHeapMap);
            access.rescanObject(hostedImageHeapMap.runtimeMap);
            access.requireAnalysisIteration();
        }
    }

    public boolean imageHeapMapNeedsUpdate() {
        for (ImageHeapMap.HostedImageHeapMap<?, ?> hostedImageHeapMap : this.allInstances) {
            if (!ImageHeapMapFeature.needsUpdate(hostedImageHeapMap)) continue;
            return true;
        }
        return false;
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        for (ImageHeapMap.HostedImageHeapMap<?, ?> hostedImageHeapMap : this.allInstances) {
            if (!ImageHeapMapFeature.needsUpdate(hostedImageHeapMap)) continue;
            throw VMError.shouldNotReachHere("ImageHeapMap modified after static analysis: " + hostedImageHeapMap + System.lineSeparator() + hostedImageHeapMap.runtimeMap);
        }
    }

    private static boolean needsUpdate(ImageHeapMap.HostedImageHeapMap<?, ?> hostedMap) {
        EconomicMap<Object, Object> runtimeMap = hostedMap.runtimeMap;
        if (hostedMap.size() != runtimeMap.size()) {
            return true;
        }
        MapCursor hostedEntry = hostedMap.getEntries();
        while (hostedEntry.advance()) {
            Object runtimeValue;
            Object hostedValue = hostedEntry.getValue();
            if (hostedValue == (runtimeValue = runtimeMap.get(hostedEntry.getKey()))) continue;
            return true;
        }
        return false;
    }

    private static void update(ImageHeapMap.HostedImageHeapMap<?, ?> hostedMap) {
        hostedMap.runtimeMap.clear();
        hostedMap.runtimeMap.putAll(hostedMap);
    }
}

