/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateMetaAccess
implements MetaAccessProvider {
    public static SubstrateMetaAccess singleton() {
        return (SubstrateMetaAccess)ImageSingletons.lookup(SubstrateMetaAccess.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateMetaAccess() {
        ImageSingletons.add(SubstrateMetaAccess.class, (Object)this);
    }

    public SubstrateType lookupJavaType(Class<?> clazz) {
        return this.lookupJavaTypeFromHub(DynamicHub.fromClass(clazz));
    }

    public SubstrateType lookupJavaTypeFromHub(DynamicHub hub) {
        SubstrateType type = (SubstrateType)hub.getMetaType();
        if (type == null) {
            type = new SubstrateType(JavaKind.Object, hub);
        }
        return type;
    }

    public ResolvedJavaMethod lookupJavaMethod(Executable reflectionMethod) {
        throw VMError.unimplemented();
    }

    public ResolvedJavaField lookupJavaField(Field reflectionField) {
        throw VMError.unimplemented();
    }

    public ResolvedJavaType lookupJavaType(JavaConstant constant) {
        if (constant.getJavaKind() != JavaKind.Object || constant.isNull()) {
            return null;
        }
        return ((SubstrateObjectConstant)constant).getType(this);
    }

    public Signature parseMethodDescriptor(String methodDescriptor) {
        throw VMError.unimplemented();
    }

    public JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        return Deoptimizer.encodeDeoptActionAndReason(action, reason, speculationId);
    }

    public DeoptimizationAction decodeDeoptAction(JavaConstant constant) {
        return Deoptimizer.decodeDeoptAction(constant);
    }

    public DeoptimizationReason decodeDeoptReason(JavaConstant constant) {
        return Deoptimizer.decodeDeoptReason(constant);
    }

    public int decodeDebugId(JavaConstant constant) {
        return Deoptimizer.decodeDebugId(constant);
    }

    public int getArrayBaseOffset(JavaKind kind) {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(kind);
    }

    public int getArrayIndexScale(JavaKind elementKind) {
        return ConfigurationValues.getObjectLayout().getArrayIndexScale(elementKind);
    }

    public JavaConstant encodeSpeculation(SpeculationLog.Speculation speculation) {
        return SubstrateObjectConstant.forObject(speculation.getReason());
    }

    public SpeculationLog.Speculation decodeSpeculation(JavaConstant constant, SpeculationLog speculationLog) {
        return new SubstrateSpeculationLog.SubstrateSpeculation((SpeculationLog.SpeculationReason)SubstrateObjectConstant.asObject((Constant)constant));
    }

    public long getMemorySize(JavaConstant constant) {
        throw VMError.unimplemented();
    }
}

