/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.windows.WindowsVMCondition;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.headers.Process;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.WINDOWS.class})
final class WindowsVMLockFeature
implements InternalFeature {
    private final ClassInstanceReplacer<VMMutex, WindowsVMMutex> mutexReplacer = new ClassInstanceReplacer<VMMutex, WindowsVMMutex>(VMMutex.class){

        @Override
        protected WindowsVMMutex createReplacement(VMMutex source) {
            return new WindowsVMMutex(source.getName());
        }
    };
    private final ClassInstanceReplacer<VMCondition, WindowsVMCondition> conditionReplacer = new ClassInstanceReplacer<VMCondition, WindowsVMCondition>(VMCondition.class){

        @Override
        protected WindowsVMCondition createReplacement(VMCondition source) {
            return new WindowsVMCondition((WindowsVMMutex)WindowsVMLockFeature.this.mutexReplacer.apply(source.getMutex()));
        }
    };

    WindowsVMLockFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(VMLockSupport.class, (Object)new WindowsVMLockSupport());
        access.registerObjectReplacer(this.mutexReplacer);
        access.registerObjectReplacer(this.conditionReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int nextIndex = 0;
        WindowsVMMutex[] mutexes = this.mutexReplacer.getReplacements().toArray(new WindowsVMMutex[0]);
        int mutexSize = NumUtil.roundUp((int)SizeOf.get(Process.CRITICAL_SECTION.class), (int)8);
        for (WindowsVMMutex mutex : mutexes) {
            mutex.structOffset = WordFactory.unsigned((long)layout.getArrayElementOffset(JavaKind.Byte, nextIndex));
            nextIndex += mutexSize;
        }
        WindowsVMCondition[] conditions = this.conditionReplacer.getReplacements().toArray(new WindowsVMCondition[0]);
        int conditionSize = NumUtil.roundUp((int)SizeOf.get(Process.CONDITION_VARIABLE.class), (int)8);
        for (WindowsVMCondition condition : conditions) {
            condition.structOffset = WordFactory.unsigned((long)layout.getArrayElementOffset(JavaKind.Byte, nextIndex));
            nextIndex += conditionSize;
        }
        WindowsVMLockSupport lockSupport = WindowsVMLockSupport.singleton();
        lockSupport.mutexes = mutexes;
        lockSupport.conditions = conditions;
        lockSupport.syncStructs = new byte[nextIndex];
    }
}

