/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

public abstract class FastThreadLocal {
    private final LocationIdentity locationIdentity;
    private final String name;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private int maxOffset = Integer.MAX_VALUE;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private boolean allowFloatingReads = false;
    public static final int FIRST_CACHE_LINE = 63;
    public static final int BYTE_OFFSET = 127;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    FastThreadLocal(String name) {
        this.locationIdentity = new FastThreadLocalLocationIdentity();
        this.name = name;
    }

    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public <T extends FastThreadLocal> T setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        return (T)this;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public <T extends FastThreadLocal> T setAllowFloatingReads(boolean allow) {
        this.allowFloatingReads = allow;
        return (T)this;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean getAllowFloatingReads() {
        return this.allowFloatingReads;
    }

    public String getName() {
        return this.name;
    }

    class FastThreadLocalLocationIdentity
    extends LocationIdentity {
        FastThreadLocalLocationIdentity() {
        }

        public boolean isImmutable() {
            return false;
        }

        public String toString() {
            return "FastThreadLocal:" + FastThreadLocal.this.name;
        }
    }
}

