/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.LoomVirtualThreads;
import com.oracle.svm.core.thread.SubstrateVirtualThreads;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@AutomaticallyRegisteredFeature
public class ContinuationsFeature
implements InternalFeature {
    private boolean finishedRegistration = false;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        boolean supportLoom = false;
        if (JavaVersionUtil.JAVA_SPEC == 19) {
            boolean haveLoom = false;
            try {
                haveLoom = (Boolean)Class.forName("jdk.internal.misc.PreviewFeatures").getDeclaredMethod("isEnabled", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            if (!haveLoom) {
                RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"jdk.internal.vm.Continuation"});
            }
            boolean bl = supportLoom = haveLoom && !DeoptimizationSupport.enabled();
        }
        if (supportLoom) {
            LoomVirtualThreads vt = new LoomVirtualThreads();
            ImageSingletons.add(VirtualThreads.class, (Object)vt);
            ImageSingletons.add(LoomVirtualThreads.class, (Object)vt);
        } else if (SubstrateOptions.SupportContinuations.getValue().booleanValue()) {
            if (JavaVersionUtil.JAVA_SPEC == 17) {
                if (DeoptimizationSupport.enabled()) {
                    throw UserError.abort("Virtual threads are enabled, but are currently not supported together with Truffle JIT compilation.", new Object[0]);
                }
                ImageSingletons.add(VirtualThreads.class, (Object)new SubstrateVirtualThreads());
            } else {
                throw UserError.abort("Virtual threads are supported only on JDK 19 with preview features enabled (--enable-preview).", new Object[0]);
            }
        }
        this.finishedRegistration = true;
    }

    boolean hasFinishedRegistration() {
        return this.finishedRegistration;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Continuation.isSupported()) {
            if (!ImageSingletons.contains(ContinuationSupport.class)) {
                ImageSingletons.add(ContinuationSupport.class, (Object)new ContinuationSupport());
            }
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            access.registerAsAccessed(ipField);
            access.registerReachabilityHandler(a -> access.registerAsInHeap(StoredContinuation.class), new Object[]{ReflectionUtil.lookupMethod(StoredContinuationAccess.class, (String)"allocate", (Class[])new Class[]{Integer.TYPE})});
        } else {
            access.registerReachabilityHandler(a -> ContinuationsFeature.abortIfUnsupported(), new Object[]{StoredContinuationAccess.class});
            if (JavaVersionUtil.JAVA_SPEC >= 19) {
                access.registerReachabilityHandler(a -> ContinuationsFeature.abortIfUnsupported(), new Object[]{ReflectionUtil.lookupMethod(Thread.class, (String)"ofVirtual", (Class[])new Class[0]), ReflectionUtil.lookupMethod(Thread.class, (String)"startVirtualThread", (Class[])new Class[]{Runnable.class})});
            }
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (Continuation.isSupported()) {
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            long offset = access.objectFieldOffset(ipField);
            ContinuationSupport.singleton().setIPOffset(offset);
        }
    }

    static void abortIfUnsupported() {
        if (!Continuation.isSupported()) {
            if (DeoptimizationSupport.enabled()) {
                throw UserError.abort("Virtual threads are used in code, but are currently not supported together with Truffle JIT compilation.", new Object[0]);
            }
            throw UserError.abort("Virtual threads are used in code, but are not currently available or active. Use JDK 19 with preview features enabled (--enable-preview).", new Object[0]);
        }
    }
}

