/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.amd64;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.amd64.AMD64ReservedRegisters;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.amd64.AMD64;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

@AutomaticallyRegisteredImageSingleton(value={RegisterDumper.class})
@Platforms(value={Platform.DARWIN_AMD64.class})
class AMD64DarwinUContextRegisterDumper
implements UContextRegisterDumper {
    AMD64DarwinUContextRegisterDumper() {
        VMError.guarantee(AMD64.r14.equals((Object)AMD64ReservedRegisters.HEAP_BASE_REGISTER_CANDIDATE));
        VMError.guarantee(AMD64.r15.equals((Object)AMD64ReservedRegisters.THREAD_REGISTER_CANDIDATE));
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        Signal.AMD64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_amd64();
        RegisterDumper.dumpReg(log, "RAX ", ((Pointer)sigcontext).readLong(sigcontext.rax_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RBX ", ((Pointer)sigcontext).readLong(sigcontext.rbx_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RCX ", ((Pointer)sigcontext).readLong(sigcontext.rcx_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RDX ", ((Pointer)sigcontext).readLong(sigcontext.rdx_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RBP ", ((Pointer)sigcontext).readLong(sigcontext.rbp_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RSI ", ((Pointer)sigcontext).readLong(sigcontext.rsi_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RDI ", ((Pointer)sigcontext).readLong(sigcontext.rdi_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RSP ", ((Pointer)sigcontext).readLong(sigcontext.rsp_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R8  ", ((Pointer)sigcontext).readLong(sigcontext.r8_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R9  ", ((Pointer)sigcontext).readLong(sigcontext.r9_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R10 ", ((Pointer)sigcontext).readLong(sigcontext.r10_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R11 ", ((Pointer)sigcontext).readLong(sigcontext.r11_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R12 ", ((Pointer)sigcontext).readLong(sigcontext.r12_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R13 ", ((Pointer)sigcontext).readLong(sigcontext.r13_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R14 ", ((Pointer)sigcontext).readLong(sigcontext.r14_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R15 ", ((Pointer)sigcontext).readLong(sigcontext.r15_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "EFL ", ((Pointer)sigcontext).readLong(sigcontext.efl_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RIP ", ((Pointer)sigcontext).readLong(sigcontext.rip_offset()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.AMD64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_amd64();
        return (PointerBase)((Pointer)sigcontext).readWord(sigcontext.r14_offset());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.AMD64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_amd64();
        return (PointerBase)((Pointer)sigcontext).readWord(sigcontext.r15_offset());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getSP(Signal.ucontext_t uContext) {
        Signal.AMD64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_amd64();
        return (PointerBase)((Pointer)sigcontext).readWord(sigcontext.rsp_offset());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getIP(Signal.ucontext_t uContext) {
        Signal.AMD64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_amd64();
        return (PointerBase)((Pointer)sigcontext).readWord(sigcontext.rip_offset());
    }
}

