/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.invoke.MethodHandleUtils;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_LambdaForm;
import com.oracle.svm.core.methodhandles.Util_java_lang_invoke_MethodHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;

@TargetClass(className="java.lang.invoke.MethodHandle")
final class Target_java_lang_invoke_MethodHandle {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private MethodHandle asTypeCache;
    @Alias
    MethodType type;

    Target_java_lang_invoke_MethodHandle() {
    }

    @Alias
    native Target_java_lang_invoke_MemberName internalMemberName();

    @Alias
    native Target_java_lang_invoke_LambdaForm internalForm();

    @Substitute(polymorphicSignature=true)
    Object invokeBasic(Object ... args) throws Throwable {
        Object ret;
        Target_java_lang_invoke_MemberName memberName = this.internalMemberName();
        if (memberName != null) {
            ret = Util_java_lang_invoke_MethodHandle.invokeInternal(memberName, this.type, args);
        } else {
            Target_java_lang_invoke_LambdaForm form = this.internalForm();
            Object[] interpreterArguments = new Object[args.length + 1];
            interpreterArguments[0] = this;
            System.arraycopy(args, 0, interpreterArguments, 1, args.length);
            ret = form.interpretWithArguments(interpreterArguments);
        }
        return MethodHandleUtils.cast(ret, this.type.returnType());
    }

    @Substitute(polymorphicSignature=true)
    Object invoke(Object ... args) throws Throwable {
        MethodHandle self = SubstrateUtil.cast(this, MethodHandle.class);
        return self.asType(self.type()).invokeExact(args);
    }

    @Substitute(polymorphicSignature=true)
    Object invokeExact(Object ... args) throws Throwable {
        return this.invokeBasic(args);
    }

    @Substitute(polymorphicSignature=true)
    static Object linkToVirtual(Object ... args) throws Throwable {
        return Util_java_lang_invoke_MethodHandle.linkTo(true, args);
    }

    @Substitute(polymorphicSignature=true)
    static Object linkToStatic(Object ... args) throws Throwable {
        return Util_java_lang_invoke_MethodHandle.linkTo(false, args);
    }

    @Substitute(polymorphicSignature=true)
    static Object linkToInterface(Object ... args) throws Throwable {
        return Util_java_lang_invoke_MethodHandle.linkTo(true, args);
    }

    @Substitute(polymorphicSignature=true)
    static Object linkToSpecial(Object ... args) throws Throwable {
        return Util_java_lang_invoke_MethodHandle.linkTo(true, args);
    }
}

