/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.Target_java_lang_String;
import com.oracle.svm.core.jdk.Target_java_lang_StringUTF16;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

public final class JavaLangSubstitutions {

    static class ClassValueInitializer
    implements FieldValueTransformer {
        ClassValueInitializer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            ClassValueSupport support = (ClassValueSupport)ImageSingletons.lookup(ClassValueSupport.class);
            ClassValue v = (ClassValue)receiver;
            Map<Class<?>, Object> map = support.values.get(v);
            assert (map != null);
            return map;
        }
    }

    public static final class ClassValueSupport {
        public static final Object NULL_MARKER = new Object();
        final Map<ClassValue<?>, Map<Class<?>, Object>> values;

        public ClassValueSupport(Map<ClassValue<?>, Map<Class<?>, Object>> map) {
            this.values = map;
        }
    }

    public static final class StringUtil {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static char charAt(String string, int index) {
            Target_java_lang_String str = SubstrateUtil.cast(string, Target_java_lang_String.class);
            byte[] value = str.value;
            if (str.isLatin1()) {
                return (char)(value[index] & 0xFF);
            }
            return Target_java_lang_StringUTF16.getChar(value, index);
        }

        public static byte coder(String string) {
            return SubstrateUtil.cast(string, Target_java_lang_String.class).coder();
        }
    }
}

