/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.jvmstat;

import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.jvmstat.SerialGCPerfData;
import com.oracle.svm.core.jvmstat.PerfDataHolder;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class EpsilonGCPerfData
implements PerfDataHolder {
    private final SerialGCPerfData.SpacePerfData space = new SerialGCPerfData.SpacePerfData(1, 0);
    private final SerialGCPerfData.PerfDataGeneration generation = new SerialGCPerfData.PerfDataGeneration(1, new SerialGCPerfData.SpacePerfData[]{this.space});

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public EpsilonGCPerfData() {
    }

    @Override
    public void allocate() {
        this.generation.allocate("Heap");
        this.space.allocate("Heap");
    }

    @Override
    public void update() {
        long maxCapacity = GCImpl.getPolicy().getMaximumHeapSize().rawValue();
        long usedBytes = HeapImpl.getHeapImpl().getAccounting().getEdenUsedBytes().rawValue();
        this.space.used.setValue(usedBytes);
        this.generation.capacity.setValue(usedBytes);
        this.generation.maxCapacity.setValue(maxCapacity);
    }
}

