/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalMTSupport;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.Pointer;

final class ThreadLocalMTWalker {
    ThreadLocalMTWalker() {
    }

    static void walk(ObjectReferenceVisitor referenceVisitor) {
        VMThreadLocalMTSupport threadLocals = (VMThreadLocalMTSupport)ImageSingletons.lookup(VMThreadLocalMTSupport.class);
        NonmovableArray<Byte> threadRefMapEncoding = NonmovableArrays.fromImageHeap((Object)threadLocals.vmThreadReferenceMapEncoding);
        IsolateThread vmThread = VMThreads.firstThread();
        while (vmThread.isNonNull()) {
            InstanceReferenceMapDecoder.walkOffsetsFromPointer((Pointer)vmThread, threadRefMapEncoding, threadLocals.vmThreadReferenceMapIndex, referenceVisitor, null);
            vmThread = VMThreads.nextThread(vmThread);
        }
    }
}

